/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.SetFlagsType;
import java.util.logging.Level;

public class SetFlagsClosure
extends MessageClosure {
    public SetFlagsClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getSetFlags() != null;
    }

    protected void handleMessage(Message message) {
        TaskId taskId;
        MutableTask mutableTask;
        SetFlagsType setFlagsType = message.getInfo().getSetFlags();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved set flags message");
        }
        if ((mutableTask = this.getTaskById(taskId = this.createTaskId(message.getInfo().getCmdId()))) == null) {
            this.live.getMainSystem().logEvent(Level.WARNING, String.format("SetFlags message received for unknown command: %d", message.getInfo().getCmdId()));
            return;
        }
        for (String string : setFlagsType.getFlag()) {
            if (string.startsWith("guiflag")) {
                int n = string.indexOf(61);
                String string2 = string.substring(n + 1);
                if (string2.length() == 0) {
                    this.live.getMainSystem().logEvent(Level.WARNING, "GUI flags received without any values.  Ignoring flag");
                    continue;
                }
                mutableTask.addGuiFlags(string2);
            }
            CommandEventImpl commandEventImpl = new CommandEventImpl((Object)this, CommandEvent.CommandEventType.SET_FLAGS, string, (Task)mutableTask);
            commandEventImpl.setCurrentOperation(true);
            this.live.publishEvent(commandEventImpl);
        }
    }
}

