/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.util.Guid;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.jaxb.ipc.Message;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public abstract class MessageClosure
implements Closure,
Predicate {
    static final Map<String, Color> getColor = new HashMap<String, Color>();
    protected LiveCommandDispatcher live;
    private int count = 0;

    public MessageClosure(LiveCommandDispatcher liveCommandDispatcher) {
        this.live = liveCommandDispatcher;
    }

    public void execute(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Message) {
            this.handleMessage((Message)Message.class.cast(object));
        }
    }

    public boolean evaluate(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Message && this.evaluateMessage((Message)Message.class.cast(object))) {
            ++this.count;
            return true;
        }
        return false;
    }

    protected abstract void handleMessage(Message var1);

    protected abstract boolean evaluateMessage(Message var1);

    protected final TaskId createTaskId(int n) {
        return this.live.createTaskId(n);
    }

    protected final MutableTask getTaskByTaskId(Guid guid) {
        Task task = this.live.getMainSystem().getTaskByTaskId(guid);
        if (task instanceof MutableTask) {
            return (MutableTask)task;
        }
        return null;
    }

    protected final void registerTaskId(MutableTask mutableTask) {
        this.live.getMainSystem().registerTaskId(mutableTask);
    }

    protected final MutableTask getTaskById(TaskId taskId) {
        Task task = this.live.getMainSystem().getTaskById(taskId);
        if (task instanceof MutableTask) {
            return (MutableTask)task;
        }
        return null;
    }

    protected final Task getTaskByTempId(int n) {
        Task task = this.live.getMainSystem().getTaskByTempId(n);
        if (task instanceof MutableTask) {
            return (MutableTask)task;
        }
        return null;
    }

    protected final int asInteger(String string) {
        if (string == null) {
            return 0;
        }
        try {
            if (string.toLowerCase().startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.toLowerCase().startsWith("0") && string.length() > 1) {
                return Integer.parseInt(string.substring(1, 8));
            }
            return Integer.parseInt(string, 10);
        }
        catch (Exception exception) {
            this.live.getMainSystem().logEvent(Level.SEVERE, "Cannot parse integer: " + string, exception);
            return 0;
        }
    }

    protected final Color lookup(String string) {
        Color color = getColor.get(string);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public void dump() {
        System.out.println(String.format("%s:  %d", this.getClass().getSimpleName(), this.count));
    }

    static {
        getColor.put("black", new Color(0, 0, 0));
        getColor.put("green", new Color(0, 128, 0));
        getColor.put("blue", new Color(0, 0, 196));
        getColor.put("darkblue", new Color(0, 0, 128));
        getColor.put("yellow", new Color(128, 128, 0));
        getColor.put("organe", new Color(255, 128, 0));
        getColor.put("red", new Color(150, 0, 0));
        getColor.put("brightred", new Color(255, 0, 0));
        getColor.put("gray", new Color(128, 128, 160));
        getColor.put("white", new Color(255, 255, 255));
    }
}

