/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.util.Guid;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.impl.task.FileAccess;
import ds.jaxb.ipc.DataInfoType;
import ds.jaxb.ipc.Message;
import java.io.File;
import java.util.logging.Level;

public class DataInfoClosure
extends MessageClosure {
    public DataInfoClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getDataInfo() != null;
    }

    protected void handleMessage(Message message) {
        DataInfoType dataInfoType = message.getInfo().getDataInfo();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved command data message");
        }
        String string = dataInfoType.getLog();
        Guid guid = Guid.GenerateGuid((String)dataInfoType.getTaskId());
        MutableTask mutableTask = this.getTaskByTaskId(guid);
        if (mutableTask == null) {
            this.live.getMainSystem().logEvent(Level.WARNING, String.format("Command data received for unknown transaction %s\n LogFile: %s", guid.toString(), string));
            return;
        }
        mutableTask.addDataInformation((TaskDataAccess)new FileAccess((Task)mutableTask, TaskDataAccess.DataType.DATA, new File(String.format("%s/%s", this.live.getMainSystem().getLogDirectory(), string)), string, mutableTask.getNextOrdinal()));
    }
}

