/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.GuiCommand;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.util.Pair;
import ddb.util.SocketConnectedPredicate;
import ds.core.CommandFormatter;
import ds.core.commanddispatcher.AbstractCommandDispatcher;
import ds.core.commanddispatcher.CommandDispatcher;
import ds.core.commanddispatcher.EventPublisher;
import ds.core.commanddispatcher.MultipleCommandDispatcherClient;
import ds.core.commanddispatcher.live.CommandInfoClosure;
import ds.core.commanddispatcher.live.CommandListClosure;
import ds.core.commanddispatcher.live.CommandOutputClosure;
import ds.core.commanddispatcher.live.CommandResultClosure;
import ds.core.commanddispatcher.live.CommandStartedClosure;
import ds.core.commanddispatcher.live.ConnectionInfoClosure;
import ds.core.commanddispatcher.live.DataInfoClosure;
import ds.core.commanddispatcher.live.GuiCommandClosure;
import ds.core.commanddispatcher.live.HelpClosure;
import ds.core.commanddispatcher.live.IdMapClosure;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commanddispatcher.live.PongClosure;
import ds.core.commanddispatcher.live.SetFlagsClosure;
import ds.core.commanddispatcher.live.SetTitleClosure;
import ds.core.commanddispatcher.live.ShutdownClosure;
import ds.core.commanddispatcher.live.StartPromptClosure;
import ds.core.commanddispatcher.live.StatisticsClosure;
import ds.core.commanddispatcher.live.StopPromptClosure;
import ds.core.commanddispatcher.live.ThrottleClosure;
import ds.core.commandevents.GuiCommandImpl;
import ds.core.controller.MutableCoreController;
import ds.core.impl.task.TaskImpl;
import ds.jaxb.ipc.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.SwitchClosure;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveCommandDispatcher
extends AbstractCommandDispatcher
implements CommandDispatcher {
    public static final String LIVE_IN = "LiveCommandDispatcher Input";
    public static final String LIVE_PARSED = "LiveCommandDispatcher Parsed";
    public static final String LIVE_OUT = "LiveCommandDispatcher Output";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    Closure messageClosures;
    final MessageClosure[] listOfClosures = new MessageClosure[]{new CommandOutputClosure(this), new CommandStartedClosure(this), new CommandResultClosure(this), new DataInfoClosure(this), new CommandInfoClosure(this), new StatisticsClosure(this), new SetFlagsClosure(this), new CommandListClosure(this), new ThrottleClosure(this), new StartPromptClosure(this), new StopPromptClosure(this), new IdMapClosure(this), new ConnectionInfoClosure(this), new SetTitleClosure(this), new HelpClosure(this), new GuiCommandClosure(this), new PongClosure(this), new ShutdownClosure(this)};
    private Predicate isSocketConnected;
    private Socket socket;
    private BufferedInputStream bufInStream;
    private BufferedOutputStream bufOutStream;
    private CommandFormatter formatter;
    private final Object INCOMING_LOCK;
    private BlockingQueue<Message> incomingMessages;
    private BlockingQueue<Message> outgoingMessages;
    private final MutableCoreController mainSystem;
    private Map<String, String> helpCache;
    private boolean useHelpCache = true;
    private Map<Integer, Pair<IdCallback, Object>> callbacks;
    private MultipleCommandDispatcherClient.ObtainedOperationCallback callback;
    boolean readFinished = false;
    boolean failureNotified = false;

    public LiveCommandDispatcher(EventPublisher eventPublisher, MutableCoreController mutableCoreController, Socket socket, MultipleCommandDispatcherClient.ObtainedOperationCallback obtainedOperationCallback) throws IOException, JAXBException {
        super(eventPublisher, mutableCoreController);
        this.messageClosures = SwitchClosure.getInstance((Predicate[])this.listOfClosures, (Closure[])this.listOfClosures, (Closure)new Closure(){

            public void execute(Object object) {
                LiveCommandDispatcher.this.mainSystem.logEvent(Level.SEVERE, String.format("Unhandled item: %s", object));
            }
        });
        this.isSocketConnected = SocketConnectedPredicate.getInstance();
        this.INCOMING_LOCK = new Object();
        this.incomingMessages = new LinkedBlockingQueue<Message>();
        this.outgoingMessages = new LinkedBlockingQueue<Message>();
        this.helpCache = new LRUMap(10);
        this.callbacks = new Hashtable<Integer, Pair<IdCallback, Object>>();
        this.socket = socket;
        this.mainSystem = mutableCoreController;
        this.callback = obtainedOperationCallback;
        this.formatter = new CommandFormatter("xml/schema/ipcComms.xsd");
        this.bufInStream = new BufferedInputStream(socket.getInputStream());
        this.bufOutStream = new BufferedOutputStream(socket.getOutputStream());
        Thread[] threadArray = new Thread[]{mutableCoreController.newThread(new Runnable(){

            public void run() {
                LiveCommandDispatcher.this.handleSocket();
            }
        }), mutableCoreController.newThread(new Runnable(){

            public void run() {
                LiveCommandDispatcher.this.handleOutgoingMessages();
            }
        }), mutableCoreController.newThread(new Runnable(){

            public void run() {
                LiveCommandDispatcher.this.handleMessages();
            }
        })};
        threadArray[0].setName("LiveCommandDispatcher:  Read From socket");
        threadArray[1].setName("LiveCommandDispatcher:  Write To socket");
        threadArray[2].setName("LiveCommandDispatcher:  Handle Incoming Messages");
        for (Thread thread : threadArray) {
            thread.start();
        }
    }

    private int getNextIncomingMessage(byte[] byArray) throws IOException {
        return this.bufInStream.read(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSocket() {
        block21: {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (!this.readFinished && this.isSocketConnected.evaluate((Object)this.socket)) {
                    byte[] byArray = new byte[8096];
                    int n = this.getNextIncomingMessage(byArray);
                    if (n == -1) {
                        this.bufInStream.close();
                        this.socket.close();
                        this.socket = null;
                        this.readFinished = true;
                        return;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (byArray[i] != 1) continue;
                        byteArrayOutputStream.write(byArray, 0, i);
                        String string = new String(byteArrayOutputStream.toByteArray(), UTF8);
                        byteArrayOutputStream.reset();
                        if (this.core.isDebugMode()) {
                            this.core.logEvent(Level.FINEST, LIVE_IN, "Message IN:   \n" + string);
                        }
                        try {
                            Message message = this.formatter.unmarshallReceivedBytes(new StringReader(string));
                            Object object = this.INCOMING_LOCK;
                            synchronized (object) {
                                this.incomingMessages.put(message);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                int n2 = 8;
                                for (int j = 0; j < n; j += n2) {
                                    int n3;
                                    for (n3 = 0; n3 < n2; ++n3) {
                                        if (j + n3 < n) {
                                            System.out.printf("%02x ", byArray[j + n3]);
                                            continue;
                                        }
                                        System.out.print("  ");
                                    }
                                    System.out.print("  ");
                                    for (n3 = 0; n3 < n2 && j + n3 < n; ++n3) {
                                        if (byArray[j + n3] < 32 || byArray[j + n3] > 123) {
                                            System.out.print(".");
                                        } else {
                                            System.out.printf("%c", byArray[j + n3]);
                                        }
                                        System.out.print("  ");
                                    }
                                    System.out.println();
                                }
                                System.out.println(new String(byArray, 0, n, UTF8));
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            this.core.logEvent(Level.WARNING, String.format("Unable to unmarshall data:\n%s\n", string), (Throwable)exception);
                        }
                        n -= i + 1;
                        byArray = Arrays.copyOfRange(byArray, i + 1, byArray.length);
                        i = 0;
                    }
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (SocketException socketException) {
                this.core.logEvent(Level.SEVERE, "Socket exception in comms thread\n" + socketException.toString(), (Throwable)socketException);
                this.mainSystem.lpConnectionTerminated();
                this.socket = null;
            }
            catch (IOException iOException) {
                this.core.logEvent(Level.SEVERE, "IOException caught in handle socket routine\n" + iOException.toString(), (Throwable)iOException);
                if (this.isSocketConnected.evaluate((Object)this.socket)) break block21;
                this.socketBroken();
                this.core.logEvent(Level.SEVERE, "Connection to dispatcher has been lost");
                this.mainSystem.lpConnectionTerminated();
            }
        }
    }

    @Override
    public void publishEvent(CommandEvent commandEvent) {
        super.publishEvent(commandEvent);
        if (commandEvent instanceof GuiCommand) {
            this.mainSystem.schedule(new GuiCommandRerun((GuiCommand)GuiCommand.class.cast(commandEvent)), 1L, TimeUnit.MINUTES);
            this.mainSystem.schedule(new GuiCommandFailed((GuiCommand)GuiCommand.class.cast(commandEvent)), 2L, TimeUnit.MINUTES);
        }
    }

    private Message getNextOutgoingMessage() {
        try {
            return this.outgoingMessages.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.core.logEvent(Level.FINE, interruptedException.getMessage(), (Throwable)interruptedException);
            return null;
        }
    }

    public void handleOutgoingMessages() {
        block4: while (true) {
            try {
                while (this.isSocketConnected.evaluate((Object)this.socket)) {
                    Message message = this.getNextOutgoingMessage();
                    if (message == null) continue;
                    byte[] byArray = this.formatter.formatMessageAsByteArray(message);
                    try {
                        if (this.mainSystem.isDebugMode()) {
                            this.mainSystem.logEvent(Level.FINEST, LIVE_OUT, "Message OUT: \n" + new String(byArray));
                        }
                        this.bufOutStream.write(byArray);
                        this.bufOutStream.write(1);
                        this.bufOutStream.flush();
                        continue block4;
                    }
                    catch (IOException iOException) {
                        this.core.logEvent(Level.SEVERE, "IOException caught in handle socket routine\n" + iOException.toString(), (Throwable)iOException);
                        if (this.isSocketConnected.evaluate((Object)this.socket)) continue;
                        this.socketBroken();
                        this.core.logEvent(Level.SEVERE, "Connection to dispatcher has been lost");
                        this.mainSystem.lpConnectionTerminated();
                    }
                }
                break;
            }
            catch (JAXBException jAXBException) {
                this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleMessages() {
        block8: while (true) {
            if (this.incomingMessages.size() <= 0) {
                if (this.isSocketConnected.evaluate((Object)this.socket) == false) return;
            }
            var1_1 = null;
            var2_2 = this.INCOMING_LOCK;
            // MONITORENTER : this.INCOMING_LOCK
            var1_1 = this.incomingMessages.toArray(new Message[this.incomingMessages.size()]);
            this.incomingMessages.clear();
            // MONITOREXIT : var2_2
            if (var1_1 == null || var1_1.length == 0) {
                try {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                catch (Exception var2_3) {}
                continue;
            }
            var2_2 = var1_1;
            var3_4 = var2_2.length;
            var4_5 = 0;
            while (true) {
                if (var4_5 < var3_4) ** break;
                continue block8;
                var5_6 = var2_2[var4_5];
                if (this.core.isDebugMode()) {
                    try {
                        var6_7 = this.formatter.formatMessageAsString(var5_6);
                        this.core.logEvent(Level.FINEST, "LiveCommandDispatcher Parsed", "Rcvd from disp:  \n" + var6_7);
                    }
                    catch (JAXBException var6_8) {
                        this.core.logEvent(Level.SEVERE, var6_8.getMessage(), (Throwable)var6_8);
                    }
                }
                try {
                    this.messageClosures.execute((Object)var5_6);
                }
                catch (Throwable var6_9) {
                    this.core.logEvent(Level.SEVERE, var6_9.getMessage(), var6_9);
                }
                ++var4_5;
            }
            break;
        }
    }

    public void handleUnknownTaskPrompt(Message message) {
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        if (this.socket.isClosed()) {
            return false;
        }
        return this.socket.isConnected();
    }

    public void addPrefixes(TaskId taskId, List<String> list) throws DispatcherException, IOException, JAXBException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createAddPrefixes(taskId, list));
    }

    private void enqueMessage(Message message) {
        try {
            this.outgoingMessages.put(message);
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, "Unable to enque message!");
            return;
        }
    }

    public void disconnect() {
        if (this.isSocketConnected.evaluate((Object)this.socket)) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.mainSystem.logEvent(Level.WARNING, "Error while closing socket", iOException);
            }
        } else {
            return;
        }
    }

    public void interruptCommand(TaskId taskId) throws JAXBException, IOException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            this.mainSystem.logEvent(Level.INFO, "interruptCommand: Not sending interrupt.  No dispatcher connection");
            return;
        }
        this.enqueMessage(this.formatter.createInterruptCommand(taskId));
    }

    public void requestCommandListUpdate() throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createListCommands());
    }

    public void requestHelpStatement(String string, HostInfo hostInfo) throws JAXBException, IOException {
        String string2 = this.helpCache.get(string);
        this.enqueMessage(this.formatter.createGetHelp(string, hostInfo));
    }

    public int requestStatistics() throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        Message message = this.formatter.createGetStatistics();
        this.enqueMessage(message);
        return message.getReq().getReqId();
    }

    public void setUseHelpCache(boolean bl) {
        this.useHelpCache = bl;
    }

    public void restartCommandOutput(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createRestartOutput(taskId));
    }

    public void sendPing() throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createPing());
    }

    public void sendPromptReply(int n, TaskId taskId, String string) throws IOException, JAXBException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createUserEntry(n, taskId, string));
    }

    public void sendPromptStopped(TaskId taskId, int n) throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createPromptStopped(n, taskId));
    }

    public void sendShutdownNotification() throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.sendPing();
        this.enqueMessage(this.formatter.createShutdown());
        this.mainSystem.schedule(new Runnable(){
            private int id = 0;

            public void run() {
                try {
                    LiveCommandDispatcher.this.sendPing();
                    LiveCommandDispatcher.this.mainSystem.schedule(this, 1L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCommand(String string, IdCallback idCallback, Object object, HostInfo hostInfo) throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        TaskImpl taskImpl = new TaskImpl(string, hostInfo);
        Object object2 = this.mainSystem;
        synchronized (object2) {
            this.mainSystem.addNewTask(taskImpl);
        }
        taskImpl.setState(TaskState.TASKED);
        object2 = taskImpl.getTempId();
        this.callbacks.put((Integer)object2, (Pair<IdCallback, Object>)new Pair((Object)idCallback, object));
        this.enqueMessage(this.formatter.createStartCommand(taskImpl));
    }

    public void stopCommand(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            this.mainSystem.logEvent(Level.INFO, "stopCommand: Not sending stop.  No dispatcher connection");
            return;
        }
        this.enqueMessage(this.formatter.createStopCommand(taskId));
    }

    public void stopCommandOutput(TaskId taskId) throws JAXBException, IOException, DispatcherException {
        if (!this.isSocketConnected.evaluate((Object)this.socket)) {
            throw new DispatcherException("Not connected");
        }
        this.enqueMessage(this.formatter.createStopOutput(taskId));
    }

    @Override
    public void setOperation(Operation operation) {
        super.setOperation(operation);
        this.callback.obtainedOperation(this.op, this);
    }

    public MutableCoreController getMainSystem() {
        return this.mainSystem;
    }

    public Pair<IdCallback, Object> extractCallback(int n) {
        return this.callbacks.remove(n);
    }

    public void installHelp(String string, String string2) {
        this.helpCache.put(string, string2);
    }

    public CommandFormatter getFormatter() {
        return this.formatter;
    }

    public void sendGuiCommandResponse(int n, boolean bl) {
        this.enqueMessage(this.formatter.createGuiCommandResponse(n, bl));
    }

    private synchronized void socketBroken() {
        if (this.failureNotified) {
            return;
        }
        this.failureNotified = true;
        JOptionPane.showMessageDialog(null, "<html>The interprocess communication socket has failed.<p>Communication with the core has stopped.<p>No new commands may be issued.", "Socket Broken", 0);
    }

    private class GuiCommandFailed
    implements Runnable {
        final GuiCommand cmd;

        public GuiCommandFailed(GuiCommand guiCommand) {
            this.cmd = guiCommand;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GuiCommand guiCommand = this.cmd;
            synchronized (guiCommand) {
                if (this.cmd.isHandled()) {
                    return;
                }
                this.cmd.handled();
            }
            LiveCommandDispatcher.this.sendGuiCommandResponse(this.cmd.getReqId(), false);
        }
    }

    private class GuiCommandRerun
    implements Runnable {
        final GuiCommand cmd;

        public GuiCommandRerun(GuiCommand guiCommand) {
            this.cmd = guiCommand;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GuiCommand guiCommand = this.cmd;
            synchronized (guiCommand) {
                if (this.cmd.isHandled()) {
                    return;
                }
                if (this.cmd instanceof GuiCommandImpl) {
                    ((GuiCommandImpl)GuiCommandImpl.class.cast(this.cmd)).eraseTask();
                }
                LiveCommandDispatcher.this.publisher.publish((CommandEvent)this.cmd);
            }
        }
    }
}

