/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import ddb.detach.TabbableStatus;
import ddb.detach.TabbableStatusImpl;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.ConnectionChangeListener;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import ddb.misc.ColorPalette;
import ddb.util.UtilityConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jdesktop.layout.GroupLayout;

public class StatusBar
extends JPanel
implements Observer,
ConnectionChangeListener {
    private static final BoundedRangeModel DEFAULT_MODEL = new DefaultBoundedRangeModel(0, 1, 0, 100);
    private static final TabbableStatus DEFAULT_STATUS = new TabbableStatusImpl(null);
    private static final ScheduledExecutorService exec = new ScheduledThreadPoolExecutor(1, UtilityConstants.createThreadFactory((String)"StatusBar"));
    private static final int MAX_ITER = 10;
    private static final int FACTOR = 4;
    private static final int FLASH_PER_SECOND = 2;
    private final Map<HostInfo, Integer> flashCount = Collections.synchronizedMap(new HashMap());
    private static final ColorPalette disconnected = new ColorPalette(Color.WHITE, true, new Color[]{Color.RED, Color.GREEN, Color.DARK_GRAY, Color.BLUE});
    private static final ColorPalette local = new ColorPalette(Color.WHITE, true, new Color[]{Color.RED});
    private static final ColorPalette connected = new ColorPalette(Color.BLACK, false, new Color[0]);
    TabbableStatus status = null;
    Color hostDefaultBackground;
    Color hostDefaultForeground;
    Color detailsDefaultBackground;
    Color detailsDefaultForeground;
    HostInfo currentHost = null;
    Runnable updater = new Runnable(){

        public void run() {
            if (EventQueue.isDispatchThread()) {
                this.run2();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run2() {
            Integer n = 0;
            String string = null;
            ColorPalette colorPalette = null;
            if (StatusBar.this.currentHost == null) {
                string = "";
                colorPalette = connected;
            } else if (StatusBar.this.currentHost.isLocal()) {
                StatusBar.this.flashCount.put(StatusBar.this.currentHost, 0);
                string = StatusBar.this.currentHost.getId();
                colorPalette = local;
            } else if (StatusBar.this.currentHost.isConnected()) {
                StatusBar.this.flashCount.put(StatusBar.this.currentHost, 0);
                string = StatusBar.this.currentHost.getId();
                colorPalette = connected;
            } else if (!StatusBar.this.currentHost.isConnected()) {
                string = "Disconnected";
                n = (Integer)StatusBar.this.flashCount.get(StatusBar.this.currentHost);
                if (n == null) {
                    n = 40;
                }
                if (n < 40) {
                    Integer n2 = n;
                    Integer n3 = n = Integer.valueOf(n + 1);
                    StatusBar.this.flashCount.put(StatusBar.this.currentHost, n);
                }
                colorPalette = disconnected;
            }
            if (string == null || colorPalette == null) {
                return;
            }
            StatusBar.this.statusHost.setText(string);
            StatusBar.this.statusHost.setForeground(colorPalette.getForeground(n * 2 / 4));
            StatusBar.this.statusHost.setBackground(colorPalette.getBackground(n * 2 / 4));
            StatusBar.this.statusHost.setOpaque(colorPalette.isOpaque());
        }
    };
    private JPanel detailsPanel;
    private JPanel hostPanel;
    private JLabel jLabel3;
    private JPanel progressPanel;
    private JLabel statusDetails;
    private JLabel statusHost;
    private JLabel statusIcon;
    private JProgressBar statusProgress;
    private final Object STATUS_LOCK = new Object();
    private SetStatus pending = null;

    public StatusBar() {
        this.initComponents();
        this.hostDefaultBackground = this.statusHost.getBackground();
        this.hostDefaultForeground = this.hostPanel.getForeground();
        this.detailsDefaultBackground = this.statusDetails.getBackground();
        this.detailsDefaultForeground = this.detailsPanel.getForeground();
        exec.scheduleWithFixedDelay(this.updater, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.hostPanel = new JPanel();
        this.statusHost = new JLabel();
        this.detailsPanel = new JPanel();
        this.statusDetails = new JLabel();
        this.progressPanel = new JPanel();
        this.statusIcon = new JLabel();
        this.statusProgress = new JProgressBar();
        this.jLabel3.setText("jLabel3");
        this.setOpaque(false);
        this.hostPanel.setBorder(BorderFactory.createEtchedBorder());
        this.hostPanel.setOpaque(false);
        this.statusHost.setHorizontalAlignment(0);
        this.statusHost.setText("127.0.0.1");
        this.statusHost.setOpaque(true);
        GroupLayout groupLayout = new GroupLayout((Container)this.hostPanel);
        this.hostPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.statusHost, -1, 114, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.statusHost, -1, -1, Short.MAX_VALUE));
        this.detailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPanel.setOpaque(false);
        this.statusDetails.setText("Plugin Status");
        this.statusDetails.setOpaque(true);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.detailsPanel);
        this.detailsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.statusDetails, -1, 330, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.statusDetails, -1, -1, Short.MAX_VALUE));
        this.statusIcon.setText("icon");
        this.statusIcon.setMaximumSize(this.statusIcon.getPreferredSize());
        this.statusIcon.setMinimumSize(this.statusIcon.getPreferredSize());
        this.statusIcon.setPreferredSize(new Dimension(16, 16));
        this.statusIcon.setText("");
        GroupLayout groupLayout3 = new GroupLayout((Container)this.progressPanel);
        this.progressPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.statusProgress, -1, 116, 116).addPreferredGap(0).add((Component)this.statusIcon, -2, -1, -2)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.statusIcon, -2, -1, -2).add((Component)this.statusProgress, -1, 18, 18));
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.hostPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.detailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.progressPanel, -2, 139, -2)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.progressPanel, -1, 18, Short.MAX_VALUE).add((Component)this.hostPanel, -1, -1, Short.MAX_VALUE).add((Component)this.detailsPanel, -1, -1, Short.MAX_VALUE));
    }

    public void setStatus(TabbableStatus tabbableStatus) {
        this.setStatus(tabbableStatus, null);
    }

    public void setStatus(TabbableStatus tabbableStatus, Object object) {
        if (this.status != null) {
            this.status.deleteObserver((Observer)this);
        }
        this.status = tabbableStatus;
        if (this.status != null) {
            this.status.addObserver((Observer)this);
        }
        this.update2(this.status, object);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof TabbableStatus) {
            this.update2((TabbableStatus)TabbableStatus.class.cast(observable), object);
        }
    }

    public void update2(TabbableStatus tabbableStatus, Object object) {
        if (tabbableStatus == null) {
            tabbableStatus = DEFAULT_STATUS;
        }
        this.currentHost = object instanceof Plugin ? ((Plugin)Plugin.class.cast(object)).getTarget() : (object instanceof SingleTargetInterface ? ((SingleTargetInterface)SingleTargetInterface.class.cast(object)).getTarget() : null);
        SetStatus setStatus = new SetStatus(tabbableStatus.getDetails().getText());
        setStatus.setPanelForeground(tabbableStatus.getDetails().getForeground());
        setStatus.setProgress(tabbableStatus.getProgressModel(), tabbableStatus.isIndeterminate());
        if (tabbableStatus.getDetails().getBackground() != null) {
            setStatus.setDetails(true, tabbableStatus.getDetails().getForeground(), tabbableStatus.getDetails().getBackground());
        } else {
            setStatus.setDetails(false, this.detailsDefaultForeground, this.detailsDefaultBackground);
        }
        this.invokeStatus(setStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeStatus(SetStatus setStatus) {
        Object object = this.STATUS_LOCK;
        synchronized (object) {
            if (this.pending != null) {
                UtilityConstants.ShallowCopy((Object)this.pending, (Object)setStatus, SetStatus.class);
                return;
            }
            this.pending = setStatus;
        }
        EventQueue.invokeLater(setStatus);
    }

    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
    }

    private class SetStatus
    implements Runnable {
        String details;
        Color detailsForeground;
        Color detailsBackground;
        Color panelForeground;
        boolean opaque;
        BoundedRangeModel model;
        boolean indeterminate;
        Icon icon;

        public SetStatus(String string) {
            this.details = string;
        }

        public void setPanelForeground(Color color) {
            this.panelForeground = color;
        }

        public void setDetails(boolean bl, Color color, Color color2) {
            this.opaque = bl;
            this.detailsBackground = color2;
            this.detailsForeground = color;
        }

        public void setProgress(BoundedRangeModel boundedRangeModel, boolean bl) {
            this.model = boundedRangeModel;
            this.indeterminate = bl;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = StatusBar.this.STATUS_LOCK;
            synchronized (object) {
                StatusBar.this.pending = null;
            }
            if (this.model == null) {
                this.model = DEFAULT_MODEL;
            }
            StatusBar.this.statusDetails.setText(this.details);
            StatusBar.this.statusDetails.setForeground(this.detailsForeground);
            StatusBar.this.statusDetails.setBackground(this.detailsBackground);
            StatusBar.this.detailsPanel.setForeground(this.panelForeground);
            StatusBar.this.statusDetails.setOpaque(this.opaque);
            StatusBar.this.statusProgress.setModel(this.model);
            StatusBar.this.statusProgress.setIndeterminate(this.indeterminate);
            StatusBar.this.statusIcon.setIcon(this.icon);
            StatusBar.this.updater.run();
        }

        public String toString() {
            return String.format("Status (%s)", this.details);
        }
    }
}

