/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import com.birosoft.liquid.LiquidLookAndFeel;
import ddb.GuiConstants;
import ddb.detach.TabNavigationListener;
import ddb.imagemanager.ImageManager;
import ddb.util.JaxbCache;
import ds.core.commandevents.CommandEventDemultiplexorImpl;
import ds.jaxb.mimemap.MimeMap;
import ds.jaxb.mimemap.MimeMapList;
import ds.jaxb.mimemap.ObjectFactory;
import ds.util.contextmenu.ContextMenuImpl;
import ds.util.datatransforms.CommandMetaDataClosure;
import ds.util.datatransforms.DataTransformerImpl2;
import ds.util.datatransforms.DisplayTaskClosure;
import ds.util.datatransforms.ReadXmlClosure;
import ds.util.datatransforms.VariableTaskClosure;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSConstants {
    public static final String HIDE_PLUGIN_ICON = "images/folder_sent_mail.png";
    public static final String OPTIONS_ICON = "images/utilities.png";
    public static final String NEW_INSTANCE_ICON = "images/edit_add.png";
    public static final String APP_TITLE = "DanderSpritz";
    public static final String REPLAY_TITLE = "DanderSpritz Replay";
    public static final String VERSION = "1.2";
    public static final String LP_CONFIG_FILE = "config.xml";
    public static final String IMAGE_REGISTER_FILE = "resources/icons.xml";
    public static final String IPC_COMMS_SCHEMA = "xml/schema/ipcComms.xsd";
    public static final int IPC_COMMS_END_CODE = 1;
    public static final String DS_ICON = "images/Rupert.png";
    public static final String SPLASHSCREEN_MAIN_ICON = "images/earth.png";
    public static final String KEYBINDINGS = "keybindings.xml";
    public static final String DEFAULT_RESOURCE_DIRECTORY = "Dsz";
    public static final String MIME_MAP_LOCATION = "images/mime-types/mime-map.xml";
    private static Map<String, String> suffixToIcon = null;
    public static int FRAME_WIDTH = 500;
    public static int FRAME_HEIGHT = 500;
    public static int WINDOW_WIDTH = 500;
    public static int WINDOW_HEIGHT = 500;
    public static int MAIN_TAB_ALIGNMENT = 1;
    public static int SUB_TAB_ALIGNMENT = 2;
    private static ClassLoader loader = null;
    public static final Color DEFAULT_BG_COLOR = Color.BLACK;
    public static final Color DEFAULT_FG_COLOR = Color.LIGHT_GRAY;
    public static final Color SECONDARY_FG_COLOR = Color.BLUE;
    public static final Color SECONDARY_BG_COLOR = Color.LIGHT_GRAY;
    public static final Color PROMPT_MODE_BG_COLOR = Color.RED;
    public static final Color PROMPT_MODE_FG_COLOR = Color.YELLOW;
    public static final Color ERROR_COLOR = Color.RED;
    public static final Color WARNING_COLOR = Color.YELLOW;
    public static final Color NOTICE_COLOR = Color.GREEN;
    public static final int ITALIC = -1;
    public static final int BOLD = -2;
    public static final int UNDERLINE = -3;
    public static final int DEFAULT = 0;
    public static final int EMERGENCY = 1;
    public static final int ALERT = 2;
    public static final int CRITICAL = 3;
    public static final int ERROR = 4;
    public static final int WARNING = 5;
    public static final int NOTICE = 6;
    public static final int INFO = 7;
    public static final int DEBUG = 8;
    public static final String LOGGER_NAME = "ds.core";
    public static final int SYNC_CORE = 100;
    public static final int SYNC_CORE_SUB = 1000;
    public static final int SYNC_PLUGIN = 10000;
    public static final int SYNC_PLUGIN_SUB = 100000;
    public static final String DSZ_KEYWORD = "DSZ_KEYWORD";
    public static Map<String, String> GENERAL_SETTINGS = new HashMap<String, String>();
    private static Dimension LABEL_SIZE = ImageManager.SIZE16;
    private static Dimension TAB_SIZE = ImageManager.SIZE32;

    public static void setLoader(ClassLoader classLoader) {
        loader = classLoader;
        JaxbCache.setClassLoader((ClassLoader)classLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static final List<File> getStartupConfigurationFiles(File file, String string) {
        String string2 = System.getProperty(DSZ_KEYWORD);
        if (file == null) {
            return Collections.emptyList();
        }
        String string3 = "Gui/Config/";
        String string4 = string2 == null ? String.format("%s.xml", string) : String.format("%s_%s.xml", string, string2);
        Vector<String> vector = new Vector<String>();
        vector.add(".");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                vector.add(file2.getName());
            }
        }
        Vector vector2 = new Vector();
        for (String string5 : vector) {
            File file2;
            file2 = new File(file, String.format("%s/%s/%s", string5, string3, string4));
            if (!file2.exists()) continue;
            vector2.add(file2);
        }
        return vector2;
    }

    public static String getOsString() {
        String string = System.getProperty("os.name");
        if (string.regionMatches(true, 0, "Windows", 0, 6)) {
            return System.getProperty("windows.tool.chain", "i386-winnt-vc6");
        }
        return System.getProperty("linux.tool.chain", "i386-linux_se-gcc");
    }

    public static void addLibraryPath(String string) {
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            String[] stringArray;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String string3 : stringArray = (String[])field.get(null)) {
                if (!string3.equals(string2)) continue;
                return;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            field.set(null, stringArray2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static ThreadFactory namedFactory(final String string) {
        return new ThreadFactory(){
            int i = 0;

            public synchronized Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format("%s %d", string, ++this.i));
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIcon(String string) {
        String string2 = MIME_MAP_LOCATION;
        synchronized (MIME_MAP_LOCATION) {
            if (suffixToIcon == null) {
                suffixToIcon = new HashMap<String, String>();
                JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
                try {
                    Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                    Object object = unmarshaller.unmarshal(DSConstants.getClassLoader().getResource(MIME_MAP_LOCATION));
                    if (object instanceof JAXBElement) {
                        object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
                    }
                    if (object instanceof MimeMapList) {
                        for (MimeMap mimeMap : ((MimeMapList)MimeMapList.class.cast(object)).getMap()) {
                            suffixToIcon.put(mimeMap.getSuffix(), "images/mime-types/" + mimeMap.getIcon());
                        }
                    }
                }
                catch (Exception exception) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (string == null) {
                return null;
            }
            return suffixToIcon.get(string.toLowerCase());
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream inputStream) {
        try {
            return XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            return null;
        }
    }

    public static boolean jumpRight(JComponent jComponent) {
        return TabNavigationListener.jumpRight((JComponent)jComponent);
    }

    public static boolean jumpLeft(JComponent jComponent) {
        return TabNavigationListener.jumpLeft((JComponent)jComponent);
    }

    public static void InstallDefaults() {
        final Class<LiquidLookAndFeel> clazz = LiquidLookAndFeel.class;
        System.setProperty("swing.defaultlaf", clazz.getCanonicalName());
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel(clazz.getCanonicalName());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.put("BreadcrumbBar.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Button.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("CheckBox.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("CheckBoxMenuItem.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ColorChooser.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ComboBox.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("EditorPane.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Label.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("List.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Menu.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("MenuBar.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("MenuItem.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("PopupMenu.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("OptionPane.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Panel.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("PasswordField.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ProgressBar.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("RadioButton.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("RadioButtonMenuItem.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ScrollPane.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TabbedPane.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Table.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TableHeader.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TextArea.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TextField.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TextPane.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("TitledBorder.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ToggleButton.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ToolBar.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("ToolTip.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Tree.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        UIManager.put("Viewport.font", GuiConstants.FIXED_WIDTH_FONT.Basic);
        DSConstants.registerDefault("CommandEventDemultiplexor.impl", CommandEventDemultiplexorImpl.class);
        DSConstants.registerDefault("DataTranformer.impl", DataTransformerImpl2.class);
        DSConstants.registerDefault("CommandMetaData.impl", CommandMetaDataClosure.class);
        DSConstants.registerDefault("VariableClosure.impl", VariableTaskClosure.class);
        DSConstants.registerDefault("DisplayClosure.impl", DisplayTaskClosure.class);
        DSConstants.registerDefault("XmlStringClosure.impl", ReadXmlClosure.class);
        DSConstants.registerDefault("ContextMenu.Impl", ContextMenuImpl.class);
    }

    private static void registerDefault(String string, Class<?> clazz) {
        System.setProperty(string, clazz.getCanonicalName());
    }

    static void setLabelImageSize(Dimension dimension) {
        LABEL_SIZE = dimension;
    }

    static void setTabImageSize(Dimension dimension) {
        TAB_SIZE = dimension;
    }

    public static Dimension getLabelImageSize() {
        return LABEL_SIZE;
    }

    public static Dimension getTabImageSize() {
        return TAB_SIZE;
    }

    private DSConstants() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StageIcon {
        INTERNAL_DATA("images/coreStageInternalData.png"),
        STARTUP_CONFIG("images/coreStageStartupConfig.png"),
        PLUGIN("images/coreStagePlugins.png"),
        SOCKET("images/coreStageWaiting.png"),
        WAITING("images/coreStageSocket.png");

        String path;

        private StageIcon(String string2) {
            this.path = string2;
        }

        public String getPath() {
            return this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Icon {
        ABOUT("images/about.png"),
        ERROR("images/fatal.png"),
        INFO("images/info.png"),
        WARNING("images/warning.png"),
        QUIT("images/quit.png"),
        DEBUG("images/bug-buddy.png"),
        LOCAL("images/yast_accessx.png");

        String path;

        private Icon(String string2) {
            this.path = string2;
        }

        public String getPath() {
            return this.path;
        }
    }
}

