/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console;

import ddb.GuiConstants;
import java.awt.EventQueue;
import java.awt.Font;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.LazyMap;

public class ConsoleStyledDocument
extends DefaultStyledDocument {
    Map<MultiKey, Font> fontMap = LazyMap.decorate((Map)new LRUMap(5), (Transformer)new Transformer(){

        public Object transform(Object object) {
            Font font = GuiConstants.FIXED_WIDTH_FONT.Basic;
            if (object instanceof MultiKey) {
                MultiKey multiKey = (MultiKey)object;
                font = font.deriveFont(Float.valueOf(String.format("%d", multiKey.getKey(0))).floatValue()).deriveFont((Integer)multiKey.getKey(1));
            }
            return font;
        }
    });
    private int MaximumCharacters = 0;
    private int CurrentCharacters = 0;
    private Runnable g_Clear = null;

    public void setMaximumCharacters(int n) {
        this.MaximumCharacters = n;
    }

    public void appendString(String string, final AttributeSet attributeSet) throws BadLocationException {
        if (this.MaximumCharacters > 0 && string.length() > this.MaximumCharacters) {
            string = string.substring(string.length() - this.MaximumCharacters);
        }
        if (!EventQueue.isDispatchThread()) {
            final String string2 = string;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ConsoleStyledDocument.this.appendString(string2, attributeSet);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            return;
        }
        this.insertString(this.CurrentCharacters, string, attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(final int n, final String string, final AttributeSet attributeSet) throws BadLocationException {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ConsoleStyledDocument.this.insertString(n, string, attributeSet);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            return;
        }
        this.readLock();
        try {
            if (this.g_Clear != null) {
                return;
            }
        }
        finally {
            this.readUnlock();
        }
        int n2 = n;
        String string2 = string;
        if (this.MaximumCharacters > 0 && string2.length() > this.MaximumCharacters) {
            string2 = string2.substring(string2.length() - this.MaximumCharacters);
        }
        if (this.MaximumCharacters > 0) {
            if (string2.length() == this.MaximumCharacters) {
                this.remove(0, this.CurrentCharacters);
                n2 = 0;
            } else if (string2.length() + this.CurrentCharacters > this.MaximumCharacters) {
                int n3 = this.CurrentCharacters - (this.MaximumCharacters - string2.length());
                this.remove(0, n3);
                n2 -= n3;
            }
        }
        super.insertString(n2, string2, attributeSet);
        this.CurrentCharacters += string2.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(final int n, final int n2) throws BadLocationException {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ConsoleStyledDocument.this.remove(n, n2);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            return;
        }
        this.readLock();
        try {
            if (this.g_Clear != null) {
                return;
            }
        }
        finally {
            this.readUnlock();
        }
        try {
            super.remove(n, n2);
            this.CurrentCharacters -= n2;
        }
        catch (BadLocationException badLocationException) {
            System.err.printf("Invalid remove of %d bytes at %d\n", n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!EventQueue.isDispatchThread()) {
            this.writeLock();
            try {
                this.g_Clear = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ConsoleStyledDocument.this.readLock();
                        try {
                            if (this != ConsoleStyledDocument.this.g_Clear) {
                                return;
                            }
                        }
                        finally {
                            ConsoleStyledDocument.this.readUnlock();
                        }
                        ConsoleStyledDocument.this.writeLock();
                        try {
                            ConsoleStyledDocument.this.g_Clear = null;
                        }
                        finally {
                            ConsoleStyledDocument.this.writeUnlock();
                        }
                        ConsoleStyledDocument.this.clear();
                    }
                };
                EventQueue.invokeLater(this.g_Clear);
            }
            finally {
                this.writeUnlock();
            }
            return;
        }
        try {
            this.remove(0, this.CurrentCharacters);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Font getFont(AttributeSet attributeSet) {
        Font font = super.getFont(attributeSet);
        return this.fontMap.get(new MultiKey((Object)super.getFont(attributeSet).getSize(), (Object)font.getStyle()));
    }
}

