/*
 * Decompiled with CFR 0.152.
 */
package ddb.gui.javalogviewer;

import ddb.gui.swing.DszTableCellRenderer;
import ddb.imagemanager.ImageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JLabel;
import javax.swing.JTable;

public class LevelTableCellRenderer
extends DszTableCellRenderer {
    public static final String SEVERE_ICON = "images/error.png";
    public static final String WARNING_ICON = "images/important.png";
    public static final String INFO_ICON = "images/mimetypes.png";
    public static final String CONFIG_ICON = "images/exec.png";
    public static final String FINE_ICON = "images/kedit.png";
    public static final String FINER_ICON = "images/kate.png";
    public static final String FINEST_ICON = "images/korganizer.png";
    JLabel severe = new JLabel("SEVERE");
    JLabel warning = new JLabel("WARNING");
    JLabel info = new JLabel("INFO");
    JLabel config = new JLabel("CONFIG");
    JLabel fine = new JLabel("FINE");
    JLabel finer = new JLabel("FINER");
    JLabel finest = new JLabel("FINEST");
    int maximumValue = 127;

    private Color brighter(Color color, int n) {
        if (n == 0) {
            return color;
        }
        return this.brighter(color.brighter(), n - 1);
    }

    private Color darker(Color color, int n) {
        if (n == 0) {
            return color;
        }
        return this.darker(color.darker(), n - 1);
    }

    public LevelTableCellRenderer(Dimension dimension) {
        this.severe.setBackground(this.brighter(Color.RED, 0));
        this.warning.setBackground(this.darker(Color.YELLOW, 0));
        this.severe.setIcon(ImageManager.getIcon((String)SEVERE_ICON, (Dimension)dimension));
        this.warning.setIcon(ImageManager.getIcon((String)WARNING_ICON, (Dimension)dimension));
        this.config.setIcon(ImageManager.getIcon((String)CONFIG_ICON, (Dimension)dimension));
        this.info.setIcon(ImageManager.getIcon((String)INFO_ICON, (Dimension)dimension));
        this.fine.setIcon(ImageManager.getIcon((String)FINE_ICON, (Dimension)dimension));
        this.finer.setIcon(ImageManager.getIcon((String)FINER_ICON, (Dimension)dimension));
        this.finest.setIcon(ImageManager.getIcon((String)FINEST_ICON, (Dimension)dimension));
        this.severe.setOpaque(true);
        this.warning.setOpaque(true);
        this.info.setOpaque(true);
        this.config.setOpaque(true);
        this.fine.setOpaque(true);
        this.finer.setOpaque(true);
        this.finest.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof LogRecord) {
            object = ((LogRecord)LogRecord.class.cast(object)).getLevel();
        }
        if (object.equals(Level.SEVERE)) {
            return this.severe;
        }
        if (object.equals(Level.WARNING)) {
            return this.warning;
        }
        if (object.equals(Level.INFO)) {
            return this.info;
        }
        if (object.equals(Level.CONFIG)) {
            return this.config;
        }
        if (object.equals(Level.FINE)) {
            return this.fine;
        }
        if (object.equals(Level.FINER)) {
            return this.finer;
        }
        if (object.equals(Level.FINEST)) {
            return this.finest;
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }
}

