/*
 * Decompiled with CFR 0.152.
 */
package ddb.gui.javalogviewer;

import ddb.gui.javalogviewer.CalendarTimeCellRenderer;
import ddb.gui.javalogviewer.LevelPredicate;
import ddb.gui.javalogviewer.LevelTableCellRenderer;
import ddb.gui.javalogviewer.LogRecordTableColumns;
import ddb.gui.javalogviewer.LogRecordTableModel;
import ddb.imagemanager.ImageManager;
import ddb.util.FrequentlyAppendedTableModel;
import ddb.util.checkedtablemodel.CheckableFilterList;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import ddb.util.predicate.StringContainsPredicate;
import ddb.util.predicate.UnionListPredicate;
import ddb.util.tablefilter.FilteredTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Predicate;
import org.jdesktop.layout.GroupLayout;

public class JavaLogViewer
extends JPanel {
    LogRecordTableModel recordModel = new LogRecordTableModel();
    CheckableFilterList<String> sectionFilterTable;
    UnionListPredicate<String> sectionPredicate = new UnionListPredicate(false);
    UnionListPredicate<Integer> threadPredicate = new UnionListPredicate(true);
    LevelPredicate levelPredicate = new LevelPredicate();
    StringContainsPredicate commentContainsPredicate = new StringContainsPredicate();
    ColumnHidingModel hideColumns = new ColumnHidingModel(LogRecordTableColumns.class);
    FilteredTableModel filterModel = new FilteredTableModel((TableModel)((Object)this.recordModel));
    private JPanel bottomPanel;
    private ButtonGroup buttonGroup1;
    private JLabel classField;
    private JLabel classLabel;
    private JButton clearButton;
    private JTextArea detailsDisplay;
    private JScrollPane detailsScroller;
    private JRadioButton discardMessages;
    private JLabel filterLabel;
    private JPanel filterPanel;
    private JPanel headerPanel;
    private JRadioButton holdMessages;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JRadioButton keepAllMessages;
    private JPanel leftPanel;
    private JLabel levelField;
    private JLabel levelLabel;
    private JComboBox levelSelector;
    private JSplitPane mainDisplay;
    private JTextField messageFilter;
    private JLabel methodField;
    private JLabel methodLabel;
    private JTable recordTable;
    private JPanel rightPanel;
    private JPanel sectionPanel;
    private JRadioButton showMessages;
    private JScrollPane tablePanel;
    private JLabel timeField;
    private JLabel timeLabel;
    private JPanel topPanel;

    void setColumnWidth() {
        for (int i = 0; i < this.recordTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.recordTable.getColumnModel().getColumn(i);
            for (LogRecordTableColumns logRecordTableColumns : LogRecordTableColumns.values()) {
                if (!tableColumn.getHeaderValue().equals(logRecordTableColumns.getName()) || logRecordTableColumns.getDefaultValue() == null) continue;
                this.setColumnWidth(tableColumn, logRecordTableColumns.getDefaultValue(), false, logRecordTableColumns.isBinding());
            }
        }
    }

    private void setColumnWidth(TableColumn tableColumn, String string, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel(string);
        int n = jLabel.getPreferredSize().width;
        tableColumn.setPreferredWidth(n + 10);
        tableColumn.setWidth(n + 10);
        if (bl2) {
            tableColumn.setMaxWidth(n + 15);
            tableColumn.setMinWidth(n + 5);
        }
    }

    public void setMaximum(int n) {
        this.recordModel.setMaximum(n);
    }

    public void append(final LogRecord logRecord) {
        if (logRecord.getLoggerName() == null || logRecord.getLoggerName().trim().length() == 0) {
            logRecord.setLoggerName("Unknown");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (JavaLogViewer.this.sectionFilterTable.addElement((Object)logRecord.getLoggerName(), true)) {
                    JavaLogViewer.this.sectionPredicate.addItem((Object)logRecord.getLoggerName());
                }
            }
        });
        this.recordModel.addRecord(logRecord);
    }

    void doFilter() {
        this.commentContainsPredicate.setString(this.messageFilter.getText());
        this.filterModel.filterChanged();
    }

    public JavaLogViewer() {
        this.sectionFilterTable = new CheckableFilterList("Sections", (CheckedTableSelection)new CheckedTableCallback(), String.CASE_INSENSITIVE_ORDER);
        this.filterModel.setModel((TableModel)((Object)this.recordModel));
        this.filterModel.addFilter((Predicate)this.levelPredicate, new Enum[]{LogRecordTableColumns.LEVEL});
        this.filterModel.addFilter(this.sectionPredicate, new Enum[]{LogRecordTableColumns.LOGGER});
        this.filterModel.addFilter((Predicate)this.commentContainsPredicate, new Enum[]{LogRecordTableColumns.MESSAGE});
        this.initComponents();
        this.levelSelector.setSelectedItem(this.levelPredicate.level);
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.levelSelector = new JComboBox();
        this.clearButton = new JButton();
        this.mainDisplay = new JSplitPane();
        this.topPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.sectionPanel = new JPanel();
        this.discardMessages = new JRadioButton();
        this.holdMessages = new JRadioButton();
        this.showMessages = new JRadioButton();
        this.filterLabel = new JLabel();
        this.messageFilter = new JTextField();
        this.keepAllMessages = new JRadioButton();
        this.tablePanel = new JScrollPane();
        this.recordTable = new JTable();
        this.bottomPanel = new JPanel();
        this.headerPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.levelLabel = new JLabel();
        this.methodLabel = new JLabel();
        this.methodField = new JLabel();
        this.levelField = new JLabel();
        this.leftPanel = new JPanel();
        this.timeLabel = new JLabel();
        this.classLabel = new JLabel();
        this.timeField = new JLabel();
        this.classField = new JLabel();
        this.detailsScroller = new JScrollPane();
        this.detailsDisplay = new JTextArea();
        this.jLabel5.setText("jLabel5");
        this.jLabel1.setText("jLabel1");
        this.levelSelector.addItem(Level.SEVERE);
        this.levelSelector.addItem(Level.WARNING);
        this.levelSelector.addItem(Level.INFO);
        this.levelSelector.addItem(Level.CONFIG);
        this.levelSelector.addItem(Level.FINE);
        this.levelSelector.addItem(Level.FINER);
        this.levelSelector.addItem(Level.FINEST);
        this.levelSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JavaLogViewer.this.levelSelectorItemStateChanged(itemEvent);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaLogViewer.this.clearButtonActionPerformed(actionEvent);
            }
        });
        this.mainDisplay.setOrientation(0);
        this.mainDisplay.setResizeWeight(0.8);
        GroupLayout groupLayout = new GroupLayout((Container)this.sectionPanel);
        this.sectionPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 177, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 192, Short.MAX_VALUE));
        this.buttonGroup1.add(this.discardMessages);
        this.discardMessages.setText("Discard New Messages");
        this.discardMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.discardMessages.setMargin(new Insets(0, 0, 0, 0));
        this.discardMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaLogViewer.this.filterPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.holdMessages);
        this.holdMessages.setText("Hold New Messages");
        this.holdMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.holdMessages.setMargin(new Insets(0, 0, 0, 0));
        this.holdMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaLogViewer.this.filterPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.showMessages);
        this.showMessages.setSelected(true);
        this.showMessages.setText("Show New Messages");
        this.showMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showMessages.setMargin(new Insets(0, 0, 0, 0));
        this.showMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaLogViewer.this.filterPerformed(actionEvent);
            }
        });
        this.filterLabel.setText("Message:");
        this.messageFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JavaLogViewer.this.messageFilterKeyReleased(keyEvent);
            }
        });
        this.buttonGroup1.add(this.keepAllMessages);
        this.keepAllMessages.setText("Keep All Messages");
        this.keepAllMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepAllMessages.setMargin(new Insets(0, 0, 0, 0));
        this.keepAllMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaLogViewer.this.filterPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.filterPanel);
        this.filterPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.holdMessages, -1, 157, Short.MAX_VALUE).add(2, (Component)this.showMessages, -1, 157, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.messageFilter, -1, 107, Short.MAX_VALUE)).add(2, (Component)this.discardMessages, -1, 157, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.keepAllMessages, -1, 155, Short.MAX_VALUE).add(2, 2, 2))).addContainerGap()).add((Component)this.sectionPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.sectionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.messageFilter, -2, -1, -2)).addPreferredGap(0).add((Component)this.showMessages).addPreferredGap(0).add((Component)this.holdMessages).addPreferredGap(0).add((Component)this.discardMessages).addPreferredGap(0).add((Component)this.keepAllMessages)));
        this.sectionPanel.setLayout(new BorderLayout());
        this.sectionPanel.add((Component)this.sectionFilterTable, "Center");
        this.recordTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.recordTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    Object object = JavaLogViewer.this.filterModel.getValueAt(JavaLogViewer.this.recordTable.getSelectedRow(), LogRecordTableColumns.LEVEL.ordinal());
                    if (object != null && object instanceof LogRecord) {
                        LogRecord logRecord = (LogRecord)LogRecord.class.cast(object);
                        JavaLogViewer.this.timeField.setText(String.format("%d", logRecord.getMillis()));
                        JavaLogViewer.this.classField.setText(logRecord.getSourceClassName());
                        JavaLogViewer.this.levelField.setText(logRecord.getLevel().getLocalizedName());
                        JavaLogViewer.this.methodField.setText(logRecord.getSourceMethodName());
                        if (logRecord.getThrown() != null) {
                            Throwable throwable = logRecord.getThrown();
                            StringWriter stringWriter = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(stringWriter));
                            JavaLogViewer.this.detailsDisplay.setText(stringWriter.toString());
                        } else {
                            JavaLogViewer.this.detailsDisplay.setText(logRecord.getMessage());
                        }
                        JavaLogViewer.this.detailsDisplay.setSelectionStart(0);
                        JavaLogViewer.this.detailsDisplay.setSelectionEnd(0);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JavaLogViewer.this.timeField.setText("");
                JavaLogViewer.this.classField.setText("");
                JavaLogViewer.this.levelField.setText("");
                JavaLogViewer.this.methodField.setText("");
                JavaLogViewer.this.detailsDisplay.setText("");
            }
        });
        this.tablePanel.setViewportView(this.recordTable);
        this.recordTable.setColumnModel((TableColumnModel)this.hideColumns);
        this.recordTable.setModel((TableModel)this.filterModel);
        this.hideColumns.applyToTable(this.recordTable);
        this.recordTable.setDefaultRenderer(Calendar.class, (TableCellRenderer)((Object)new CalendarTimeCellRenderer()));
        this.recordTable.setDefaultRenderer(LogRecord.class, (TableCellRenderer)((Object)new LevelTableCellRenderer(ImageManager.SIZE16)));
        this.hideColumns.hide((Enum)LogRecordTableColumns.TIME);
        this.setColumnWidth();
        GroupLayout groupLayout3 = new GroupLayout((Container)this.topPanel);
        this.topPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.tablePanel, -1, 480, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.filterPanel, -2, -1, -2)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.filterPanel, -1, -1, Short.MAX_VALUE).add(11, 11, 11)).add((Component)this.tablePanel, -1, 313, Short.MAX_VALUE));
        this.mainDisplay.setTopComponent(this.topPanel);
        this.levelLabel.setFont(this.levelLabel.getFont().deriveFont(this.levelLabel.getFont().getStyle() | 1));
        this.levelLabel.setText("Level:");
        this.methodLabel.setFont(this.methodLabel.getFont().deriveFont(this.methodLabel.getFont().getStyle() | 1));
        this.methodLabel.setText("Method:");
        this.methodField.setText(" ");
        this.levelField.setText(" ");
        GroupLayout groupLayout4 = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.methodLabel).addPreferredGap(0).add((Component)this.methodField, -1, 275, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.levelLabel).add(18, 18, 18).add((Component)this.levelField, -1, 276, Short.MAX_VALUE))).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.levelLabel).add((Component)this.levelField)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.methodLabel).add((Component)this.methodField)).addContainerGap(-1, Short.MAX_VALUE)));
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(this.timeLabel.getFont().getStyle() | 1));
        this.timeLabel.setText("Time:");
        this.classLabel.setFont(this.classLabel.getFont().deriveFont(this.classLabel.getFont().getStyle() | 1));
        this.classLabel.setText("Class:");
        this.timeField.setText(" ");
        this.classField.setText(" ");
        GroupLayout groupLayout5 = new GroupLayout((Container)this.leftPanel);
        this.leftPanel.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.classLabel).addPreferredGap(0).add((Component)this.classField, -1, 272, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.timeLabel).addPreferredGap(0).add((Component)this.timeField, -1, 273, Short.MAX_VALUE))).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.timeLabel).add((Component)this.timeField)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3, false).add((Component)this.classLabel).add((Component)this.classField, -2, 14, -2)).addContainerGap()));
        GroupLayout groupLayout6 = new GroupLayout((Container)this.headerPanel);
        this.headerPanel.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.leftPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.rightPanel, -1, -1, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.rightPanel, -2, -1, -2).add((Component)this.leftPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.detailsDisplay.setColumns(20);
        this.detailsDisplay.setRows(5);
        this.detailsScroller.setViewportView(this.detailsDisplay);
        GroupLayout groupLayout7 = new GroupLayout((Container)this.bottomPanel);
        this.bottomPanel.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (Component)this.headerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.detailsScroller, -1, 663, Short.MAX_VALUE));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add((GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.headerPanel, -2, 48, -2).addPreferredGap(0).add((Component)this.detailsScroller, -1, 72, Short.MAX_VALUE)));
        this.mainDisplay.setRightComponent(this.bottomPanel);
        GroupLayout groupLayout8 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout8);
        groupLayout8.setHorizontalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout8.createSequentialGroup().add((Component)this.levelSelector, 0, 600, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.clearButton)).add((Component)this.mainDisplay, -1, 665, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup((GroupLayout.Group)groupLayout8.createParallelGroup(1).add((GroupLayout.Group)groupLayout8.createSequentialGroup().add((GroupLayout.Group)groupLayout8.createParallelGroup(3).add((Component)this.clearButton).add((Component)this.levelSelector, -2, -1, -2)).addPreferredGap(0).add((Component)this.mainDisplay, -1, 446, Short.MAX_VALUE)));
    }

    private void clearButtonActionPerformed(ActionEvent actionEvent) {
        this.recordModel.clear();
    }

    private void levelSelectorItemStateChanged(ItemEvent itemEvent) {
        Level level;
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        Object object = itemEvent.getItem();
        if (object instanceof Level && (level = (Level)Level.class.cast(object)) != null) {
            this.levelPredicate.level = level;
            this.filterModel.filterChanged();
        }
    }

    private void messageFilterKeyReleased(KeyEvent keyEvent) {
        this.doFilter();
    }

    private void filterPerformed(ActionEvent actionEvent) {
        if (this.showMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.SHOW);
        }
        if (this.discardMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.DISCARD);
        }
        if (this.holdMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.HOLD);
        }
        if (this.keepAllMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.KEEP);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageState {
        SHOW,
        HOLD,
        DISCARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CheckedTableCallback
    implements CheckedTableSelection<String> {
        private CheckedTableCallback() {
        }

        public void selected(String string, boolean bl) {
            if (bl) {
                JavaLogViewer.this.sectionPredicate.addItem((Object)string.toString());
            } else {
                JavaLogViewer.this.sectionPredicate.removeItem((Object)string.toString());
            }
            JavaLogViewer.this.filterModel.filterChanged();
        }
    }
}

