/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.tokenmarker.Token;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    int currentLineIndex;
    Token currentLineTokens;
    Segment currentLine;
    protected JEditTextArea textArea;
    protected SyntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean paintInvalid;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected Highlight highlights;

    public TextAreaPainter(JEditTextArea jEditTextArea, TextAreaDefaults textAreaDefaults) {
        this.textArea = jEditTextArea;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(new Font("Monospaced", 0, 14));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.blockCaret = textAreaDefaults.blockCaret;
        this.styles = textAreaDefaults.styles;
        this.cols = textAreaDefaults.cols;
        this.rows = textAreaDefaults.rows;
        this.caretColor = textAreaDefaults.caretColor;
        this.selectionColor = textAreaDefaults.selectionColor;
        this.lineHighlightColor = textAreaDefaults.lineHighlightColor;
        this.lineHighlight = textAreaDefaults.lineHighlight;
        this.bracketHighlightColor = textAreaDefaults.bracketHighlightColor;
        this.bracketHighlight = textAreaDefaults.bracketHighlight;
        this.paintInvalid = textAreaDefaults.paintInvalid;
        this.eolMarkerColor = textAreaDefaults.eolMarkerColor;
        this.eolMarkers = textAreaDefaults.eolMarkers;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] syntaxStyleArray) {
        this.styles = syntaxStyleArray;
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        this.invalidateSelectedLines();
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.invalidateSelectedLines();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
        this.invalidateSelectedLines();
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean bl) {
        this.lineHighlight = bl;
        this.invalidateSelectedLines();
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final void setBracketHighlightEnabled(boolean bl) {
        this.bracketHighlight = bl;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean bl) {
        this.blockCaret = bl;
        this.invalidateSelectedLines();
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color color) {
        this.eolMarkerColor = color;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean bl) {
        this.eolMarkers = bl;
        this.repaint();
    }

    public boolean getInvalidLinesPainted() {
        return this.paintInvalid;
    }

    public void setInvalidLinesPainted(boolean bl) {
        this.paintInvalid = bl;
    }

    public void addCustomHighlight(Highlight highlight) {
        highlight.init(this.textArea, this.highlights);
        this.highlights = highlight;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.highlights != null) {
            return this.highlights.getToolTipText(mouseEvent);
        }
        return null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    public void paint(Graphics graphics) {
        this.tabSize = this.fm.charWidth(' ') * (Integer)this.textArea.getDocument().getProperty("tabSize");
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = this.fm.getHeight();
        int n2 = this.textArea.getFirstLine();
        int n3 = n2 + rectangle.y / n;
        int n4 = n2 + (rectangle.y + rectangle.height - 1) / n;
        try {
            int n5;
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            int n6 = this.textArea.getHorizontalOffset();
            for (n5 = n3; n5 <= n4; ++n5) {
                this.paintLine(graphics, tokenMarker, n5, n6);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                n5 = rectangle.y + rectangle.height;
                this.repaint(0, n5, this.getWidth(), this.getHeight() - n5);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n3 + "," + n4 + "}:");
            exception.printStackTrace();
        }
    }

    public final void invalidateLine(int n) {
        this.repaint(0, this.textArea.lineToY(n) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), this.fm.getHeight());
    }

    public final void invalidateLineRange(int n, int n2) {
        this.repaint(0, this.textArea.lineToY(n) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), (n2 - n + 1) * this.fm.getHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    public float nextTabStop(float f, int n) {
        int n2 = this.textArea.getHorizontalOffset();
        int n3 = ((int)f - n2) / this.tabSize;
        return (n3 + 1) * this.tabSize + n2;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = this.fm.charWidth('w') * this.cols;
        dimension.height = this.fm.getHeight() * this.rows;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void paintLine(Graphics graphics, TokenMarker tokenMarker, int n, int n2) {
        Font font = this.getFont();
        Color color = this.getForeground();
        this.currentLineIndex = n;
        int n3 = this.textArea.lineToY(n);
        if (n < 0 || n >= this.textArea.getLineCount()) {
            if (this.paintInvalid) {
                this.paintHighlight(graphics, n, n3);
                this.styles[10].setGraphicsFlags(graphics, font);
                graphics.drawString("~", 0, n3 + this.fm.getHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(graphics, n, font, color, n2, n3);
        } else {
            this.paintSyntaxLine(graphics, tokenMarker, n, font, color, n2, n3);
        }
    }

    protected void paintPlainLine(Graphics graphics, int n, Font font, Color color, int n2, int n3) {
        this.paintHighlight(graphics, n, n3);
        this.textArea.getLineText(n, this.currentLine);
        graphics.setFont(font);
        graphics.setColor(color);
        n2 = Utilities.drawTabbedText(this.currentLine, n2, n3 += this.fm.getHeight(), graphics, (TabExpander)this, 0);
        if (this.eolMarkers) {
            graphics.setColor(this.eolMarkerColor);
            graphics.drawString(".", n2, n3);
        }
    }

    protected void paintSyntaxLine(Graphics graphics, TokenMarker tokenMarker, int n, Font font, Color color, int n2, int n3) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(graphics, n, n3);
        graphics.setFont(font);
        graphics.setColor(color);
        n2 = SyntaxUtilities.paintSyntaxLine(this.currentLine, this.currentLineTokens, this.styles, this, graphics, n2, n3 += this.fm.getHeight());
        if (this.eolMarkers) {
            graphics.setColor(this.eolMarkerColor);
            graphics.drawString(".", n2, n3);
        }
    }

    protected void paintHighlight(Graphics graphics, int n, int n2) {
        if (n >= this.textArea.getSelectionStartLine() && n <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(graphics, n, n2);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(graphics, n, n2);
        }
        if (this.bracketHighlight && n == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(graphics, n, n2);
        }
        if (n == this.textArea.getCaretLine()) {
            this.paintCaret(graphics, n, n2);
        }
    }

    protected void paintLineHighlight(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.fm.getHeight();
        n2 += this.fm.getLeading() + this.fm.getMaxDescent();
        int n5 = this.textArea.getSelectionStart();
        if (n5 == (n3 = this.textArea.getSelectionEnd())) {
            if (this.lineHighlight) {
                graphics.setColor(this.lineHighlightColor);
                graphics.fillRect(0, n2, this.getWidth(), n4);
            }
        } else {
            int n6;
            int n7;
            graphics.setColor(this.selectionColor);
            int n8 = this.textArea.getSelectionStartLine();
            int n9 = this.textArea.getSelectionEndLine();
            int n10 = this.textArea.getLineStartOffset(n);
            if (this.textArea.isSelectionRectangular()) {
                int n11 = this.textArea.getLineLength(n);
                n7 = this.textArea._offsetToX(n, Math.min(n11, n5 - this.textArea.getLineStartOffset(n8)));
                if (n7 == (n6 = this.textArea._offsetToX(n, Math.min(n11, n3 - this.textArea.getLineStartOffset(n9))))) {
                    ++n6;
                }
            } else if (n8 == n9) {
                n7 = this.textArea._offsetToX(n, n5 - n10);
                n6 = this.textArea._offsetToX(n, n3 - n10);
            } else if (n == n8) {
                n7 = this.textArea._offsetToX(n, n5 - n10);
                n6 = this.getWidth();
            } else if (n == n9) {
                n7 = 0;
                n6 = this.textArea._offsetToX(n, n3 - n10);
            } else {
                n7 = 0;
                n6 = this.getWidth();
            }
            graphics.fillRect(n7 > n6 ? n6 : n7, n2, n7 > n6 ? n7 - n6 : n6 - n7, n4);
        }
    }

    protected void paintBracketHighlight(Graphics graphics, int n, int n2) {
        int n3 = this.textArea.getBracketPosition();
        if (n3 == -1) {
            return;
        }
        int n4 = this.textArea._offsetToX(n, n3);
        graphics.setColor(this.bracketHighlightColor);
        graphics.drawRect(n4, n2 += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintCaret(Graphics graphics, int n, int n2) {
        if (this.textArea.isCaretVisible()) {
            int n3 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(n);
            int n4 = this.textArea._offsetToX(n, n3);
            int n5 = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
            n2 += this.fm.getLeading() + this.fm.getMaxDescent();
            int n6 = this.fm.getHeight();
            graphics.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                graphics.fillRect(n4, n2 + n6 - 1, n5, 1);
            } else {
                graphics.drawRect(n4, n2, n5, n6 - 1);
            }
        }
    }

    public static interface Highlight {
        public void init(JEditTextArea var1, Highlight var2);

        public void paintHighlight(Graphics var1, int var2, int var3);

        public String getToolTipText(MouseEvent var1);
    }
}

