/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.targetmodel.filemodel.history.ActionType;
import ddb.targetmodel.filemodel.history.CommandType;
import ddb.targetmodel.filemodel.listeners.FileManagerDataListener;
import java.util.HashSet;
import java.util.Set;

public class GetListener
extends FileManagerDataListener {
    Set<GetRecord> Pending = new HashSet<GetRecord>();

    public GetListener(CoreController coreController, FileSystemModel fileSystemModel) {
        super(coreController, fileSystemModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleData(DataEvent dataEvent) {
        Object object;
        GetRecord getRecord = null;
        if (DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            object = this;
            synchronized (object) {
                String string;
                ObjectValue objectValue = dataEvent.getData().getObject("filestart");
                if (objectValue != null) {
                    string = objectValue.getString("filename");
                    long l = this.getId(objectValue);
                    if (l != -1L) {
                        getRecord = this.searchForRecord(new GetRecord(string, dataEvent.getTaskId(), l, objectValue.getInteger("size")), true);
                    }
                }
                if ((string = dataEvent.getData().getObject("filestop")) != null) {
                    String string2 = string.getString("filename");
                    long l = this.getId((ObjectValue)string);
                    if (l != -1L) {
                        getRecord = this.searchForRecord(new GetRecord(string2, dataEvent.getTaskId(), l, -1L), false);
                    }
                }
            }
        }
        if (getRecord != null) {
            object = this.model.getNodeForPath(getRecord.path, true, CommandType.GET, dataEvent.getTaskId(), dataEvent.getTimestamp(), true, new SetSize(getRecord.size, this.model));
            this.model.addHistoryItem((FileObject)object, dataEvent.getTaskId(), ActionType.INFO, CommandType.GET, dataEvent.getTimestamp());
        }
    }

    private long getId(ObjectValue objectValue) {
        try {
            return objectValue.getInteger("id");
        }
        catch (NullPointerException nullPointerException) {
            try {
                return Long.parseLong(objectValue.getString("id"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1L;
            }
        }
    }

    private GetRecord searchForRecord(GetRecord getRecord, boolean bl) {
        for (GetRecord getRecord2 : this.Pending) {
            if (!getRecord2.equals(getRecord)) continue;
            this.Pending.remove(getRecord2);
            return bl ? getRecord : getRecord2;
        }
        return null;
    }

    private class SetSize
    extends FileManagerDataListener.DataClosure {
        Long size;

        public SetSize(Long l, FileSystemModel fileSystemModel) {
            super(false, fileSystemModel);
            this.size = l;
        }

        protected void executeChild(Object object) {
            if (object instanceof FileObject && this.size != null) {
                FileObject fileObject = (FileObject)object;
                fileObject.setDataElement(FileObjectFields.File_Size, (Object)this.size);
            }
        }
    }

    private class GetRecord {
        final String path;
        final TaskId taskId;
        final long fileId;
        final long size;

        public GetRecord(String string, TaskId taskId, long l, long l2) {
            this.path = string;
            this.taskId = taskId;
            this.fileId = l;
            this.size = l2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            GetRecord getRecord = (GetRecord)object;
            if (!(this.taskId == getRecord.taskId || this.taskId != null && this.taskId.equals((Object)getRecord.taskId))) {
                return false;
            }
            return this.fileId == getRecord.fileId;
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + (this.taskId != null ? this.taskId.hashCode() : 0);
            n = 67 * n + (int)this.fileId;
            return n;
        }
    }
}

