/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.task.Task;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileSystemModel;
import org.apache.commons.collections.Closure;

public abstract class FileManagerDataListener
implements Closure {
    protected static final Closure MAKE_DIRECTORY = new Closure(){

        public void execute(Object object) {
            if (object instanceof FileObject) {
                ((FileObject)FileObject.class.cast(object)).setDirectory();
            }
        }
    };
    protected final CoreController core;
    protected final FileSystemModel model;
    static final Object COUNT_LOCK = new Object();
    static int AvailableCount = 30;

    protected FileManagerDataListener(CoreController coreController, FileSystemModel fileSystemModel) {
        this.core = coreController;
        this.model = fileSystemModel;
    }

    public final void execute(Object object) {
        if (!(object instanceof DataEvent)) {
            return;
        }
        DataEvent dataEvent = (DataEvent)DataEvent.class.cast(object);
        Task task = this.core.getTaskById(dataEvent.getTaskId());
        if (task == null) {
            return;
        }
        this.handleData(dataEvent);
    }

    protected abstract void handleData(DataEvent var1);

    protected abstract class DataClosure
    implements Closure {
        boolean limited;
        protected final FileSystemModel model;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DataClosure(boolean bl, FileSystemModel fileSystemModel) {
            this.limited = bl;
            this.model = fileSystemModel;
            if (bl) {
                Object object = COUNT_LOCK;
                synchronized (object) {
                    while (AvailableCount <= 0) {
                        try {
                            COUNT_LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    --AvailableCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(Object object) {
            try {
                this.executeChild(object);
            }
            finally {
                if (this.limited) {
                    Object object2 = COUNT_LOCK;
                    synchronized (object2) {
                        if (++AvailableCount > 0) {
                            COUNT_LOCK.notifyAll();
                        }
                    }
                }
            }
        }

        protected abstract void executeChild(Object var1);
    }
}

