/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.targetmodel.filemodel.DriveType;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.targetmodel.filemodel.history.ActionType;
import ddb.targetmodel.filemodel.history.CommandType;
import ddb.targetmodel.filemodel.listeners.FileManagerDataListener;
import java.util.Calendar;

public class DrivesListener
extends FileManagerDataListener {
    public DrivesListener(CoreController coreController, FileSystemModel fileSystemModel) {
        super(coreController, fileSystemModel);
    }

    protected void handleData(DataEvent dataEvent) {
        if (DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            for (ObjectValue objectValue : dataEvent.getData().getObjects("driveitem")) {
                this.model.getNodeForPath(objectValue.getString("drive"), true, CommandType.DRIVES, dataEvent.getTaskId(), dataEvent.getTimestamp(), true, new FillinDrive(this.model, objectValue, dataEvent.getTaskId(), dataEvent.getTimestamp()));
            }
        }
    }

    private class FillinDrive
    extends FileManagerDataListener.DataClosure {
        ObjectValue driveObject;
        TaskId taskId;
        Calendar timestamp;

        public FillinDrive(FileSystemModel fileSystemModel, ObjectValue objectValue, TaskId taskId, Calendar calendar) {
            super(DrivesListener.this, false, fileSystemModel);
            this.driveObject = objectValue;
            this.taskId = taskId;
            this.timestamp = calendar;
        }

        public void executeChild(Object object) {
            if (object == null || !(object instanceof FileObject)) {
                return;
            }
            FileObject fileObject = (FileObject)object;
            fileObject.setDrive();
            fileObject.setDataElement(FileObjectFields.Drive_Serial, (Object)this.driveObject.getString("serialnumber"));
            fileObject.setDataElement(FileObjectFields.Drive_Options, (Object)this.driveObject.getString("options"));
            fileObject.setDataElement(FileObjectFields.Drive_FileSystem, (Object)this.driveObject.getString("filesystem"));
            fileObject.setDataElement(FileObjectFields.Drive_Source, (Object)this.driveObject.getString("drivesource"));
            String string = this.driveObject.getString("type");
            if (string == null) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.DRIVE.ordinal());
            } else if (string.equalsIgnoreCase("Fixed")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.DRIVE.ordinal());
            } else if (string.equalsIgnoreCase("Removable")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.FLOPPYDISK.ordinal());
            } else if (string.equalsIgnoreCase("Network")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.DRIVENETWORK.ordinal());
            } else if (string.equalsIgnoreCase("Cdrom")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.CDDRIVE.ordinal());
            } else if (string.equalsIgnoreCase("Ramdisk")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.RAMDISK.ordinal());
            } else if (string.equalsIgnoreCase("Simulated")) {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.DRIVESIMULATED.ordinal());
            } else {
                fileObject.setDataElement(FileObjectFields.Drive_Type, (Object)DriveType.DRIVE.ordinal());
            }
            fileObject.save();
            this.model.addHistoryItem(fileObject, this.taskId, ActionType.INFO, CommandType.DRIVES, this.timestamp);
        }
    }
}

