/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel;

import ddb.dsz.annotations.DszQueuableMethod;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.targetmodel.TargetDetail;
import ddb.targetmodel.filemodel.FileSystemModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetModel
implements CommandEventListener {
    private final HostInfo host;
    private final CoreController core;
    private final List<Task> relevantTasks = new Vector<Task>();
    private final List<TargetDetail> details = new Vector<TargetDetail>();
    private FileSystemModel fileSystem;

    TargetModel(CoreController coreController, HostInfo hostInfo) {
        this.host = hostInfo;
        this.core = coreController;
        for (Task task : coreController.getTaskList()) {
            if (task.getHost() == null || !task.getHost().sameHost(hostInfo)) continue;
            this.relevantTasks.add(task);
        }
        Collections.sort(this.relevantTasks, Task.TaskComparator);
        coreController.addCommandEventListener((CommandEventListener)this);
    }

    @DszQueuableMethod
    public synchronized void commandEventReceived(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        if (task.getHost() == null) {
            return;
        }
        if (!task.getHost().sameHost(this.host)) {
            return;
        }
        int n = Collections.binarySearch(this.relevantTasks, task, Task.TaskComparator);
        if (n < 0) {
            ++n;
            n = -n;
            this.relevantTasks.add(n, task);
        }
        for (TargetDetail targetDetail : this.details) {
            try {
                targetDetail.addTask(task);
            }
            catch (Exception exception) {
                this.core.logEvent(Level.SEVERE, "Exception while parsing command", (Throwable)exception);
            }
        }
    }

    public Comparator<CommandEvent> getComparator() {
        return null;
    }

    public boolean handlesPromptsForTask(Task task, int n) {
        return false;
    }

    public boolean caresAboutLocalEvents() {
        return true;
    }

    public boolean caresAboutRepeatedEvents() {
        return true;
    }

    public HostInfo getHost() {
        return this.host;
    }

    public synchronized FileSystemModel getFileSystemModel() {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = new FileSystemModel(this.core, this.host.getId());
                this.details.add(this.fileSystem);
            }
            catch (Exception exception) {
                this.core.logEvent(Level.SEVERE, "Unable to instansiate FileSystemModel", (Throwable)exception);
            }
            for (Task task : this.relevantTasks) {
                try {
                    this.fileSystem.addTask(task);
                }
                catch (Exception exception) {
                    this.core.logEvent(Level.SEVERE, "Unable to load task '" + task.getFullCommandLine() + "'", (Throwable)exception);
                }
            }
        }
        return this.fileSystem;
    }
}

