/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class StringUtils {
    public static final String classVersion = "4.3.3";
    public static final int LEFT_PAD = 1;
    public static final int RIGHT_PAD = 2;

    private StringUtils() {
    }

    public static String alphanum(String s) {
        String r = s;
        if (s != null) {
            r = StringUtils.transliterate(s, "0123456789-", "0");
            r = StringUtils.transliterate(r, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "A");
            r = StringUtils.transliterate(r, "abcdefghijklmnopqrstuvwxyz", "a");
        }
        return r;
    }

    public static final StringBuffer append(StringBuffer text, String format, int value) {
        int length = format.length();
        boolean formatting = false;
        boolean leadingZeroes = false;
        int digits = 0;
        for (int pos = 0; pos < length; ++pos) {
            char c = format.charAt(pos);
            if (!formatting) {
                if (c == '%') {
                    formatting = true;
                    leadingZeroes = false;
                    digits = 0;
                    continue;
                }
                text.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (digits == 0) {
                    if (c == '0') {
                        leadingZeroes = true;
                        continue;
                    }
                    digits = c - 48;
                    continue;
                }
                digits *= 10;
                digits += c - 48;
                continue;
            }
            if (c == 'd') {
                int numPad;
                String valueString = String.valueOf(value);
                if (digits > 0 && (numPad = digits - valueString.length()) > 0) {
                    int i;
                    if (leadingZeroes) {
                        for (i = 0; i < numPad; ++i) {
                            text.append('0');
                        }
                    } else {
                        for (i = 0; i < numPad; ++i) {
                            text.append(' ');
                        }
                    }
                }
                text.append(valueString);
                formatting = false;
                continue;
            }
            if (c != '%') continue;
            text.append('%');
            formatting = false;
        }
        return text;
    }

    public static String breakCap(String s) {
        String result = s;
        if (s != null && s.length() > 1) {
            StringBuffer sb = new StringBuffer();
            char[] ca = s.toCharArray();
            sb.append(ca[0]);
            for (int i = 1; i < ca.length; ++i) {
                if (Character.isUpperCase(ca[i]) && Character.isLowerCase(ca[i - 1])) {
                    sb.append(" ");
                }
                sb.append(ca[i]);
            }
            result = sb.toString();
        }
        return result;
    }

    public static String capitalize(String s) {
        String result = s;
        if (s != null && s.length() > 0) {
            char[] ca = s.toCharArray();
            ca[0] = Character.toUpperCase(ca[0]);
            result = new String(ca);
        }
        return result;
    }

    public static final boolean containsOnlyAlphaNumerics(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static final boolean containsOnlyDigits(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static final boolean containsOnlyHexDigits(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
            return false;
        }
        return true;
    }

    public static final boolean containsOnlyLetters(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    public static final int count(String text, char ch) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static final boolean endsWithIgnoreCase(String text, String suffix) {
        return StringUtils.startsWithIgnoreCase(text, suffix, text.length() - suffix.length());
    }

    public static int indexOf(String text, String find, int offset, boolean ignoreCase, boolean wholeWord) {
        int findLength = find.length();
        int textLength = text.length();
        if (offset >= textLength) {
            if (textLength == 0 && offset == 0 && findLength == 0) {
                return 0;
            }
            return -1;
        }
        if (offset < 0) {
            return -1;
        }
        if (findLength == 0) {
            return offset;
        }
        int end = textLength - findLength;
        for (int i = offset; i <= end; ++i) {
            if (!text.regionMatches(ignoreCase, i, find, 0, findLength)) continue;
            if (!wholeWord) {
                return i;
            }
            if (i != 0 && Character.isLetterOrDigit(text.charAt(i - 1)) || i != end && Character.isLetterOrDigit(text.charAt(i + findLength))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(StringBuffer text, String find) {
        return StringUtils.indexOf(text, find, 0);
    }

    public static int indexOf(StringBuffer text, String find, int offset) {
        int max = text.length() - find.length();
        if (offset >= text.length()) {
            if (text.length() == 0 && offset == 0 && find.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (find.length() == 0) {
            return offset;
        }
        char first = find.charAt(0);
        int i = offset;
        block0: while (true) {
            if (i <= max && text.charAt(i) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + find.length() - 1;
            int k = 1;
            while (j < end) {
                if (text.charAt(j++) == find.charAt(k++)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int indexOfIgnoreCase(String text, String find) {
        return StringUtils.indexOf(text, find, 0, true, false);
    }

    public static int lastIndexOf(String text, String find, int fromIndex, boolean ignoreCase, boolean wholeWord) {
        int findLength = find.length();
        int textLength = text.length();
        if (fromIndex >= textLength) {
            if (textLength == 0 && fromIndex == textLength && findLength == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            return -1;
        }
        if (findLength == 0) {
            return fromIndex;
        }
        int end = 0;
        for (int i = fromIndex; i >= end; --i) {
            if (!text.regionMatches(ignoreCase, i, find, 0, findLength)) continue;
            if (!wholeWord) {
                return i;
            }
            if (i != 0 && Character.isLetterOrDigit(text.charAt(i - 1)) || i + findLength != text.length() && Character.isLetterOrDigit(text.charAt(i + findLength))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String text, String find) {
        return StringUtils.lastIndexOf(text, find, text.length(), true, false);
    }

    public static final StringBuffer pad(StringBuffer text, char padChar, int length, int location) {
        if (location == 1) {
            while (text.length() < length) {
                text.insert(0, padChar);
            }
        } else if (location == 2) {
            while (text.length() < length) {
                text.append(padChar);
            }
        } else {
            throw new IllegalArgumentException("Location must be LEFT_PAD or RIGHT_PAD!");
        }
        return text;
    }

    public static final String pad(String text, char padChar, int length, int location) {
        return StringUtils.pad(new StringBuffer(text), padChar, length, location).toString();
    }

    public static final StringBuffer pad(StringBuffer text, int length, int location) {
        return StringUtils.pad(text, ' ', length, location);
    }

    public static final String pad(String text, int length, int location) {
        return StringUtils.pad(new StringBuffer(text), ' ', length, location).toString();
    }

    public static final StringBuffer pad(StringBuffer text, int length) {
        return StringUtils.pad(text, ' ', length, 2);
    }

    public static final String pad(String s, int length) {
        return StringUtils.pad(s, length, 2);
    }

    public static StringBuffer replaceAll(StringBuffer text, String find, String replacement) {
        if (find.length() == 0) {
            throw new IllegalArgumentException("The string to find cannot be empty!");
        }
        for (int index = 0; index <= text.length() - find.length(); index += replacement.length()) {
            if ((index = StringUtils.indexOf(text, find, index)) == -1) {
                return text;
            }
            text.replace(index, index + find.length(), replacement);
        }
        return text;
    }

    public static String replaceAll(String text, String find, String replacement) {
        return StringUtils.replaceAll(new StringBuffer(text), find, replacement).toString();
    }

    public static final boolean startsWithIgnoreCase(String text, String prefix) {
        return StringUtils.startsWithIgnoreCase(text, prefix, 0);
    }

    public static final boolean startsWithIgnoreCase(String text, String find, int offset) {
        return text.regionMatches(true, offset, find, 0, find.length());
    }

    public static String transliterate(String s, String from, String to) {
        String result = s;
        if (s != null && from != null && to != null) {
            char[] af = from.toCharArray();
            char[] at = to.toCharArray();
            char[] a = s.toCharArray();
            block0: for (int i = 0; i < a.length; ++i) {
                for (int j = 0; j < af.length; ++j) {
                    if (a[i] != af[j]) continue;
                    a[i] = at[j % at.length];
                    continue block0;
                }
            }
            result = new String(a);
        }
        return result;
    }

    public static final String trimBegin(String text) {
        if (text != null) {
            int i;
            for (i = 0; i < text.length() && text.charAt(i) <= ' '; ++i) {
            }
            text = i < text.length() ? text.substring(i, text.length()) : "";
        }
        return text;
    }

    public static final String trimEnd(String text) {
        if (text != null) {
            int i;
            for (i = text.length() - 1; i >= 0 && text.charAt(i) <= ' '; --i) {
            }
            text = i >= 0 ? text.substring(0, i + 1) : "";
        }
        return text;
    }

    public static String truncateString(String s, int maxLength) {
        if (s.length() > maxLength) {
            String newS = s.substring(0, maxLength);
            int lastWhitespaceLoc = newS.lastIndexOf(" ");
            if (lastWhitespaceLoc == -1) {
                lastWhitespaceLoc = maxLength;
            }
            newS = s.substring(0, lastWhitespaceLoc);
            return newS + "...";
        }
        return s;
    }

    public static final String valueOf(String format, int value) {
        return StringUtils.append(new StringBuffer(), format, value).toString();
    }

    public static final String valueOf(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        throwable.printStackTrace(out);
        writer.flush();
        return writer.toString();
    }
}

