/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.screenlog;

import ddb.detach.Alignment;
import ddb.detach.TabbableStatus;
import ddb.detach.Workbench;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.logviewer.gui.LogViewerDetachable;
import ddb.dsz.plugin.logviewer.gui.screenlog.LogListPane;
import ddb.dsz.plugin.logviewer.gui.screenlog.LogViewPane;
import ddb.dsz.plugin.logviewer.gui.screenlog.ScreenLogWorkspace;
import ddb.imagemanager.ImageManager;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JComponent;

public class ScreenLogPane
extends LogViewerDetachable {
    private final Map<File, LogViewPane> fileToPane = new HashMap<File, LogViewPane>();
    private final ScreenLogWorkspace workspace;
    LogListPane logList;
    CoreController core;
    private boolean stop = false;
    private Runnable update = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ScreenLogPane.this.stop) {
                return;
            }
            try {
                Map map = ScreenLogPane.this.fileToPane;
                synchronized (map) {
                    for (LogViewPane pane : ScreenLogPane.this.fileToPane.values()) {
                        pane.update();
                    }
                }
            }
            finally {
                ScreenLogPane.this.core.schedule((Runnable)this, 5L, TimeUnit.SECONDS);
            }
        }
    };

    public ScreenLogPane(CoreController core) {
        this.core = core;
        super.setName("Screen Logs");
        super.setAlignment(Alignment.LEFT);
        super.setShowButtons(true);
        super.setLogo("images/gkrellm2.png", ImageManager.SIZE16);
        this.workspace = new ScreenLogWorkspace(core.getSystemLogger(), this, 1);
        this.logList = new LogListPane(core, this, new File(core.getLogDirectory(), "Logs"));
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{this.logList});
        core.submit(this.update);
    }

    public void close() {
        this.logList.stop();
        this.stop = true;
    }

    public JComponent getDisplay() {
        return this.workspace;
    }

    public boolean isClosable() {
        return false;
    }

    public JComponent getHeader() {
        return null;
    }

    public boolean isHideable() {
        return true;
    }

    public void release(LogViewerDetachable lvd) {
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{lvd});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fini() {
        Map<File, LogViewPane> map = this.fileToPane;
        synchronized (map) {
            for (LogViewPane log : this.fileToPane.values()) {
                log.close();
            }
            this.fileToPane.clear();
        }
    }

    public TabbableStatus getStatus() {
        return this.workspace.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(LogViewerDetachable lvd) {
        Map<File, LogViewPane> map = this.fileToPane;
        synchronized (map) {
            for (File f : this.fileToPane.keySet()) {
                if (lvd != this.fileToPane.get(f)) continue;
                this.fileToPane.remove(f);
                lvd.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(File file) {
        LogViewPane pane;
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        boolean add = false;
        Object object = this.fileToPane;
        synchronized (object) {
            pane = this.fileToPane.get(file);
            if (pane == null) {
                add = true;
                try {
                    pane = new LogViewPane(this.core, file);
                }
                catch (Throwable e) {
                    this.core.logEvent(Level.SEVERE, "Unable to load " + file.getAbsolutePath() + " in detail", e);
                    return;
                }
                this.fileToPane.put(file, pane);
            }
        }
        if (add) {
            this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{pane});
            this.core.logEvent(Level.FINER, "Loading task " + file.getAbsolutePath() + " in a detail pane");
        } else {
            object = this.workspace;
            synchronized (object) {
                boolean found = false;
                for (Component c : this.workspace.getComponents()) {
                    if (!c.equals(pane.getDisplay())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (pane.getFrame() != null && pane.getFrame().isVisible()) {
                        pane.getFrame().toFront();
                        return;
                    }
                    this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{pane});
                }
            }
        }
        this.workspace.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{pane});
    }
}

