/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.gui.screenlog;

import ddb.detach.Alignment;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.logviewer.gui.LogViewerDetachable;
import ddb.dsz.plugin.logviewer.gui.screenlog.LogRenderer;
import ddb.dsz.plugin.logviewer.gui.screenlog.ScreenLogColumns;
import ddb.dsz.plugin.logviewer.gui.screenlog.ScreenLogModel;
import ddb.dsz.plugin.logviewer.gui.screenlog.ScreenLogPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class LogListPane
extends LogViewerDetachable {
    File monitoredDirectory;
    CoreController core;
    boolean stop = false;
    Runnable scan = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LogListPane.this.stop) {
                return;
            }
            if (LogListPane.this.monitoredDirectory == null) {
                return;
            }
            try {
                for (File f : LogListPane.this.monitoredDirectory.listFiles()) {
                    if (f.isDirectory()) continue;
                    LogListPane.this.model.updateFile(f);
                }
            }
            finally {
                LogListPane.this.core.schedule((Runnable)this, 5L, TimeUnit.SECONDS);
            }
        }
    };
    ScreenLogModel model = new ScreenLogModel();
    JTable tableList = new JTable((TableModel)((Object)this.model));
    JScrollPane tableScroll = new JScrollPane(this.tableList);
    ScreenLogPane parent;

    public LogListPane(CoreController core, ScreenLogPane parentPane, File monitorDirectory) {
        this.parent = parentPane;
        super.setName("Screen Logs");
        super.setAlignment(Alignment.LEFT);
        super.setShowButtons(true);
        this.monitoredDirectory = monitorDirectory;
        this.core = core;
        core.submit(this.scan);
        this.tableList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int row = e.getY() / LogListPane.this.tableList.getRowHeight();
                File f = (File)LogListPane.this.model.getValueAt(row, ScreenLogColumns.FILENAME);
                if (f == null) {
                    return;
                }
                LogListPane.this.parent.loadFile(f);
            }
        });
        LogRenderer renderer = new LogRenderer();
        this.tableList.setDefaultRenderer(Calendar.class, (TableCellRenderer)((Object)renderer));
        this.tableList.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)renderer));
        this.tableList.setDefaultRenderer(File.class, (TableCellRenderer)((Object)renderer));
    }

    public JComponent getDisplay() {
        return this.tableScroll;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isClosable() {
        return false;
    }
}

