/*
 * Decompiled with CFR 0.152.
 */
package ddb.splash;

import ddb.imagemanager.ImageManager;
import ddb.splash.ProgressItem;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.commons.collections.Closure;

public class SplashScreen
extends JFrame {
    private JPanel mainImagePanel;
    private JLabel progressLabel;
    private JLabel progressIcon;
    private JProgressBar majorProgressBar;
    private JProgressBar minorProgressBar;
    private List<ProgressItem> stages;
    private int currentStage;
    private JButton skip = new JButton("Skip");
    private String text = null;
    public static int DONE = -2;
    public static int NOT_STARTED = -1;

    public SplashScreen(String string, Icon icon, int n, int n2) throws HeadlessException {
        super(string);
        this.setSize(n, n2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.mainImagePanel = new JPanel();
        this.progressLabel = new JLabel();
        this.progressIcon = new JLabel();
        this.stages = new Vector<ProgressItem>();
        this.currentStage = NOT_STARTED;
        this.majorProgressBar = new JProgressBar(0, 0);
        this.minorProgressBar = new JProgressBar(0, 0);
        this.setDefaultCloseOperation(2);
        this.progressIcon.setText("");
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        container.add(this.mainImagePanel);
        container.add(this.majorProgressBar);
        container.add(this.minorProgressBar);
        container.add(this.progressIcon);
        container.add(this.progressLabel);
        container.add(this.skip);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.addLayoutComponent(this.mainImagePanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.addLayoutComponent(this.progressIcon, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.addLayoutComponent(this.progressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.addLayoutComponent(this.skip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.addLayoutComponent(this.majorProgressBar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.addLayoutComponent(this.minorProgressBar, gridBagConstraints);
        this.skip.setVisible(false);
        Icon icon2 = icon;
        this.mainImagePanel.add(new JLabel(icon2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        try {
            this.majorProgressBar.setMaximum(this.stages.size());
            this.majorProgressBar.setMinimum(0);
            int n = 0;
            while (n < this.stages.size()) {
                final ProgressItem progressItem = this.stages.get(n);
                final int n2 = n++;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SplashScreen.this.majorProgressBar.setValue(n2);
                        SplashScreen.this.minorProgressBar.setMaximum(10);
                        SplashScreen.this.minorProgressBar.setMinimum(0);
                        SplashScreen.this.minorProgressBar.setIndeterminate(true);
                        SplashScreen.this.progressLabel.setText(progressItem.getText());
                        SplashScreen.this.progressIcon.setIcon(ImageManager.getIcon(progressItem.getIcon(), ImageManager.SIZE48));
                        SplashScreen.this.text = progressItem.getText();
                    }
                });
                progressItem.execute(null);
            }
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen.this.setVisible(false);
                    SplashScreen.this.dispose();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void addStage(String string, String string2, Closure closure) {
        this.stages.add(new ProgressItem(string, string2, closure));
        this.majorProgressBar.setMaximum(this.majorProgressBar.getMaximum() + 1);
    }

    public int getStageCount() {
        return this.stages.size();
    }

    public void showSkip(ActionListener actionListener) {
        if (actionListener != null) {
            this.skip.addActionListener(actionListener);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SplashScreen.this.skip.setVisible(true);
            }
        });
    }

    public void updateMinor(final int n, final int n2, final String string) {
        if (EventQueue.isDispatchThread()) {
            this.progressLabel.setText(String.format("%s: %s", this.text, string));
            this.minorProgressBar.setIndeterminate(false);
            this.minorProgressBar.setMaximum(n2);
            this.minorProgressBar.setValue(n);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen.this.updateMinor(n, n2, string);
                }
            });
        }
    }

    public void updateMinorIndeterminate(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.progressLabel.setText(String.format("%s: %s", this.text, string));
            this.minorProgressBar.setIndeterminate(true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen.this.updateMinorIndeterminate(string);
                }
            });
        }
    }

    public int getStage() {
        return this.currentStage;
    }
}

