/*
 * Decompiled with CFR 0.152.
 */
package ddb.history;

import ddb.actions.history.HistoryDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History<E> {
    public static final int UNLIMITED = 0;
    List<E> items = new ArrayList();
    int index = 0;
    int maximum = 5000;
    E lastSearchPattern = null;
    E lastSearchResult = null;
    int searchBegan = -1;
    Comparator<E> compEquals;
    Comparator<E> compMatches;
    E defaultValue = null;

    public History() {
        this(new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                if (e == e2) {
                    return 0;
                }
                if (e == null || e2 == null) {
                    return 1;
                }
                if (e.equals(e2)) {
                    return 0;
                }
                return 1;
            }
        }, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                if (e == e2) {
                    return 0;
                }
                if (e == null || e2 == null) {
                    return 1;
                }
                if (e.equals(e2)) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public History(Comparator<E> comparator, Comparator<E> comparator2) {
        this(comparator, comparator2, null);
    }

    public History(Comparator<E> comparator, Comparator<E> comparator2, E e) {
        this(0, comparator, comparator2, e);
    }

    public History(int n, Comparator<E> comparator, Comparator<E> comparator2, E e) {
        this.maximum = n;
        this.compEquals = comparator;
        this.compMatches = comparator2;
        this.defaultValue = e;
    }

    private void trim() {
        if (this.maximum == 0) {
            return;
        }
        if (this.items.size() > this.maximum) {
            this.items.subList(0, this.items.size() - this.maximum).clear();
        }
        this.index = this.items.size();
    }

    private void clearSearch() {
        this.lastSearchPattern = null;
        this.lastSearchResult = null;
    }

    public void setMaximum(int n) {
        this.maximum = n;
        this.trim();
    }

    public void addHistoryItem(E e) {
        this.items.add(e);
        this.index = this.items.size();
        this.trim();
        this.clearSearch();
    }

    public E doHistoryAction(HistoryDirection historyDirection, E e) {
        if (this.items.size() == 0) {
            return this.defaultValue;
        }
        int n = this.index;
        switch (historyDirection) {
            case FIRST: {
                n = 0;
                break;
            }
            case LAST: {
                n = this.items.size() - 1;
                break;
            }
            case NEXT: {
                ++n;
                break;
            }
            case PREVIOUS: {
                --n;
                break;
            }
            case SEARCH: {
                if (this.lastSearchPattern == null || this.lastSearchResult == null || 0 != this.compEquals.compare(this.lastSearchResult, e)) {
                    this.lastSearchPattern = e;
                    n = this.items.size() - 1;
                } else {
                    --n;
                }
                while (n >= 0) {
                    if (0 == this.compMatches.compare(this.items.get(n), this.lastSearchPattern)) {
                        this.lastSearchResult = this.items.get(n);
                        break;
                    }
                    --n;
                }
                if (n != -1) break;
                this.index = this.items.size();
                return this.lastSearchPattern;
            }
        }
        this.index = Math.min(Math.max(0, n), this.items.size());
        if (this.index != this.items.size()) {
            return this.items.get(this.index);
        }
        return this.defaultValue;
    }

    public void clear() {
        this.index = 0;
        this.items.clear();
    }

    public List<E> toList() {
        return Collections.unmodifiableList(this.items);
    }

    public E get(int n) {
        if (n >= 0 && n < this.items.size()) {
            return this.items.get(n);
        }
        return this.defaultValue;
    }

    public List<E> get(int n, int n2) {
        if (n >= n2 || n < 0 || n2 >= this.items.size()) {
            return new Vector();
        }
        return this.items.subList(n, n2);
    }

    public static History<String> getHistoryString() {
        return History.getHistoryString(0);
    }

    public static History<String> getHistoryString(int n) {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string != null) {
                    return string.compareTo(string2);
                }
                return -1;
            }
        };
        Comparator<String> comparator2 = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == null || string2 == null) {
                    return 1;
                }
                if (string.startsWith(string2)) {
                    return 0;
                }
                return 1;
            }
        };
        return new History<Object>(n, comparator, comparator2, null);
    }
}

