/*
 * Decompiled with CFR 0.152.
 */
package ddb.console;

import ddb.antialiasing.AntialiasedTextField;
import ddb.console.ColorTheme;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class TextPanel
extends JPanel {
    ColorTheme currentTheme;
    private boolean bOverrideWarningBg = false;
    private boolean bOverrideErrorBg = false;
    private boolean bOverrideNoticeBg = false;
    private JButton defaultBackground;
    private JButton defaultForeground;
    private JLabel defaultLabel;
    private JTextField defaultText;
    private JButton errorBackground;
    private JButton errorForeground;
    private JLabel errorLabel;
    private JTextField errorText;
    private JButton goodBackground;
    private JButton goodForeground;
    private JLabel goodLabel;
    private JTextField goodText;
    private JButton jButton1;
    private JButton warningBackground;
    private JButton warningForeground;
    private JLabel warningLabel;
    private JTextField warningText;

    public TextPanel() {
        this.initComponents();
        this.currentTheme = new ColorTheme("Default");
        this.applyTheme();
    }

    private void applyTheme() {
        this.applyTheme(this.defaultText, ColorTheme.Location.NormalForeground, ColorTheme.Location.NormalBackground);
        this.applyTheme(this.warningText, ColorTheme.Location.WarningForeground, ColorTheme.Location.WarningBackground);
        this.applyTheme(this.errorText, ColorTheme.Location.ErrorForeground, ColorTheme.Location.ErrorBackground);
        this.applyTheme(this.goodText, ColorTheme.Location.NoticeForeground, ColorTheme.Location.NoticeBackground);
    }

    private void applyTheme(JTextField jTextField, ColorTheme.Location location, ColorTheme.Location location2) {
        jTextField.setForeground(this.currentTheme.getValue(location));
        jTextField.setCaretColor(this.currentTheme.getValue(location));
        jTextField.setBackground(this.currentTheme.getValue(location2));
    }

    private void initComponents() {
        this.defaultLabel = new JLabel();
        this.goodLabel = new JLabel();
        this.warningLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.defaultText = new AntialiasedTextField(false);
        this.goodText = new AntialiasedTextField(false);
        this.warningText = new AntialiasedTextField(false);
        this.errorText = new AntialiasedTextField(false);
        this.defaultForeground = new JButton();
        this.defaultBackground = new JButton();
        this.goodBackground = new JButton();
        this.goodForeground = new JButton();
        this.warningBackground = new JButton();
        this.warningForeground = new JButton();
        this.errorBackground = new JButton();
        this.errorForeground = new JButton();
        this.jButton1 = new JButton();
        this.defaultLabel.setText("Default Text:");
        this.goodLabel.setText("Good Text:");
        this.warningLabel.setText("Warning Text:");
        this.errorLabel.setText("Error Text:");
        this.defaultText.setText("This is default text");
        this.goodText.setText("This is good/notice text");
        this.warningText.setText("This is warning text");
        this.errorText.setText("This is error text");
        this.defaultForeground.setText("Foreground");
        this.defaultForeground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.defaultForegroundActionPerformed(actionEvent);
            }
        });
        this.defaultBackground.setText("Background");
        this.defaultBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.defaultBackgroundActionPerformed(actionEvent);
            }
        });
        this.goodBackground.setText("Background");
        this.goodBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.goodBackgroundActionPerformed(actionEvent);
            }
        });
        this.goodForeground.setText("Foreground");
        this.goodForeground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.goodForegroundActionPerformed(actionEvent);
            }
        });
        this.warningBackground.setText("Background");
        this.warningBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.warningBackgroundActionPerformed(actionEvent);
            }
        });
        this.warningForeground.setText("Foreground");
        this.warningForeground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.warningForegroundActionPerformed(actionEvent);
            }
        });
        this.errorBackground.setText("Background");
        this.errorBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.errorBackgroundActionPerformed(actionEvent);
            }
        });
        this.errorForeground.setText("Foreground");
        this.errorForeground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPanel.this.errorForegroundActionPerformed(actionEvent);
            }
        });
        this.jButton1.setText("Save Settings");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultLabel).addComponent(this.goodLabel).addComponent(this.warningLabel).addComponent(this.errorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultText, -1, 277, Short.MAX_VALUE).addComponent(this.goodText, -1, 277, Short.MAX_VALUE).addComponent(this.warningText, -1, 277, Short.MAX_VALUE).addComponent(this.errorText, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defaultForeground).addComponent(this.goodForeground).addComponent(this.warningForeground, GroupLayout.Alignment.LEADING).addComponent(this.errorForeground)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defaultBackground).addComponent(this.goodBackground).addComponent(this.warningBackground).addComponent(this.errorBackground))).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.defaultForeground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goodForeground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningForeground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorForeground)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultLabel).addComponent(this.defaultText, -2, -1, -2).addComponent(this.defaultBackground)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goodLabel).addComponent(this.goodText, -2, -1, -2).addComponent(this.goodBackground)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.warningLabel).addComponent(this.warningText, -2, -1, -2).addComponent(this.warningBackground)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.errorText, -2, -1, -2).addComponent(this.errorBackground))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 145, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
    }

    private void defaultForegroundActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(ColorTheme.Location.NormalForeground);
    }

    private void defaultBackgroundActionPerformed(ActionEvent actionEvent) {
        Color color = this.chooseColor(ColorTheme.Location.NormalBackground);
        if (!this.bOverrideErrorBg) {
            this.currentTheme.setValue(ColorTheme.Location.ErrorBackground, color);
        }
        if (!this.bOverrideWarningBg) {
            this.currentTheme.setValue(ColorTheme.Location.WarningBackground, color);
        }
        if (!this.bOverrideNoticeBg) {
            this.currentTheme.setValue(ColorTheme.Location.NoticeBackground, color);
        }
        this.applyTheme();
    }

    private void goodForegroundActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(ColorTheme.Location.NoticeForeground);
    }

    private void goodBackgroundActionPerformed(ActionEvent actionEvent) {
        if (this.chooseColor(ColorTheme.Location.NoticeBackground) != null) {
            this.bOverrideNoticeBg = true;
        }
    }

    private void warningForegroundActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(ColorTheme.Location.WarningForeground);
    }

    private void warningBackgroundActionPerformed(ActionEvent actionEvent) {
        if (this.chooseColor(ColorTheme.Location.WarningBackground) != null) {
            this.bOverrideWarningBg = true;
        }
    }

    private void errorForegroundActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(ColorTheme.Location.ErrorForeground);
    }

    private void errorBackgroundActionPerformed(ActionEvent actionEvent) {
        if (this.chooseColor(ColorTheme.Location.ErrorBackground) != null) {
            this.bOverrideErrorBg = true;
        }
    }

    private Color chooseColor(ColorTheme.Location location) {
        Color color = this.currentTheme.getValue(location);
        Color color2 = JColorChooser.showDialog(null, "Choose " + location.getName() + " color", color);
        if (color2 == null || color2.equals(color)) {
            return null;
        }
        this.currentTheme.setValue(location, color2);
        this.applyTheme();
        return color2;
    }
}

