/*
 * Decompiled with CFR 0.152.
 */
package ddb.console;

import ddb.GuiConstants;
import ddb.console.StyleTypes;
import java.awt.Color;
import java.io.Serializable;
import java.util.Observable;
import java.util.Properties;

public class ColorTheme
extends Observable
implements Serializable {
    private String name;
    final Color[] themeSet = new Color[Location.values().length];

    private ColorTheme() {
        this("Default");
    }

    public ColorTheme(String string) {
        this.name = string != null ? string : "";
        for (Location location : Location.values()) {
            this.themeSet[location.ordinal()] = location.getColor();
        }
    }

    public ColorTheme(Properties properties) {
        this.name = properties.getProperty("Name");
        for (Location location : Location.values()) {
            Color color;
            String string = properties.getProperty(location.getKey());
            if (string == null) continue;
            this.themeSet[location.ordinal()] = color = Color.decode(string);
        }
    }

    public ColorTheme(String string, ColorTheme colorTheme) {
        this.name = string != null ? string : "";
        this.copyTheme(colorTheme);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string != null ? string : "";
        this.setChanged();
        this.notifyObservers();
    }

    public void setValue(Location location, Color color) {
        if (location == null || color == null) {
            return;
        }
        this.themeSet[location.ordinal()] = color;
        this.setChanged();
        this.notifyObservers();
    }

    public Color getValue(Location location) {
        return location == null ? null : this.themeSet[location.ordinal()];
    }

    public void copyTheme(ColorTheme colorTheme) {
        for (Location location : Location.values()) {
            this.themeSet[location.ordinal()] = colorTheme.themeSet[location.ordinal()];
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("Name", this.name);
        for (Location location : Location.values()) {
            Color color = this.themeSet[location.ordinal()];
            String string = "0x";
            int n = color.getRed();
            string = string + this.parseHex(n);
            n = color.getGreen();
            string = string + this.parseHex(n);
            n = color.getBlue();
            string = string + this.parseHex(n);
            properties.put(location.getKey(), string);
        }
        return properties;
    }

    private String parseHex(int n) {
        return String.format("%02x", n);
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        NormalForeground("NormalFg", "Normal Foreground", GuiConstants.DefaultColor.DEFAULT_FOREGROUND),
        NoticeForeground("NoticeFg", "Notice Foreground", GuiConstants.DefaultColor.NOTICE),
        WarningForeground("WarningFg", "Warning Foreground", GuiConstants.DefaultColor.WARNING),
        ErrorForeground("ErrorFg", "Error Foreground", GuiConstants.DefaultColor.ERROR),
        NormalBackground("NormalBg", "Normal Background", GuiConstants.DefaultColor.DEFAULT_BACKGROUND),
        NoticeBackground("NoticeBg", "Notice Background", GuiConstants.DefaultColor.DEFAULT_BACKGROUND),
        WarningBackground("WarningBg", "Warning Background", GuiConstants.DefaultColor.DEFAULT_BACKGROUND),
        ErrorBackground("ErrorBg", "Error Background", GuiConstants.DefaultColor.DEFAULT_BACKGROUND);

        private final String key;
        private final Color color;
        private final String name;

        private Location(String string2, String string3, GuiConstants.DefaultColor defaultColor) {
            this.key = string2;
            this.name = string3;
            this.color = defaultColor.getColor();
        }

        public String getKey() {
            return this.key;
        }

        public Color getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public static Location lookup(StyleTypes styleTypes, boolean bl) {
            switch (styleTypes) {
                case ERROR: {
                    return bl ? ErrorBackground : ErrorForeground;
                }
                case WARNING: {
                    return bl ? WarningBackground : WarningForeground;
                }
                case NOTICE: {
                    return bl ? NoticeBackground : NoticeForeground;
                }
            }
            return bl ? NormalBackground : NormalForeground;
        }
    }
}

