/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb.ui;

import ddb.bcb.ScrollablePopup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class BasicScrollablePopupUI
extends BasicPopupMenuUI {
    protected JMenuItem scrollDown;
    protected JMenuItem scrollUp = this.createScroller(true);
    protected boolean isScrolling = false;
    protected boolean isPressed = false;
    protected MenuKeyListener menuKeyListener;
    protected MouseWheelListener baseMouseWheelListener;
    protected static BasicScrollablePopupUI INSTANCE = new BasicScrollablePopupUI();

    public BasicScrollablePopupUI() {
        this.scrollDown = this.createScroller(false);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installComponents();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        super.uninstallUI(jComponent);
    }

    protected void installComponents() {
    }

    protected void installListeners() {
        super.installListeners();
        this.baseMouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                boolean bl;
                boolean bl2 = BasicScrollablePopupUI.this.hasScrollers();
                if (!bl2) {
                    return;
                }
                boolean bl3 = mouseWheelEvent.getWheelRotation() < 0;
                boolean bl4 = bl = bl3 && BasicScrollablePopupUI.this.scrollUp.isEnabled() || !bl3 && BasicScrollablePopupUI.this.scrollDown.isEnabled();
                if (bl) {
                    BasicScrollablePopupUI.this.scroll(bl3);
                }
            }
        };
        this.popupMenu.addMouseWheelListener(this.baseMouseWheelListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removeMouseWheelListener(this.baseMouseWheelListener);
        this.baseMouseWheelListener = null;
    }

    protected JMenuItem createScroller(final boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(""){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                BasicScrollablePopupUI.this.paintArrow(graphics, this.getWidth(), this.getHeight(), this.isEnabled() ? this.getForeground() : Color.lightGray, bl);
            }

            public void menuSelectionChanged(boolean bl2) {
                super.menuSelectionChanged(bl2);
                if (bl2) {
                    BasicScrollablePopupUI.this.scrollAction(this);
                } else {
                    BasicScrollablePopupUI.this.isPressed = false;
                }
            }
        };
        jMenuItem.setEnabled(false);
        jMenuItem.addMenuKeyListener(this.getMenuListener());
        jMenuItem.setOpaque(false);
        jMenuItem.setBorder(BorderFactory.createEmptyBorder());
        jMenuItem.setSize(new Dimension(0, 16));
        jMenuItem.setPreferredSize(new Dimension(0, 16));
        return jMenuItem;
    }

    private void paintArrow(Graphics graphics, int n, int n2, Color color, boolean bl) {
        int[] nArray;
        graphics.setColor(color);
        int[] nArray2 = new int[]{n / 2 - 4, n / 2 + 4, n / 2};
        if (bl) {
            int[] nArray3 = new int[3];
            nArray3[0] = n2 / 2 + 2;
            nArray3[1] = n2 / 2 + 2;
            nArray = nArray3;
            nArray3[2] = n2 / 2 - 2;
        } else {
            int[] nArray4 = new int[3];
            nArray4[0] = n2 / 2 - 2;
            nArray4[1] = n2 / 2 - 2;
            nArray = nArray4;
            nArray4[2] = n2 / 2 + 2;
        }
        int[] nArray5 = nArray;
        graphics.fillPolygon(nArray2, nArray5, 3);
    }

    protected void scrollAction(Object object) {
        if (!(object instanceof AbstractButton)) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)object;
        if (!abstractButton.isEnabled()) {
            return;
        }
        final boolean bl = abstractButton.equals(this.scrollUp);
        this.isPressed = true;
        Thread thread = new Thread(){

            public void run() {
                if (BasicScrollablePopupUI.this.isScrolling) {
                    return;
                }
                BasicScrollablePopupUI.this.isScrolling = true;
                long l = 200L;
                int n = 0;
                while (BasicScrollablePopupUI.this.isPressed) {
                    BasicScrollablePopupUI.this.isPressed = BasicScrollablePopupUI.this.scroll(bl);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n > 3) {
                        l = Math.max(50L, l - 30L);
                    }
                    ++n;
                }
                BasicScrollablePopupUI.this.isScrolling = false;
            }
        };
        thread.start();
    }

    public void scrollTo(int n, boolean bl) {
        ScrollablePopup scrollablePopup = (ScrollablePopup)this.popupMenu;
        if (!this.hasScrollers()) {
            scrollablePopup.setSelected((JMenuItem)scrollablePopup.getComponent(n));
            return;
        }
        int n2 = n;
        if (n + scrollablePopup.getMaxSize() > scrollablePopup.getActions().size()) {
            n = scrollablePopup.getActions().size() - scrollablePopup.getMaxSize();
        }
        this.scrollUp.setEnabled(n != 0);
        JMenuItem jMenuItem = null;
        for (int i = 1; i < scrollablePopup.getMaxSize() + 1 && n < scrollablePopup.getActions().size(); ++i) {
            JMenuItem jMenuItem2 = (JMenuItem)scrollablePopup.getComponent(i);
            if (n == n2) {
                jMenuItem = jMenuItem2;
            }
            Action action = scrollablePopup.getActions().get(n++);
            jMenuItem2.setAction(action);
            jMenuItem2.setFont(scrollablePopup.getFont());
        }
        this.scrollDown.setEnabled(n < scrollablePopup.getActions().size());
        if (bl && jMenuItem != null) {
            scrollablePopup.setSelected(jMenuItem);
        }
        Thread.yield();
        scrollablePopup.repaint();
    }

    private boolean scroll(final boolean bl) {
        int n;
        int n2;
        if (!EventQueue.isDispatchThread()) {
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return BasicScrollablePopupUI.this.scroll(bl);
                }
            });
            try {
                EventQueue.invokeAndWait(futureTask);
                return futureTask.get();
            }
            catch (Exception exception) {
                return false;
            }
        }
        ScrollablePopup scrollablePopup = (ScrollablePopup)this.popupMenu;
        JMenuItem jMenuItem = (JMenuItem)scrollablePopup.getComponent(1);
        int n3 = scrollablePopup.getActions().indexOf(jMenuItem.getAction());
        int n4 = n2 = bl ? -1 : 1;
        if ((n3 += n2) < 0) {
            this.scrollUp.setEnabled(false);
            return false;
        }
        this.scrollUp.setEnabled(true);
        for (n = 1; n < scrollablePopup.getMaxSize() + 1 && n3 < scrollablePopup.getActions().size(); ++n) {
            JMenuItem jMenuItem2 = (JMenuItem)scrollablePopup.getComponent(n);
            Action action = scrollablePopup.getActions().get(n3++);
            jMenuItem2.setAction(action);
            jMenuItem2.setFont(scrollablePopup.getFont());
            if (!Boolean.TRUE.equals(action.getValue("ScrollablePopup.selected"))) continue;
            scrollablePopup.setSelected(jMenuItem2);
        }
        n = n3 == scrollablePopup.getActions().size() ? 1 : 0;
        this.scrollDown.setEnabled(n == 0);
        return n == 0;
    }

    protected MenuKeyListener getMenuListener() {
        if (this.menuKeyListener == null) {
            this.menuKeyListener = new MenuKeyListener(){

                public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                    MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (menuElementArray[menuElementArray.length - 1].equals(BasicScrollablePopupUI.this.scrollDown) && menuKeyEvent.getKeyCode() == 40) {
                        BasicScrollablePopupUI.this.popupMenu.setSelected(BasicScrollablePopupUI.this.scrollDown);
                        BasicScrollablePopupUI.this.scrollDown.requestFocus();
                    }
                }

                public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
                }

                public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                }
            };
        }
        return this.menuKeyListener;
    }

    public boolean hasScrollers() {
        return this.scrollUp.getParent() == this.popupMenu;
    }

    public JMenuItem getScrollDown() {
        return this.scrollDown;
    }

    public JMenuItem getScrollUp() {
        return this.scrollUp;
    }

    public void addScrollers() {
        if (!this.hasScrollers()) {
            this.popupMenu.add(this.scrollDown);
            this.scrollDown.setEnabled(true);
            this.popupMenu.insert(this.scrollUp, 0);
        }
    }
}

