/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb.ui;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.BreadcrumbItem;
import ddb.bcb.BreadcrumbItemChoices;
import ddb.bcb.ScrollablePopup;
import ddb.bcb.ui.BreadcrumbBarUI;
import ddb.bcb.ui.BreadcrumbParticle;
import ddb.bcb.ui.ChoicesSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;

public class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    protected BreadcrumbBar breadcrumbBar;
    protected JLabel iconLabel;
    protected JPanel mainPanel;
    protected ScrollablePanel scrollerPanel;
    protected ComponentListener componentListener;
    protected int popupInitiatorIndex;
    private JPopupMenu popup = null;
    private Map<Object, Component> comps = new HashMap<Object, Component>();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicBreadcrumbBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.breadcrumbBar = (BreadcrumbBar)jComponent;
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        jComponent.setLayout(this.createLayoutManager());
        this.popupInitiatorIndex = -1;
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners((BreadcrumbBar)jComponent);
        this.uninstallComponents((BreadcrumbBar)jComponent);
        this.uninstallDefaults((BreadcrumbBar)jComponent);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(BreadcrumbBar breadcrumbBar) {
        breadcrumbBar.setFont(new Font("dialog", 0, 12));
    }

    protected void installComponents(BreadcrumbBar breadcrumbBar) {
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new ScrollablePanel(this.mainPanel);
        breadcrumbBar.add((Component)this.scrollerPanel, "Center");
        Icon icon = breadcrumbBar.getIcon();
        if (icon != null) {
            this.iconLabel = new JLabel(icon);
            this.iconLabel.setOpaque(false);
            breadcrumbBar.add((Component)this.iconLabel, "West");
        }
        if (breadcrumbBar.getOkButton() != null) {
            breadcrumbBar.add((Component)breadcrumbBar.getOkButton(), "East");
        }
    }

    protected void installListeners(BreadcrumbBar breadcrumbBar) {
        this.componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        breadcrumbBar.addComponentListener(this.componentListener);
    }

    protected void uninstallDefaults(BreadcrumbBar breadcrumbBar) {
    }

    protected void uninstallComponents(BreadcrumbBar breadcrumbBar) {
        if (this.iconLabel != null) {
            breadcrumbBar.remove(this.iconLabel);
            this.iconLabel = null;
        }
        this.mainPanel.removeAll();
        this.comps.clear();
        breadcrumbBar.remove(this.scrollerPanel);
        if (breadcrumbBar.getOkButton() != null) {
            breadcrumbBar.remove(breadcrumbBar.getOkButton());
        }
    }

    protected void uninstallListeners(BreadcrumbBar breadcrumbBar) {
        breadcrumbBar.removeComponentListener(this.componentListener);
        this.componentListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new ScrollablePopup(15);
            this.popup.setFont(this.breadcrumbBar.getFont());
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        return this.popup;
    }

    public void hidePopup() {
        this.getPopup().setVisible(false);
    }

    public int updateComponents() {
        if (this.breadcrumbBar.getStack() == null) {
            return 0;
        }
        if (!this.breadcrumbBar.isVisible()) {
            return 0;
        }
        this.mainPanel.removeAll();
        this.comps.clear();
        this.scrollerPanel.removeScrollers();
        int n = 0;
        JComponent jComponent = null;
        for (Object e : this.breadcrumbBar.getStack()) {
            Object object;
            if (e instanceof BreadcrumbItemChoices) {
                object = (BreadcrumbItemChoices)e;
                jComponent = new ChoicesSelector(this.breadcrumbBar, (BreadcrumbItemChoices)object, this.breadcrumbBar.getSeparator());
                this.comps.put(object, jComponent);
            } else if (e instanceof BreadcrumbItem) {
                object = (BreadcrumbItem)e;
                jComponent = new BreadcrumbParticle(this.breadcrumbBar, (BreadcrumbItem)object, this.breadcrumbBar.getFontMetrics(this.breadcrumbBar.getFont()).stringWidth(((BreadcrumbItem)object).getName()));
                this.comps.put(object, jComponent);
            }
            n = (int)((double)n + jComponent.getPreferredSize().getWidth());
            this.mainPanel.add(jComponent);
        }
        this.scrollerPanel.validateScrolling(n);
        this.mainPanel.validate();
        this.mainPanel.repaint();
        if (jComponent != null && this.breadcrumbBar.getStack().lastElement() instanceof BreadcrumbItem) {
            jComponent.requestFocus();
        }
        return n;
    }

    public boolean popup(int n) {
        if (n < 0 || n >= this.mainPanel.getComponentCount()) {
            return false;
        }
        Component component = this.mainPanel.getComponent(n);
        if (component != null && component instanceof ChoicesSelector) {
            ChoicesSelector choicesSelector = (ChoicesSelector)component;
            return this.showPopup(choicesSelector.getIndex(), choicesSelector.getBreadcrumbChoices());
        }
        return false;
    }

    public boolean showPopup(int n, BreadcrumbItemChoices breadcrumbItemChoices) {
        BreadcrumbItem breadcrumbItem;
        JPopupMenu jPopupMenu = this.getPopup();
        this.popupInitiatorIndex = n;
        jPopupMenu.removeAll();
        JLabel jLabel = null;
        for (int i = 0; i < breadcrumbItemChoices.getChoices().length; ++i) {
            BreadcrumbItem breadcrumbItem2 = breadcrumbItemChoices.getChoices()[i];
            PopupAction popupAction = new PopupAction(breadcrumbItem2, breadcrumbItemChoices.getIndex());
            JMenuItem jMenuItem = jPopupMenu.add(popupAction);
            if (jMenuItem == null) continue;
            jMenuItem.setFont(this.breadcrumbBar.getFont());
            jPopupMenu.setBackground(jMenuItem.getBackground());
            jMenuItem.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (this.breadcrumbBar.getItemCount() > breadcrumbItemChoices.getIndex() + 1 && (breadcrumbItem = this.breadcrumbBar.getItem(breadcrumbItemChoices.getIndex() + 1)) != null && breadcrumbItem instanceof BreadcrumbItem) {
            jLabel = new JLabel(breadcrumbItem.getName());
        }
        if (breadcrumbItemChoices.getChoices().length > 0) {
            jPopupMenu.show(this.comps.get(breadcrumbItemChoices), 0, this.comps.get(breadcrumbItemChoices).getHeight());
            if (jLabel != null) {
                jPopupMenu.setSelected(jLabel);
            }
            return true;
        }
        this.popupInitiatorIndex = -1;
        return false;
    }

    public BreadcrumbParticle getParticle(int n) {
        if (n == 0 || n - 1 >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component component = this.mainPanel.getComponent(n);
        if (component != null && component instanceof ChoicesSelector) {
            return (BreadcrumbParticle)this.mainPanel.getComponent(n - 1);
        }
        return null;
    }

    public ChoicesSelector getSelector(int n) {
        if (n == 0 || n - 1 >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component component = this.mainPanel.getComponent(n);
        if (component != null && component instanceof ChoicesSelector) {
            return (ChoicesSelector)component;
        }
        return null;
    }

    protected JButton createScrollingButton() {
        JButton jButton = new JButton();
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setPreferredSize(new Dimension(13, 14));
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        return jButton;
    }

    protected JButton getLeftScroller() {
        JButton jButton = this.createScrollingButton();
        jButton.setText("<");
        return jButton;
    }

    protected JButton getRightScroller() {
        JButton jButton = this.createScrollingButton();
        jButton.setText(">");
        return jButton;
    }

    public int getPopupInitiatorIndex() {
        return this.popupInitiatorIndex;
    }

    private class PopupAction
    extends AbstractAction {
        private static final String BreadCrumbItem_Key = "BreadCrumbItem";
        private static final String ParentIndex_Key = "ParentIndex";

        public PopupAction(BreadcrumbItem breadcrumbItem, int n) {
            super(breadcrumbItem.getName(), breadcrumbItem.getIcon());
            this.putValue(BreadCrumbItem_Key, breadcrumbItem);
            this.putValue(ParentIndex_Key, new Integer(n));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BreadcrumbItem breadcrumbItem = (BreadcrumbItem)this.getValue(BreadCrumbItem_Key);
            if (breadcrumbItem == null) {
                return;
            }
            int n = (Integer)this.getValue(ParentIndex_Key);
            while (BasicBreadcrumbBarUI.this.breadcrumbBar.getItemCount() > n + 1) {
                BasicBreadcrumbBarUI.this.breadcrumbBar.pop();
            }
            BasicBreadcrumbBarUI.this.breadcrumbBar.pushChoice(breadcrumbItem, false);
            BreadcrumbItemChoices breadcrumbItemChoices = BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getChoices(BasicBreadcrumbBarUI.this.breadcrumbBar.getPath());
            if (breadcrumbItemChoices != null) {
                BasicBreadcrumbBarUI.this.breadcrumbBar.pushChoices(breadcrumbItemChoices, false);
            }
            BasicBreadcrumbBarUI.this.updateComponents();
        }
    }

    protected class ScrollablePanelLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(container.getWidth(), 21);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3 = container.getWidth();
            int n4 = container.getHeight();
            ScrollablePanel scrollablePanel = BasicBreadcrumbBarUI.this.scrollerPanel;
            boolean bl = scrollablePanel.leftScroller.getParent() == BasicBreadcrumbBarUI.this.scrollerPanel;
            int n5 = bl ? n3 - ((ScrollablePanel)scrollablePanel).leftScroller.getPreferredSize().width - ((ScrollablePanel)scrollablePanel).rightScroller.getPreferredSize().width : n3;
            int n6 = 0;
            if (bl) {
                n2 = ((ScrollablePanel)scrollablePanel).leftScroller.getPreferredSize().width;
                n = ((ScrollablePanel)scrollablePanel).leftScroller.getPreferredSize().height;
                scrollablePanel.leftScroller.setBounds(0, (n4 - n) / 2, n2, n);
                n6 += n2;
            }
            scrollablePanel.scrollPane.setBounds(n6, 0, n5, n4);
            n6 += n5;
            if (bl) {
                n2 = ((ScrollablePanel)scrollablePanel).rightScroller.getPreferredSize().width;
                n = ((ScrollablePanel)scrollablePanel).rightScroller.getPreferredSize().height;
                scrollablePanel.rightScroller.setBounds(n6, (n4 - n) / 2, n2, n);
            }
        }
    }

    public class ScrollablePanel
    extends JPanel {
        private JButton leftScroller;
        private JButton rightScroller;
        private JScrollPane scrollPane;
        private JComponent view = null;
        private MouseListener scrollMouseListener = null;
        private int widthToScrollTo = 0;

        public ScrollablePanel(JComponent jComponent) {
            this.view = jComponent;
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            this.scrollPane.setOpaque(false);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setAutoscrolls(false);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setViewportView(jComponent);
            this.setOpaque(false);
            this.add(this.scrollPane);
            this.leftScroller = BasicBreadcrumbBarUI.this.getLeftScroller();
            this.leftScroller.setName("leftScroller");
            this.leftScroller.addMouseListener(this.getScrollerMouseListener());
            this.rightScroller = BasicBreadcrumbBarUI.this.getRightScroller();
            this.rightScroller.setName("rightScroller");
            this.rightScroller.addMouseListener(this.getScrollerMouseListener());
            this.setLayout(new ScrollablePanelLayout());
        }

        public void increaseWidthBy(int n) {
            this.validateScrolling(this.widthToScrollTo + n);
        }

        public void validateScrolling(int n) {
            this.widthToScrollTo = n;
            int n2 = this.view.getVisibleRect().width - 4;
            if (n2 > 0 && n2 < this.widthToScrollTo) {
                int n3;
                if (this.getComponentCount() <= 1) {
                    this.addScrollers();
                    n3 = this.widthToScrollTo + this.leftScroller.getWidth() + this.rightScroller.getWidth() - 4;
                } else {
                    n3 = this.widthToScrollTo - 4;
                }
                this.view.scrollRectToVisible(new Rectangle(n3, 0, 4, 4));
            } else {
                this.removeScrollers();
            }
        }

        public void removeScrollers() {
            this.view.scrollRectToVisible(new Rectangle(0, 0, 2, 2));
            this.remove(this.leftScroller);
            this.remove(this.rightScroller);
            this.revalidate();
            this.repaint();
        }

        private void addScrollers() {
            this.add((Component)this.leftScroller, "West");
            this.add((Component)this.rightScroller, "East");
            this.revalidate();
            this.repaint();
        }

        public MouseListener getScrollerMouseListener() {
            if (this.scrollMouseListener == null) {
                this.scrollMouseListener = new MouseAdapter(){
                    private boolean isPressed = false;

                    public void mousePressed(MouseEvent mouseEvent) {
                        this.isPressed = true;
                        final boolean bl = ((JComponent)mouseEvent.getSource()).getName().startsWith("left");
                        Thread thread = new Thread(){

                            public void run() {
                                double d;
                                int n = 12;
                                int n2 = 0;
                                while (isPressed && !((d = bl ? ScrollablePanel.this.view.getVisibleRect().getX() - (double)n : ScrollablePanel.this.view.getVisibleRect().getX() + ScrollablePanel.this.view.getVisibleRect().getWidth()) > (double)ScrollablePanel.this.widthToScrollTo)) {
                                    Rectangle rectangle = new Rectangle((int)d, 0, n, 8);
                                    ScrollablePanel.this.view.scrollRectToVisible(rectangle);
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (n2 > 2) {
                                        n += 5;
                                    }
                                    ++n2;
                                    Thread.yield();
                                }
                            }
                        };
                        thread.start();
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        this.isPressed = false;
                    }
                };
            }
            return this.scrollMouseListener;
        }
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(container.getWidth(), 21);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            int n2 = container.getWidth();
            int n3 = container.getHeight();
            BreadcrumbBar breadcrumbBar = BasicBreadcrumbBarUI.this.breadcrumbBar;
            int n4 = 0;
            if (BasicBreadcrumbBarUI.this.iconLabel != null) {
                n = BasicBreadcrumbBarUI.this.iconLabel.getPreferredSize().width;
                BasicBreadcrumbBarUI.this.iconLabel.setBounds(n4, 0, n, n3);
                n4 += n;
            }
            n = n2;
            JButton jButton = breadcrumbBar.getOkButton();
            if (jButton != null) {
                int n5 = jButton.getPreferredSize().width;
                jButton.setBounds(n2 - n5, 0, n5, n3);
                n -= n5;
            }
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(n4, 0, n - n4, n3);
        }
    }
}

