/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb;

import ddb.bcb.ui.BasicScrollablePopupUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollablePopup
extends JPopupMenu {
    public static final int ITEMS_MAX_NUMBER = 10;
    private int maxSize = -1;
    private List<Action> actions = null;
    private int maxWidth = 0;
    public static final String SELECTED_PROP = "ScrollablePopup.selected";
    private static final String uiClassID = "ScrollablePopupUI";

    public ScrollablePopup() {
        this(10);
    }

    public ScrollablePopup(int n) {
        this.maxSize = n;
        this.actions = new Vector<Action>();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.actions.clear();
        this.maxWidth = 0;
    }

    @Override
    public JMenuItem add(Action action) {
        return this.add(action, this.getFontMetrics(this.getFont()).stringWidth((String)action.getValue("Name")));
    }

    private JMenuItem add(Action action, int n) {
        if (this.getUI().getScrollUp() != null) {
            this.getUI().getScrollUp().setEnabled(false);
        }
        this.actions.add(action);
        this.maxWidth = Math.max(n + 20, this.maxWidth);
        try {
            ((JMenuItem)this.getComponent(2)).setPreferredSize(new Dimension(this.maxWidth, (int)this.getComponent(2).getPreferredSize().getHeight()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.actions.size() >= this.maxSize + 1) {
            this.getUI().addScrollers();
            return null;
        }
        JMenuItem jMenuItem = super.add(action);
        return jMenuItem;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.getInvoker().repaint();
        } else {
            Point point = this.getInvoker().getLocationOnScreen();
            if (this.getLocationOnScreen().getY() != point.getY() + this.getInvoker().getPreferredSize().getHeight()) {
                point.translate((int)this.getInvoker().getPreferredSize().getWidth(), 0);
                this.setLocation(point);
            }
        }
    }

    @Override
    public void setSelected(Component component) {
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            String string = jLabel.getText();
            Action action = null;
            for (Action action2 : this.actions) {
                if (action2.getValue("Name").toString().toLowerCase(Locale.ENGLISH).equals(string.toLowerCase(Locale.ENGLISH))) {
                    action = action2;
                }
                action2.putValue(SELECTED_PROP, Boolean.FALSE);
            }
            if (action != null) {
                action.putValue(SELECTED_PROP, Boolean.TRUE);
                this.getUI().scrollTo(this.actions.indexOf(action), true);
            }
        } else {
            if (component instanceof JMenuItem) {
                Font font = component.getFont();
                ((JMenuItem)component).setFont(font.deriveFont(font.getStyle() | 1));
            }
            super.setSelected(component);
            component.requestFocus();
        }
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setUI(BasicScrollablePopupUI basicScrollablePopupUI) {
        super.setUI(basicScrollablePopupUI);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BasicScrollablePopupUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicScrollablePopupUI.createUI(this));
        }
    }

    @Override
    public BasicScrollablePopupUI getUI() {
        return (BasicScrollablePopupUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

