/*
 * Decompiled with CFR 0.152.
 */
package ddb.antialiasing;

import ddb.console.ColorTheme;
import ddb.console.OptionPane;
import ddb.console.Themable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class AntialiasedTextField
extends JTextField
implements Observer,
Themable {
    private ColorTheme theme = null;

    public AntialiasedTextField(Document document, String string, int n) {
        this(document, string, n, true);
    }

    public AntialiasedTextField(String string, int n) {
        this(string, n, true);
    }

    public AntialiasedTextField(int n) {
        this(n, true);
    }

    public AntialiasedTextField(String string) {
        this(string, true);
    }

    public AntialiasedTextField() {
        this(true);
    }

    public AntialiasedTextField(Document document, String string, int n, boolean bl) {
        super(document, string, n);
        this.init(bl);
    }

    public AntialiasedTextField(String string, int n, boolean bl) {
        super(string, n);
        this.init(bl);
    }

    public AntialiasedTextField(int n, boolean bl) {
        super(n);
        this.init(bl);
    }

    public AntialiasedTextField(String string, boolean bl) {
        super(string);
        this.init(bl);
    }

    public AntialiasedTextField(boolean bl) {
        this.init(bl);
    }

    private void init(boolean bl) {
        this.putClientProperty("substancelaf.colorizationFactor", new Double(1.0));
        if (bl) {
            this.setTheme(OptionPane.getInstance().getSharedTheme());
        }
    }

    public void setTheme(ColorTheme colorTheme) {
        if (this.theme != null) {
            this.theme.deleteObserver(this);
        }
        this.theme = colorTheme;
        if (this.theme != null) {
            this.theme.addObserver(this);
            this.update(colorTheme, null);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(graphics2D);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ColorTheme) {
            ColorTheme colorTheme = (ColorTheme)observable;
            this.setForeground(colorTheme.getValue(ColorTheme.Location.NormalForeground));
            this.setCaretColor(colorTheme.getValue(ColorTheme.Location.NormalForeground));
            this.setBackground(colorTheme.getValue(ColorTheme.Location.NormalBackground));
        }
    }
}

