/*
 * Decompiled with CFR 0.152.
 */
package ddb;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;

public class GuiConstants {
    public static final FontDetails FIXED_WIDTH_FONT = new FontDetails("Andale Mono WTG", "/amwtg___.ttf");
    public static final FontDetails VARIABLE_WIDTH_FONT = new FontDetails("Arial Unicode MS", "/ARIALUNI.TTF");

    public static void locate(Frame frame, double d, double d2) {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int n = rectangle.width - frame.getPreferredSize().width;
        int n2 = rectangle.height - frame.getPreferredSize().height;
        Point point = new Point();
        point.x = rectangle.x + new Double((double)n * d).intValue();
        point.y = rectangle.y + new Double((double)n2 * d2).intValue();
        frame.setLocation(point);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultColor {
        DEFAULT_BACKGROUND(Color.BLACK),
        DEFAULT_FOREGROUND(Color.LIGHT_GRAY),
        SECONDARY_FOREGROUND(Color.BLUE),
        SECONDARY_BACKGROUND(Color.LIGHT_GRAY),
        PROMPT_MODE_BACKGROUND(Color.RED),
        PROMPT_MODE_FOREGROUND(Color.YELLOW),
        ERROR(Color.RED),
        WARNING(Color.YELLOW),
        NOTICE(Color.GREEN);

        Color col;

        private DefaultColor(Color color) {
            this.col = color;
        }

        public Color getColor() {
            return this.col;
        }
    }

    public static class FontDetails {
        public final String name;
        public final String file;
        public final int size;
        public final Font Basic;
        public final Font Bold;

        public FontDetails(String string, String string2) {
            this.name = string;
            this.file = string2;
            this.size = 14;
            Font font = null;
            InputStream inputStream = null;
            try {
                inputStream = GuiConstants.class.getResourceAsStream(string2);
                font = Font.createFont(0, inputStream);
            }
            catch (Exception exception) {
                font = new Font(string, 0, this.size);
                System.err.println("Failed to create font from file");
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.Basic = font.deriveFont(Float.parseFloat("14"));
            this.Bold = this.Basic.deriveFont(1);
        }
    }
}

