/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitProxy
implements InvocationHandler {
    Object[] objects;

    public static <T> T newInstance(Class<T> clazz, Object ... objects) {
        try {
            SplitProxy handler = new SplitProxy(objects);
            Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
            return (T)proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Throwable t) {
            Logger.getLogger("ds.core").log(Level.SEVERE, null, t);
            return null;
        }
    }

    private SplitProxy(Object ... objects) {
        this.objects = objects;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.objects == null) {
            return null;
        }
        Object retVal = null;
        for (Object o : this.objects) {
            try {
                retVal = method.invoke(o, args);
            }
            catch (Throwable t) {
                Logger.getLogger("ds.core").log(Level.SEVERE, null, t);
            }
        }
        return retVal;
    }
}

