/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DszProxyHandler<O>
implements InvocationHandler {
    protected O object;

    public static <O> O newInstance(O item, DszProxyHandler<O> handler, Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            Class<?> clazz = item.getClass();
            Vector interfaces = new Vector();
            LinkedList currentInterface = new LinkedList();
            currentInterface.offer(clazz);
            while (!currentInterface.isEmpty()) {
                Class clazz2 = (Class)currentInterface.poll();
                if (clazz2 == null) continue;
                if (clazz2.isInterface()) {
                    if (!interfaces.contains(clazz2)) {
                        interfaces.add(clazz2);
                    }
                } else {
                    for (Class<?> c : clazz2.getInterfaces()) {
                        if (interfaces.contains(c)) continue;
                        interfaces.add(c);
                    }
                }
                currentInterface.addAll(Arrays.asList(clazz2.getInterfaces()));
                currentInterface.add(clazz2.getSuperclass());
            }
            classes = interfaces.toArray(new Class[interfaces.size()]);
        }
        try {
            return (O)Proxy.newProxyInstance(item.getClass().getClassLoader(), classes, handler);
        }
        catch (Throwable t) {
            return item;
        }
    }

    protected DszProxyHandler(O object) {
        this.object = object;
    }

    public static final Object Unwrap(Object obj) {
        return DszProxyHandler.Unwrap(obj, true);
    }

    public static final Object Unwrap(Object obj, boolean recursive) {
        if (Proxy.isProxyClass(obj.getClass())) {
            InvocationHandler o = Proxy.getInvocationHandler(obj);
            if (!recursive) {
                return ((DszProxyHandler)DszProxyHandler.class.cast((Object)o)).object;
            }
            if (o instanceof DszProxyHandler) {
                return DszProxyHandler.Unwrap(((DszProxyHandler)DszProxyHandler.class.cast((Object)o)).object, recursive);
            }
        }
        return obj;
    }

    public static final Object GetHandler(Object obj) {
        if (Proxy.isProxyClass(obj.getClass())) {
            return Proxy.getInvocationHandler(obj);
        }
        return null;
    }

    public void stop() {
    }
}

