/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SplitPrintStream
extends PrintStream {
    private static final OutputStream VOID = new OutputStream(){

        public void write(int b) throws IOException {
        }
    };
    PrintStream[] others;
    Method ClearError;
    Method SetError;

    public SplitPrintStream(PrintStream ... other) throws FileNotFoundException {
        super(VOID);
        this.others = other;
        try {
            this.ClearError = PrintStream.class.getDeclaredMethod("clearError", new Class[0]);
            if (this.ClearError != null) {
                this.ClearError.setAccessible(true);
            }
            this.SetError = PrintStream.class.getDeclaredMethod("setError", new Class[0]);
            if (this.SetError != null) {
                this.SetError.setAccessible(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isValid() {
        return this.others != null && this.others.length > 0;
    }

    public PrintStream append(CharSequence csq) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.append(csq);
        }
        return this;
    }

    public PrintStream append(CharSequence csq, int start, int end) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.append(csq, start, end);
        }
        return this;
    }

    public PrintStream append(char c) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.append(c);
        }
        return this;
    }

    public boolean checkError() {
        if (!this.isValid()) {
            return false;
        }
        boolean error = false;
        for (PrintStream ps : this.others) {
            if (!ps.checkError()) continue;
            error = true;
        }
        return error;
    }

    protected void clearError() {
        if (!this.isValid()) {
            return;
        }
        if (this.ClearError != null) {
            for (PrintStream ps : this.others) {
                try {
                    this.ClearError.invoke((Object)ps, new Object[0]);
                }
                catch (Throwable ex) {
                    Logger.getLogger("ds.core").log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void close() {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.close();
        }
    }

    public void flush() {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.flush();
        }
    }

    public PrintStream format(String format, Object ... args) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.format(format, args);
        }
        return this;
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.format(l, format, args);
        }
        return this;
    }

    public void print(boolean b) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(b);
        }
    }

    public void print(char c) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(c);
        }
    }

    public void print(int i) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(i);
        }
    }

    public void print(long l) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(l);
        }
    }

    public void print(float f) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(f);
        }
    }

    public void print(double d) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(d);
        }
    }

    public void print(char[] s) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(s);
        }
    }

    public void print(String s) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(s);
        }
    }

    public void print(Object obj) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.print(obj);
        }
    }

    public PrintStream printf(String format, Object ... args) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.printf(format, args);
        }
        return this;
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        if (!this.isValid()) {
            return this;
        }
        for (PrintStream ps : this.others) {
            ps.printf(l, format, args);
        }
        return this;
    }

    public void println() {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println();
        }
    }

    public void println(boolean x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(char x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(int x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(long x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(float x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(double x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(char[] x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(String x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    public void println(Object x) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.println(x);
        }
    }

    protected void setError() {
        if (!this.isValid()) {
            return;
        }
        if (this.ClearError != null) {
            for (PrintStream ps : this.others) {
                try {
                    this.SetError.invoke((Object)ps, new Object[0]);
                }
                catch (Throwable ex) {
                    Logger.getLogger("ds.core").log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void write(int b) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.write(b);
        }
    }

    public void write(byte[] buf, int off, int len) {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            ps.write(buf, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this.isValid()) {
            return;
        }
        for (PrintStream ps : this.others) {
            try {
                ps.write(b);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

