/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.systemlogviewer;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.gui.javalogviewer.JavaLogViewer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JComponent;

@DszLive(live=true, replay=true)
@DszLogo(value="images/system-log-viewer.png")
@DszName(value="System Log Viewer")
@DszDescription(value="Monitors log events and displays them nicely")
public class SystemLogViewer
extends NoHostAbstractPlugin {
    public static final String MONITOR_ICON = "images/system-log-viewer.png";
    JavaLogViewer logViewer = new JavaLogViewer();
    Handler updater = new Handler(){

        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                SystemLogViewer.this.importantChange();
            }
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }

        public synchronized Level getLevel() {
            return Level.WARNING;
        }
    };
    Handler forwarder = new Handler(){

        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel().intValue() < this.getLevel().intValue()) {
                return;
            }
            SystemLogViewer.this.logViewer.append(logRecord);
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }

        public synchronized Level getLevel() {
            if (SystemLogViewer.this.core.isDebugMode()) {
                return Level.ALL;
            }
            return Level.WARNING;
        }
    };

    public SystemLogViewer() {
        super.setName("System Log Viewer");
    }

    void importantChange() {
        this.fireContentsChanged();
    }

    protected void fini2() {
        this.core.getSystemLogger().removeHandler(this.forwarder);
    }

    protected int init2() {
        this.core.getSystemLogger().addHandler(this.forwarder);
        this.core.getSystemLogger().addHandler(this.updater);
        super.setDisplay((JComponent)this.logViewer);
        return 0;
    }

    protected boolean parseArgument2(String string, String string2) {
        if (string.equalsIgnoreCase("-max") && string2 != null) {
            try {
                this.logViewer.setMaximum(Integer.parseInt(string2));
                return true;
            }
            catch (Exception exception) {
                this.core.logEvent(Level.SEVERE, "Invalid commandline parameter for SystemLogViewer:  \n" + string);
                return false;
            }
        }
        return false;
    }
}

