/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.notify;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.GuiCommand;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.AbstractPlugin;
import ddb.dsz.plugin.notify.NotifyDisplayWindow;
import ddb.imagemanager.ImageManager;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.UniquePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/knotify.png")
@DszName(value="Notify")
@DszDescription(value="A table of commands started with the notify prefix")
@DszUserStartable(value=false)
public class NotifyWindow
extends AbstractPlugin
implements Observer {
    private static String[] GUI_COMMANDS = new String[]{".notify"};
    private JTable notifyTable;
    Predicate isNewNotifyCommand = AllPredicate.getInstance((Predicate[])new Predicate[]{new Predicate(){

        public boolean evaluate(Object object) {
            if (!(object instanceof Task)) {
                return false;
            }
            Task task = (Task)Task.class.cast(object);
            return task.getGuiFlagValue("notify") != null;
        }
    }, UniquePredicate.getInstance()});
    Set<Task> watchedCommands = new HashSet<Task>();

    public NotifyWindow() {
        this.notifyTable = new JTable();
        super.setDisplay((JComponent)this.notifyTable);
        super.setName("Notify");
        this.prefferedSize = new Dimension(400, 400);
        super.setCareAboutLocalEvents(true);
    }

    protected int init2() {
        this.setGuiCommandPredicate(new Predicate(){

            public boolean evaluate(Object object) {
                Task task;
                if (!(object instanceof GuiCommand)) {
                    return false;
                }
                GuiCommand guiCommand = (GuiCommand)GuiCommand.class.cast(object);
                if (guiCommand.getId() != null && (task = NotifyWindow.this.core.getTaskById(guiCommand.getId())) == null) {
                    return false;
                }
                for (Task task2 : GUI_COMMANDS) {
                    if (!guiCommand.getGuiCommand().toLowerCase().startsWith((String)task2)) continue;
                    return true;
                }
                return false;
            }
        });
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGuiCommand(GuiCommand guiCommand) {
        super.commandGui(guiCommand);
        String string = guiCommand.getGuiCommand();
        if (string.toLowerCase().startsWith(".notify")) {
            String string2 = null;
            String[] stringArray = string.split(" +", 2);
            if (stringArray.length == 2) {
                string2 = stringArray[1];
            }
            this.core.logEvent(Level.INFO, "Notify Command:  " + guiCommand);
            boolean bl = false;
            try {
                if (string2 == null) {
                    return;
                }
                int n = Integer.parseInt(string2);
                TaskId taskId = TaskId.GenerateTaskId((int)n, (Operation)this.core.getOperation());
                if (taskId == null) {
                    return;
                }
                Task task = this.core.getRunningTaskById(taskId);
                if (task == null) {
                    return;
                }
                try {
                    this.watchedCommands.add(task);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    this.core.logEvent(Level.WARNING, "Gui Command had invalid number: " + string2);
                    return;
                }
            }
            finally {
                this.core.sendGuiCommandResponse(guiCommand.getReqId(), bl);
            }
            return;
        }
        this.core.sendGuiCommandResponse(guiCommand.getReqId(), false);
    }

    protected void commandEnded(CommandEvent commandEvent) {
        super.commandEnded(commandEvent);
        Task task = this.core.getTaskById(commandEvent.getId());
        if (this.isNewNotifyCommand.evaluate((Object)task) || this.watchedCommands.contains(task)) {
            new NotifyDisplayWindow(task).setVisible(true);
            this.watchedCommands.remove(task);
        }
    }

    public boolean runInternalCommand(List<String> list, InternalCommandCallback internalCommandCallback) {
        if (list.size() == 2 && list.get(0).equalsIgnoreCase("notify")) {
            try {
                int n = Integer.parseInt(list.get(1));
                Task task = this.core.getRunningTaskById(TaskId.GenerateTaskId((int)n, (Operation)this.core.getOperation()));
                if (task != null) {
                    this.watchedCommands.add(task);
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.runInternalCommand(list, internalCommandCallback);
    }

    @Override
    public void update(Observable observable, Object object) {
        Task task = (Task)observable;
        String string = null;
        switch (task.getState()) {
            case FAILED: {
                string = "has ended in failure";
                break;
            }
            case KILLED: {
                string = "was killed";
                break;
            }
            case SUCCEEDED: {
                string = "succeeded";
                break;
            }
            default: {
                return;
            }
        }
        JOptionPane.showMessageDialog(this.parentDisplay, String.format("<html><b>%s</b> %s</html>", task.getTypedCommand(), string), "Command Notification", 1, ImageManager.getIcon((String)NotifyWindow.super.getLogo(), (Dimension)ImageManager.BANNER_SIZE));
    }
}

