/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.notify;

import ddb.dsz.core.task.Task;
import ddb.imagemanager.ImageManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class NotifyDisplayWindow
extends JFrame {
    public static final String SUCCESS = "images/256x256/agt_action_success.png";
    public static final String FAILURE = "images/256x256/cancel.png";
    public static final String RUNNING = "images/256x256/agt_pause-queue.png";
    public static final String OTHER = "images/256x256/agt_update_critical.png";
    public static final Object LOCATION_LOCK = new Object();
    public static final Point STEP = new Point(32, 32);
    public static Point LAST_LOCATION = null;
    private JLabel commandField;
    private JLabel durationField;
    private JLabel hostField;
    private JLabel iconDisplay;
    private JLabel idField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JLabel stateField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyDisplayWindow(Task task) {
        this.initComponents();
        Object object = LOCATION_LOCK;
        synchronized (object) {
            if (LAST_LOCATION == null) {
                LAST_LOCATION = new Point(0, 0);
            } else {
                NotifyDisplayWindow.LAST_LOCATION.x += NotifyDisplayWindow.STEP.x;
                NotifyDisplayWindow.LAST_LOCATION.y += NotifyDisplayWindow.STEP.y;
            }
            Dimension dimension = new Dimension(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height);
            if (this.getSize().width > dimension.width || NotifyDisplayWindow.LAST_LOCATION.x + this.getSize().width > dimension.width) {
                NotifyDisplayWindow.LAST_LOCATION.x = 0;
            }
            if (this.getSize().height > dimension.height || NotifyDisplayWindow.LAST_LOCATION.y + this.getSize().height > dimension.height) {
                NotifyDisplayWindow.LAST_LOCATION.y = 0;
            }
            this.setLocation(NotifyDisplayWindow.LAST_LOCATION.x, NotifyDisplayWindow.LAST_LOCATION.y);
        }
        switch (task.getState()) {
            case FAILED: 
            case KILLED: {
                this.stateField.setText("FAILURE");
                this.stateField.setForeground(Color.RED);
                this.iconDisplay.setIcon(ImageManager.getIcon((String)FAILURE, (Dimension)ImageManager.NOTICE_SIZE));
                break;
            }
            case INITIALIZED: 
            case PAUSED: 
            case RUNNING: 
            case TASKED: {
                this.stateField.setText("IN PROGRESS");
                this.stateField.setForeground(Color.BLUE);
                this.iconDisplay.setIcon(ImageManager.getIcon((String)RUNNING, (Dimension)ImageManager.NOTICE_SIZE));
                break;
            }
            case SUCCEEDED: {
                this.stateField.setText("SUCCESS");
                this.stateField.setForeground(Color.GREEN);
                this.iconDisplay.setIcon(ImageManager.getIcon((String)SUCCESS, (Dimension)ImageManager.NOTICE_SIZE));
                break;
            }
            default: {
                this.stateField.setText("OTHER");
                this.stateField.setForeground(Color.YELLOW);
                this.iconDisplay.setIcon(ImageManager.getIcon((String)OTHER, (Dimension)ImageManager.NOTICE_SIZE));
                return;
            }
        }
        this.idField.setText(String.format("%d", task.getId().getId()));
        this.hostField.setText(task.getTargetId());
        this.commandField.setText(task.getTypedCommand());
        object = Calendar.getInstance(task.getCreated().getTimeZone());
        long l = ((Calendar)object).getTimeInMillis() - task.getCreated().getTimeInMillis();
        long l2 = l % 1000L;
        l /= 1000L;
        if (l2 > 0L) {
            ++l;
        }
        long l3 = l % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = (l /= 60L) % 24L;
        long l6 = l /= 24L;
        String string = "";
        if (l6 > 0L) {
            string = String.format("%d days, ", new Object[0]);
        }
        this.durationField.setText(String.format("%s%02d:%02d:%02d", string, l5, l4, l3, l2));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.iconDisplay = new JLabel();
        this.jLabel1 = new JLabel();
        this.idField = new JLabel();
        this.jLabel5 = new JLabel();
        this.hostField = new JLabel();
        this.jLabel2 = new JLabel();
        this.commandField = new JLabel();
        this.jLabel3 = new JLabel();
        this.stateField = new JLabel();
        this.jLabel4 = new JLabel();
        this.durationField = new JLabel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Command Notification");
        this.setAlwaysOnTop(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.iconDisplay.setHorizontalAlignment(0);
        this.iconDisplay.setMinimumSize(new Dimension(128, 128));
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconDisplay, -1, 128, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconDisplay, -1, 128, Short.MAX_VALUE));
        this.jLabel1.setText("Id:");
        this.idField.setFont(new Font("Tahoma", 1, 11));
        this.idField.setText("jLabel5");
        this.jLabel5.setText("Target:");
        this.hostField.setFont(new Font("Tahoma", 1, 11));
        this.hostField.setText("jLabel6");
        this.jLabel2.setText("Command:");
        this.commandField.setFont(new Font("Tahoma", 1, 11));
        this.commandField.setText("jLabel6");
        this.jLabel3.setText("State:");
        this.stateField.setFont(new Font("Tahoma", 1, 11));
        this.stateField.setText("jLabel6");
        this.jLabel4.setText("Duration:");
        this.durationField.setFont(new Font("Tahoma", 1, 11));
        this.durationField.setText("jLabel6");
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotifyDisplayWindow.this.jButton1ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idField, -1, 62, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hostField, -1, 63, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandField, -1, 148, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stateField, -1, 169, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.durationField, -1, 154, Short.MAX_VALUE)))).addGroup(groupLayout2.createSequentialGroup().addGap(74, 74, 74).addComponent(this.jButton1))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.idField).addComponent(this.jLabel5).addComponent(this.hostField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.commandField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.stateField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.durationField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

