/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jvnet.flamingo.common.ImagePanel;
import org.jvnet.flamingo.common.ProgressGlassPane;
import org.jvnet.flamingo.wizard.WizardImageCreator;
import org.jvnet.flamingo.wizard.WizardSettings;
import org.jvnet.flamingo.wizard.WizardStep;
import org.jvnet.lafwidget.layout.TransitionLayoutManager;

public class WizardMainFrame
extends JFrame {
    protected final LinkedList<WizardStep> steps;
    protected WizardStep currStep;
    private final JLabel titleLabel;
    private final JButton backButton;
    private final JButton nextButton;
    private WizardMode mode;
    protected final JButton finishButton;
    private final JButton quitButton;
    private final JPanel mainPanel;
    private final JPanel stepPanel;
    private final JLabel imageLabel;
    private final JLabel helpLabel;
    private Component currStepComponent;
    private final int imageWidth;
    private final int remainderWidth;
    private String currentDirectoryName;
    private final ProgressGlassPane glassPane;

    protected WizardMainFrame(String title, int width, int height, WizardMode mode) {
        super(title);
        this.mode = mode;
        this.steps = new LinkedList();
        this.backButton = new JButton("Back");
        this.nextButton = new JButton("Next");
        this.finishButton = new JButton("Finish");
        this.quitButton = new JButton("Quit");
        this.backButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.finishButton.setMargin(new Insets(0, 0, 0, 0));
        this.quitButton.setMargin(new Insets(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.imageWidth = width / 6;
        this.remainderWidth = width - this.imageWidth;
        this.imageLabel = new JLabel();
        this.imageLabel.setBorder(null);
        this.imageLabel.setPreferredSize(new Dimension(this.imageWidth, height));
        this.add((Component)this.imageLabel, "West");
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.stepPanel = new ImagePanel(WizardImageCreator.getBackgroundImage(this.remainderWidth, height - 70, true));
        this.stepPanel.setOpaque(false);
        this.stepPanel.setLayout(new BorderLayout());
        this.helpLabel = new JLabel();
        this.stepPanel.add((Component)this.helpLabel, "South");
        this.mainPanel.add((Component)this.stepPanel, "Center");
        ImagePanel buttonPanel = new ImagePanel(WizardImageCreator.getBackgroundImage(this.remainderWidth, 40, true));
        buttonPanel.setPreferredSize(new Dimension(this.remainderWidth, 40));
        buttonPanel.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1, 10, 5));
        buttonsPanel.add(this.backButton);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(this.finishButton);
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add(this.quitButton);
        buttonsPanel.setOpaque(false);
        buttonPanel.setOpaque(false);
        buttonPanel.add(Box.createVerticalStrut(5), "North");
        buttonPanel.add((Component)buttonsPanel, "Center");
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardMainFrame.this.back();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardMainFrame.this.next();
            }
        });
        this.mainPanel.add((Component)buttonPanel, "South");
        this.titleLabel = new JLabel();
        this.titleLabel.setPreferredSize(new Dimension(this.remainderWidth, 30));
        this.mainPanel.add((Component)this.titleLabel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.glassPane = new ProgressGlassPane(this.getRootPane());
        this.setGlassPane(this.glassPane);
        this.setDefaultCloseOperation(0);
        this.setSize(width, height);
        this.setResizable(false);
    }

    public final void setWaitingMessage(String message) {
        this.glassPane.setMessage(message);
    }

    protected final void setImage() {
        Dimension d = this.getSize();
        this.imageLabel.setIcon(this.currStep.getStepIcon(this.imageWidth, (int)d.getHeight()));
    }

    public final void update() {
        boolean hasBackButton = this.currStep != this.steps.getFirst();
        boolean hasNextButton = this.currStep != this.steps.getLast();
        boolean hasFinishButton = this.currStep == this.steps.getLast();
        boolean isNextStepEnabled = this.currStep.canProceed();
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        if (hasBackButton) {
            this.backButton.setEnabled(true);
        }
        if (hasNextButton && isNextStepEnabled) {
            this.nextButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.nextButton);
        }
        if (hasFinishButton && isNextStepEnabled) {
            this.finishButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.finishButton);
        }
        if (this.currStepComponent != null) {
            this.currStepComponent.setVisible(false);
        }
        this.currStepComponent = this.currStep.getComponent();
        this.currStepComponent.setVisible(true);
        this.stepPanel.add(this.currStepComponent, "Center");
        this.stepPanel.add(Box.createVerticalStrut(10), "North");
        this.helpLabel.setIcon(WizardImageCreator.getMultiline(this.currStep.getDescription(), this.remainderWidth, Color.black, Color.white));
        this.titleLabel.setIcon(WizardImageCreator.getTitleImage(this.remainderWidth, 30, this.currStep.getTitle(), Color.black, Color.white));
        this.titleLabel.setText("      " + this.currStep.getTitle());
        this.repaint();
    }

    protected final void next() {
        if (this.currStep.isSupportsDirectory()) {
            this.currentDirectoryName = this.currStep.getCurrentDirectory();
        }
        Iterator itStep = this.steps.iterator();
        boolean takeNext = false;
        boolean taken = false;
        while (itStep.hasNext()) {
            WizardStep step = (WizardStep)itStep.next();
            if (takeNext) {
                this.currStep = step;
                taken = true;
                break;
            }
            if (step != this.currStep) continue;
            takeNext = true;
        }
        if (!taken) {
            throw new IllegalStateException("No next step when next was available");
        }
        if (this.currStep.isSupportsDirectory()) {
            this.currStep.setCurrentDirectory(this.currentDirectoryName);
        }
        this.update();
        this.setImage();
    }

    protected final void back() {
        if (this.currStep.isSupportsDirectory()) {
            this.currentDirectoryName = this.currStep.getCurrentDirectory();
        }
        Iterator itStep = this.steps.iterator();
        WizardStep prevStep = null;
        boolean taken = false;
        while (itStep.hasNext()) {
            WizardStep step = (WizardStep)itStep.next();
            if (step == this.currStep) {
                this.currStep = prevStep;
                taken = true;
                break;
            }
            prevStep = step;
        }
        if (!taken || this.currStep == null) {
            throw new IllegalStateException("No prev step when prev was available");
        }
        if (this.currStep.isSupportsDirectory()) {
            this.currStep.setCurrentDirectory(this.currentDirectoryName);
        }
        this.update();
        this.setImage();
    }

    public final void freeze() {
        this.glassPane.setVisible(true);
    }

    public final void unfreeze() {
        this.glassPane.setVisible(false);
    }

    public void setGlassPaneColors(Color darkColor, Color midColor, Color lightColor) {
        this.glassPane.setGlassPaneColors(darkColor, midColor, lightColor);
    }

    public void setQuitListener(final ActionListener quitListener) {
        this.quitButton.addActionListener(quitListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                quitListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
            }
        });
    }

    public void setFinishListener(ActionListener finishListener) {
        this.finishButton.addActionListener(finishListener);
    }

    public WizardMode getMode() {
        return this.mode;
    }

    private static void removeFocus(Component comp) {
        comp.setFocusable(false);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                WizardMainFrame.removeFocus(cont.getComponent(i));
            }
        }
    }

    public void start(WizardSettings initialSettings) {
        if (this.mode == WizardMode.SEMI_MANUAL || this.mode == WizardMode.AUTOMATIC) {
            for (WizardStep step : this.steps) {
                step.importSettings(initialSettings);
            }
        }
        this.currStep = this.steps.getFirst();
        this.currentDirectoryName = System.getProperty("user.dir");
        if (this.currStep.isSupportsDirectory()) {
            this.currStep.setCurrentDirectory(this.currentDirectoryName);
        }
        this.setImage();
        if (this.mode == WizardMode.AUTOMATIC) {
            WizardStep lastStep;
            this.currStep = lastStep = this.steps.getLast();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardMainFrame.this.update();
                    WizardMainFrame.this.setImage();
                    WizardMainFrame.removeFocus(WizardMainFrame.this.currStep.getComponent());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WizardMainFrame.this.finishButton.doClick();
                        }
                    });
                }
            });
        }
        this.update();
    }

    public void setNavigationButtonsFocusable(boolean isFocusable) {
        this.backButton.setFocusable(isFocusable);
        this.nextButton.setFocusable(isFocusable);
        this.quitButton.setFocusable(isFocusable);
        this.finishButton.setFocusable(isFocusable);
    }

    public void installTransitionEffects() {
        TransitionLayoutManager.getInstance().track((Container)this.stepPanel, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WizardMode {
        STANDALONE,
        MANUAL,
        SEMI_MANUAL,
        AUTOMATIC;

    }
}

