/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.wizard;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class WizardImageCreator {
    public static BufferedImage getBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                image.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return image;
    }

    public static Icon getStepImage(Color main, int width, int height, String string) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Color text = new Color(255 - main.getRed(), 255 - main.getGreen(), 255 - main.getBlue());
        double coef = 0.9;
        Color dark = new Color((int)(coef * (double)main.getRed()), (int)(coef * (double)main.getGreen()), (int)(coef * (double)main.getBlue()));
        Color light = new Color(255 - (int)(coef * (double)(255 - main.getRed())), 255 - (int)(coef * (double)(255 - main.getGreen())), 255 - (int)(coef * (double)(255 - main.getBlue())));
        graphics.drawImage((Image)WizardImageCreator.getBackgroundStripedImage(width, height, light, main, dark), 0, 0, null);
        int cellCount = 4;
        int cellSizeX = width / cellCount;
        int cellSizeY = height / cellCount;
        for (int i = 0; i < cellCount; ++i) {
            for (int j = 0; j < cellCount; ++j) {
                int fontSize = (int)(15.0 + 15.0 * Math.random());
                int r = (int)((double)(text.getRed() + 20) - 40.0 * Math.random());
                r = Math.max(r, 0);
                r = Math.min(r, 255);
                int g = (int)((double)(text.getGreen() + 20) - 40.0 * Math.random());
                g = Math.max(g, 0);
                g = Math.min(g, 255);
                int b = (int)((double)(text.getBlue() + 20) - 40.0 * Math.random());
                b = Math.max(b, 0);
                b = Math.min(b, 255);
                graphics.setColor(new Color(r, g, b));
                graphics.setFont(new Font("Arial", 0, fontSize));
                FontRenderContext frc = graphics.getFontRenderContext();
                TextLayout mLayout = new TextLayout(string, graphics.getFont(), frc);
                int x = (int)(((double)i + Math.random()) * (double)cellSizeX - mLayout.getBounds().getWidth() / 2.0);
                int y = (int)(((double)j + Math.random()) * (double)cellSizeY);
                AlphaComposite c = AlphaComposite.getInstance(3, (float)(0.2 + 0.8 * Math.random()));
                graphics.setComposite(c);
                graphics.drawString(string, x, y);
            }
        }
        return new ImageIcon(image);
    }

    public static Icon getTitleImage(int width, int height, String title, Color foregroundColor, Color shadowColor) {
        BufferedImage image = WizardImageCreator.getBackgroundImage(width, height, false);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = new Font("Arial", 0, height - 8);
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        FontRenderContext frc = graphics.getFontRenderContext();
        TextLayout mLayout = new TextLayout(title, font, frc);
        Rectangle2D bounds = mLayout.getBounds();
        double x = ((double)width - bounds.getWidth()) / 2.0;
        double y = ((double)height - bounds.getHeight() + (double)fm.getHeight()) / 2.0 + 3.0;
        AlphaComposite c = AlphaComposite.getInstance(3, 0.8f);
        graphics.setComposite(c);
        graphics.setColor(shadowColor);
        graphics.drawString(title, (int)x + 1, (int)y + 1);
        c = AlphaComposite.getInstance(3, 1.0f);
        graphics.setComposite(c);
        graphics.setColor(foregroundColor);
        graphics.drawString(title, (int)x, (int)y);
        return new ImageIcon(image);
    }

    public static BufferedImage getBackgroundStripedImage(int width, int height, Color lightColor, Color midColor, Color darkColor) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        GradientPaint gpLightLeft = new GradientPaint(0.0f, 0.0f, lightColor, width / 2, 0.0f, midColor);
        GradientPaint gpLightRight = new GradientPaint(width / 2, 0.0f, midColor, width, 0.0f, lightColor);
        GradientPaint gpDarkLeft = new GradientPaint(0.0f, 0.0f, midColor, width / 2, 0.0f, darkColor);
        GradientPaint gpDarkRight = new GradientPaint(width / 2, 0.0f, darkColor, width, 0.0f, midColor);
        for (int row = 0; row < height; ++row) {
            GradientPaint gpLeft = row % 2 == 0 ? gpLightLeft : gpDarkLeft;
            graphics.setPaint(gpLeft);
            graphics.drawLine(0, row, width / 2, row);
            GradientPaint gpRight = row % 2 == 0 ? gpLightRight : gpDarkRight;
            graphics.setPaint(gpRight);
            graphics.drawLine(width / 2, row, width, row);
        }
        return image;
    }

    public static BufferedImage getBackgroundImage(int width, int height, boolean hasStripeTop) {
        BufferedImage image = WizardImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        if (hasStripeTop) {
            for (int col = 0; col < width; ++col) {
                float transp = Math.abs((float)(col - width / 2)) / (float)(width / 2);
                transp = Math.min(1.0f, (float)((double)transp * 1.25));
                AlphaComposite c = AlphaComposite.getInstance(3, 1.0f - transp);
                graphics.setComposite(c);
                graphics.setColor(Color.black);
                graphics.drawLine(col, 0, col, 2);
            }
        }
        return image;
    }

    public static Icon getMultiline(String str, int width, Color foregroundColor, Color shadowColor) {
        if (str == null) {
            str = "";
        }
        BufferedImage tempImage = new BufferedImage(width, 20, 2);
        Graphics2D tempGraphics = (Graphics2D)tempImage.getGraphics();
        tempGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Font font = new Font("Arial", 0, 12);
        tempGraphics.setFont(font);
        FontRenderContext frc = tempGraphics.getFontRenderContext();
        LinkedList<String> lines = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, " ", false);
        String currLine = "";
        while (tokenizer.hasMoreTokens()) {
            String currToken = tokenizer.nextToken() + " ";
            String newLine = currLine + currToken;
            TextLayout mLayout = new TextLayout(newLine, font, frc);
            Rectangle2D bounds = mLayout.getBounds();
            if (bounds.getWidth() > (double)(width - 20)) {
                lines.addLast(currLine);
                currLine = currToken;
                continue;
            }
            currLine = newLine;
        }
        lines.addLast(currLine);
        int lineCount = lines.size();
        FontMetrics fm = tempGraphics.getFontMetrics();
        int height = lineCount * (fm.getHeight() + 5);
        BufferedImage image = WizardImageCreator.getBackgroundImage(width, height, false);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics.setFont(font);
        int ypos = fm.getHeight();
        for (String line : lines) {
            AlphaComposite c = AlphaComposite.getInstance(3, 0.8f);
            graphics.setComposite(c);
            graphics.setColor(shadowColor);
            graphics.drawString(line, 6, ypos + 1);
            c = AlphaComposite.getInstance(3, 1.0f);
            graphics.setComposite(c);
            graphics.setColor(foregroundColor);
            graphics.drawString(line, 5, ypos);
            ypos += fm.getHeight() + 1;
        }
        return new ImageIcon(image);
    }

    public static BufferedImage createGradientLine(int width, Color leftColor, Color rightColor, double opacity) {
        BufferedImage image = new BufferedImage(width, 1, 2);
        int iOpacity = (int)(255.0 * opacity);
        for (int col = 0; col < width; ++col) {
            double coef = (double)col / (double)width;
            int r = (int)((double)leftColor.getRed() + coef * (double)(rightColor.getRed() - leftColor.getRed()));
            int g = (int)((double)leftColor.getGreen() + coef * (double)(rightColor.getGreen() - leftColor.getGreen()));
            int b = (int)((double)leftColor.getBlue() + coef * (double)(rightColor.getBlue() - leftColor.getBlue()));
            int color = iOpacity << 24 | r << 16 | g << 8 | b;
            image.setRGB(col, 0, color);
        }
        return image;
    }
}

