/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.jvnet.flamingo.bcb.BreadcrumbBar;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbBarEvent;
import org.jvnet.flamingo.bcb.BreadcrumbBarListener;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbItemChoices;
import org.jvnet.flamingo.svg.SvgFileViewPanel;

public class SvgViewer
extends JFrame {
    private BreadcrumbBar bar = new BreadcrumbBar(":", new DirCallback());
    private SvgFileViewPanel svgFileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;
    protected static FileSystemView fsv = FileSystemView.getFileSystemView();

    protected static BreadcrumbItemChoices getChoices(File folder) {
        if (!folder.exists()) {
            return null;
        }
        if (!folder.isDirectory()) {
            return null;
        }
        LinkedList<BreadcrumbItem> lResult = new LinkedList<BreadcrumbItem>();
        for (File child : folder.listFiles()) {
            if (!child.isDirectory() || child.isHidden()) continue;
            BreadcrumbItem currDirItem = new BreadcrumbItem(new String[]{child.getName(), child.getAbsolutePath()});
            currDirItem.setIcon(fsv.getSystemIcon(child));
            lResult.addLast(currDirItem);
        }
        BreadcrumbItem[] aResult = new BreadcrumbItem[lResult.size()];
        int count = 0;
        for (BreadcrumbItem item : lResult) {
            aResult[count++] = item;
        }
        return new BreadcrumbItemChoices(aResult);
    }

    public SvgViewer() {
        super("SVG File Viewer");
        File[] roots = File.listRoots();
        BreadcrumbItem[] bRoots = new BreadcrumbItem[roots.length];
        int count = 0;
        for (File root : roots) {
            String systemName = fsv.getSystemDisplayName(root);
            if (systemName.length() == 0) {
                systemName = root.getAbsolutePath();
            }
            BreadcrumbItem rootItem = new BreadcrumbItem(new String[]{systemName, root.getAbsolutePath()});
            Icon icon = fsv.getSystemIcon(root);
            rootItem.setIcon(icon);
            bRoots[count++] = rootItem;
        }
        this.bar.pushChoices(new BreadcrumbItemChoices(bRoots));
        this.bar.addListener(new BreadcrumbBarListener(){

            public void breadcrumbBarEvent(BreadcrumbBarEvent event) {
                if (event.getType() == 0) {
                    BreadcrumbItem[] newPath = (BreadcrumbItem[])event.getNewValue();
                    System.out.println("New path is ");
                    for (BreadcrumbItem item : newPath) {
                        String[] values = item.getValue();
                        System.out.println("\t" + values[1]);
                    }
                    if (newPath.length > 0) {
                        BreadcrumbItem lastElem = newPath[newPath.length - 1];
                        File lastDir = new File(lastElem.getValue()[1]);
                        SvgViewer.this.svgFileViewPanel.setFolder(lastDir);
                        SvgViewer.this.svgFileViewPanel.setIconDimension(SvgViewer.this.currIconSize);
                    }
                    return;
                }
                if (event.getType() == 2) {
                    BreadcrumbItem item = (BreadcrumbItem)event.getNewValue();
                    item.setIcon(fsv.getSystemIcon(new File(item.getValue()[1])));
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 32;
        this.svgFileViewPanel = new SvgFileViewPanel(initialSize);
        JScrollPane jsp = new JScrollPane(this.svgFileViewPanel, 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(16);
        this.iconSizeSlider.setMaximum(128);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(32);
        this.iconSizeSlider.setMinorTickSpacing(8);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int newValue;
                if (!SvgViewer.this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = SvgViewer.this.iconSizeSlider.getValue()) != SvgViewer.this.currIconSize) {
                    SvgViewer.this.currIconSize = newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SvgViewer.this.svgFileViewPanel.setIconDimension(SvgViewer.this.currIconSize);
                        }
                    });
                }
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
        JMenuBar jmb = new JMenuBar();
        JMenu menu = new JMenu("Look-and-feel");
        menu.add(LafChanger.getMenuItem(this, "Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Windows Classic", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Substance", "org.jvnet.substance.SubstanceLookAndFeel"));
        jmb.add(menu);
        this.setJMenuBar(jmb);
    }

    public static void main(String ... args) {
        SvgViewer test = new SvgViewer();
        test.setSize(700, 400);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
        test.setDefaultCloseOperation(3);
    }

    private static class LafChanger
    implements ActionListener {
        private JFrame frame;
        private String lafClassName;

        public static JMenuItem getMenuItem(JFrame frame, String lafName, String lafClassName) {
            JMenuItem result = new JMenuItem(lafName);
            result.addActionListener(new LafChanger(frame, lafClassName));
            return result;
        }

        public LafChanger(JFrame frame, String lafClassName) {
            this.frame = frame;
            this.lafClassName = lafClassName;
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean was_wm_decorated = !LafChanger.this.frame.isUndecorated();
                    try {
                        UIManager.setLookAndFeel(LafChanger.this.lafClassName);
                        SwingUtilities.updateComponentTreeUI(LafChanger.this.frame);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
    }

    public static class DirCallback
    implements BreadcrumbBarCallBack {
        public BreadcrumbItemChoices getChoices(BreadcrumbItem[] path) {
            if (path == null) {
                File[] roots = File.listRoots();
                BreadcrumbItem[] bRoots = new BreadcrumbItem[roots.length];
                int count = 0;
                for (File root : roots) {
                    String systemName = fsv.getSystemDisplayName(root);
                    if (systemName.length() == 0) {
                        systemName = root.getAbsolutePath();
                    }
                    BreadcrumbItem rootItem = new BreadcrumbItem(new String[]{systemName, root.getAbsolutePath()});
                    rootItem.setIcon(fsv.getSystemIcon(root));
                    bRoots[count++] = rootItem;
                }
                return new BreadcrumbItemChoices(bRoots);
            }
            if (path.length == 0) {
                return null;
            }
            String dirName = path[path.length - 1].getValue()[1];
            File file = new File(dirName);
            return SvgViewer.getChoices(file);
        }
    }
}

