/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.ribbon.JRibbon;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JToggleTabButton;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.RibbonUI;

public class BasicRibbonUI
extends RibbonUI {
    public static final int TASKBAR_HEIGHT = 22;
    public static final int BAND_MIN_WIDTH = 30;
    protected JRibbon ribbon;
    protected MouseWheelListener mouseWheelListener;
    protected ComponentListener componentListener;
    protected HierarchyListener hierarchyListener;
    protected Component currHierarchyTopLevelAncestor;
    protected MouseListener currHierarchyTopLevelAncestorMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonUI();
    }

    public void installUI(JComponent c) {
        this.ribbon = (JRibbon)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbon = null;
    }

    protected void installListeners() {
        this.currHierarchyTopLevelAncestor = null;
        this.currHierarchyTopLevelAncestorMouseListener = null;
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (BasicRibbonUI.this.currHierarchyTopLevelAncestor != null) {
                    BasicRibbonUI.this.currHierarchyTopLevelAncestor.removeMouseListener(BasicRibbonUI.this.currHierarchyTopLevelAncestorMouseListener);
                }
                JComponent orig = (JComponent)e.getComponent();
                Container parent = orig.getTopLevelAncestor();
                BasicRibbonUI.this.currHierarchyTopLevelAncestor = parent;
                if (parent == null) {
                    return;
                }
                BasicRibbonUI.this.currHierarchyTopLevelAncestorMouseListener = new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        JPopupGallery.hidePopups(null);
                    }
                };
                parent.addMouseListener(BasicRibbonUI.this.currHierarchyTopLevelAncestorMouseListener);
            }
        };
        this.ribbon.addHierarchyListener(this.hierarchyListener);
        this.componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JPopupGallery.hidePopups(null);
            }

            public void componentHidden(ComponentEvent e) {
                JPopupGallery.hidePopups(null);
            }

            public void componentMoved(ComponentEvent e) {
                JPopupGallery.hidePopups(null);
            }
        };
        this.ribbon.addComponentListener(this.componentListener);
        this.mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                int delta = e.getWheelRotation();
                if (delta == 0) {
                    return;
                }
                int currSelectedTaskIndex = BasicRibbonUI.this.ribbon.getSelectedTaskIndex();
                int taskCount = BasicRibbonUI.this.ribbon.getTaskCount();
                int newSelectedTaskIndex = currSelectedTaskIndex + (delta > 0 ? 1 : -1);
                if (newSelectedTaskIndex < 0) {
                    newSelectedTaskIndex = taskCount - 1;
                }
                if (newSelectedTaskIndex >= taskCount) {
                    newSelectedTaskIndex = 0;
                }
                final int indexToSet = newSelectedTaskIndex;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(3));
                        BasicRibbonUI.this.ribbon.setSelectedTask(indexToSet);
                        BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
        };
        this.ribbon.addMouseWheelListener(this.mouseWheelListener);
    }

    protected void uninstallListeners() {
        if (this.currHierarchyTopLevelAncestor != null) {
            this.currHierarchyTopLevelAncestor.removeMouseListener(this.currHierarchyTopLevelAncestorMouseListener);
        }
        this.ribbon.removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        this.ribbon.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.ribbon.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.ribbon.setLayout(this.createLayoutManager());
    }

    protected void uninstallComponents() {
        this.ribbon.setLayout(null);
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    private class RibbonLayout
    implements LayoutManager {
        public static final int TOTAL_HEIGHT = 108;

        private RibbonLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(c.getWidth(), 108);
        }

        public Dimension minimumLayoutSize(Container c) {
            int width = 0;
            for (JRibbonBand ribbonBand : BasicRibbonUI.this.ribbon.getBands()) {
                BasicRibbonBandUI bandUI = (BasicRibbonBandUI)ribbonBand.getUI();
                width += bandUI.getPreferredWidth(JRibbonBand.RibbonBandCollapseKind.ICON);
                width += 4;
            }
            return new Dimension(width -= 4, 108);
        }

        public void layoutContainer(Container c) {
            int x = 2;
            for (Component regComp : BasicRibbonUI.this.ribbon.getRegularComponents()) {
                int pw = regComp.getPreferredSize().width;
                regComp.setBounds(x, 0, pw, 22);
                x += pw + 2;
            }
            int totalTaskButtonsWidth = 0;
            for (JToggleTabButton taskToggleButton : BasicRibbonUI.this.ribbon.getTaskToggleButtons()) {
                int pw = taskToggleButton.getPreferredSize().width;
                totalTaskButtonsWidth += pw + 10;
            }
            int helpTaskButtonWidth = 0;
            JToggleTabButton helpTaskButton = BasicRibbonUI.this.ribbon.getHelpTaskButton();
            if (helpTaskButton != null) {
                helpTaskButtonWidth = helpTaskButton.getPreferredSize().width;
            }
            totalTaskButtonsWidth -= helpTaskButtonWidth;
            switch (BasicRibbonUI.this.ribbon.getAlignment()) {
                case 2: {
                    break;
                }
                case 4: {
                    x = Math.max(x, c.getWidth() - totalTaskButtonsWidth - helpTaskButtonWidth);
                    break;
                }
                case 0: {
                    x += Math.max(x, (c.getWidth() - totalTaskButtonsWidth) / 2 - helpTaskButtonWidth);
                }
            }
            for (JToggleTabButton taskToggleButton : BasicRibbonUI.this.ribbon.getTaskToggleButtons()) {
                int pw = taskToggleButton.getPreferredSize().width;
                if (taskToggleButton != helpTaskButton) {
                    taskToggleButton.setBounds(x, 0, pw, 22);
                    x += pw + 10;
                    continue;
                }
                taskToggleButton.setBounds(c.getWidth() - helpTaskButtonWidth - 10, 0, pw, 22);
            }
            HashMap<JRibbonBand.RibbonBandCollapseKind, Integer> widths = new HashMap<JRibbonBand.RibbonBandCollapseKind, Integer>();
            for (JRibbonBand.RibbonBandCollapseKind collapseKind : JRibbonBand.RibbonBandCollapseKind.values()) {
                int totalWidth = 0;
                for (JRibbonBand panel : BasicRibbonUI.this.ribbon.getBands()) {
                    BasicRibbonBandUI ui = (BasicRibbonBandUI)panel.getUI();
                    totalWidth += ui.getPreferredWidth(collapseKind);
                    totalWidth += 2;
                }
                widths.put(collapseKind, totalWidth -= 2);
            }
            JRibbonBand.RibbonBandCollapseKind bestFitCollapse = JRibbonBand.RibbonBandCollapseKind.getSortedKinds().getLast();
            for (JRibbonBand.RibbonBandCollapseKind collapseKind : JRibbonBand.RibbonBandCollapseKind.getSortedKinds()) {
                if ((Integer)widths.get((Object)collapseKind) >= c.getWidth()) continue;
                bestFitCollapse = collapseKind;
                break;
            }
            int bestFitWidth = (Integer)widths.get((Object)bestFitCollapse);
            double coef = (double)c.getWidth() / (double)bestFitWidth;
            x = 0;
            for (JRibbonBand panel : BasicRibbonUI.this.ribbon.getBands()) {
                BasicRibbonBandUI ui = (BasicRibbonBandUI)panel.getUI();
                int pw = Math.max(30, ui.getPreferredWidth(bestFitCollapse));
                int fw = (int)(coef * (double)pw);
                panel.setBounds(x, 22, fw, 86);
                panel.doLayout();
                BasicRibbonBandUI ribbonBandUI = (BasicRibbonBandUI)panel.getUI();
                if (ribbonBandUI.getExpandButton() != null) {
                    int ebpw = ribbonBandUI.getExpandButton().getPreferredSize().width;
                    int ebph = ribbonBandUI.getExpandButton().getPreferredSize().height;
                    ribbonBandUI.getExpandButton().setBounds(fw - 4 - ebpw, (18 - ebph) / 2, ebpw, ebph);
                }
                x += fw + 2;
            }
        }
    }
}

