/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.AsynchronousLoadListener;
import org.jvnet.flamingo.common.AsynchronousLoading;
import org.jvnet.flamingo.common.ResizableIcon;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.JRibbonLabel;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.RibbonButtonUI;

public class BasicRibbonButtonUI
extends RibbonButtonUI {
    protected JRibbonButton ribbonButton;
    protected boolean isUnderMouse;
    protected MouseListener rolloverListener;
    protected FocusListener focusListener;
    protected String titlePart1;
    protected String titlePart2;
    protected JLabel bigLabel1;
    protected JLabel bigLabel2;
    protected JLabel midLabel;
    protected JLabel iconLabel;
    protected JLabel actionLabel;
    protected boolean toTakeSavedDimension = false;
    protected Dimension savedDimension;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonButtonUI();
    }

    public void installUI(JComponent c) {
        this.ribbonButton = (JRibbonButton)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.ribbonButton.setLayout(this.createLayoutManager());
        if (this.ribbonButton.getState() != null) {
            this.updateState(this.ribbonButton.getState(), false);
        }
        this.updateCustomDimension();
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbonButton = null;
    }

    protected void installDefaults() {
        this.ribbonButton.setRolloverEnabled(true);
    }

    protected void installComponents() {
        this.ribbonButton.setBorder(new EmptyBorder(4, 4, 4, 4));
        BufferedImage tempImage = new BufferedImage(30, 30, 2);
        Graphics2D g = (Graphics2D)tempImage.getGraphics();
        g.setFont(UIManager.getFont("JRibbon.font"));
        FontMetrics fm = g.getFontMetrics();
        String title = this.ribbonButton.getTitle();
        if (title != null) {
            int spaceIndex = title.indexOf(32);
            if (spaceIndex < 0) {
                this.titlePart1 = title;
                this.titlePart2 = "";
            } else {
                int actionLabelWidth;
                int currMaxLength = (int)fm.getStringBounds(this.ribbonButton.getTitle(), g).getWidth();
                int n = actionLabelWidth = this.actionLabel == null ? 0 : 4 + this.actionLabel.getIcon().getIconWidth();
                while (spaceIndex >= 0) {
                    int len2;
                    String part1 = title.substring(0, spaceIndex);
                    String part2 = title.substring(spaceIndex + 1, title.length());
                    int len1 = (int)fm.getStringBounds(part1, g).getWidth();
                    int len = Math.max(len1, len2 = (int)fm.getStringBounds(part2, g).getWidth() + actionLabelWidth);
                    if (currMaxLength > len) {
                        currMaxLength = len;
                        this.titlePart1 = part1;
                        this.titlePart2 = part2;
                    }
                    spaceIndex = title.indexOf(32, spaceIndex + 1);
                }
            }
        } else {
            this.titlePart1 = "";
            this.titlePart2 = "";
        }
        this.midLabel = new JRibbonLabel();
        this.bigLabel1 = new JRibbonLabel();
        this.bigLabel2 = new JRibbonLabel();
        this.ribbonButton.add(this.midLabel);
        this.ribbonButton.add(this.bigLabel1);
        this.ribbonButton.add(this.bigLabel2);
        ResizableIcon buttonIcon = this.ribbonButton.getIcon();
        this.iconLabel = new JLabel(this.ribbonButton.getIcon());
        if (buttonIcon instanceof AsynchronousLoading) {
            ((AsynchronousLoading)((Object)buttonIcon)).addAsynchronousLoadListener(new AsynchronousLoadListener(){

                public void completed(boolean success) {
                    if (success) {
                        BasicRibbonButtonUI.this.ribbonButton.repaint();
                    }
                }
            });
        }
        this.ribbonButton.add(this.iconLabel);
        if (this.ribbonButton.getGallery() != null) {
            this.actionLabel = new JLabel(UIManager.getIcon("GalleryButton.expandIcon"));
            this.ribbonButton.add(this.actionLabel);
        }
    }

    protected void installListeners() {
        this.rolloverListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                BasicRibbonButtonUI.this.isUnderMouse = true;
                BasicRibbonButtonUI.this.ribbonButton.repaint();
            }

            public void mouseExited(MouseEvent e) {
                BasicRibbonButtonUI.this.isUnderMouse = false;
                BasicRibbonButtonUI.this.ribbonButton.repaint();
            }
        };
        this.ribbonButton.addMouseListener(this.rolloverListener);
        this.focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BasicRibbonButtonUI.this.ribbonButton.repaint();
            }

            public void focusLost(FocusEvent e) {
                BasicRibbonButtonUI.this.ribbonButton.repaint();
            }
        };
        this.ribbonButton.addFocusListener(this.focusListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        this.ribbonButton.remove(this.midLabel);
        this.ribbonButton.remove(this.bigLabel1);
        this.ribbonButton.remove(this.bigLabel2);
        this.ribbonButton.remove(this.iconLabel);
        if (this.actionLabel != null) {
            this.ribbonButton.remove(this.actionLabel);
        }
    }

    protected void uninstallListeners() {
        this.ribbonButton.removeMouseListener(this.rolloverListener);
        this.ribbonButton.removeFocusListener(this.focusListener);
        this.rolloverListener = null;
        this.focusListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonButtonLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintButtonBackground(graphics, new Rectangle(0, 1, c.getWidth(), c.getHeight() - 2));
        graphics.dispose();
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        boolean toMark = this.ribbonButton.isSelected() || this.isUnderMouse && this.ribbonButton.isEnabled();
        Color backColor = toMark ? this.ribbonButton.getBackground().darker() : this.ribbonButton.getBackground();
        graphics.setColor(backColor);
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    public void updateState(GalleryElementState state, boolean toUpdateIcon) {
        if (state != GalleryElementState.CUSTOM) {
            this.midLabel.setVisible(false);
            this.bigLabel1.setVisible(false);
            this.bigLabel2.setVisible(false);
        }
        int maxHeight = 0;
        switch (state) {
            case SMALL: {
                maxHeight = 16;
                break;
            }
            case MEDIUM: {
                this.midLabel.setText(this.ribbonButton.getTitle());
                this.midLabel.setVisible(true);
                maxHeight = 16;
                break;
            }
            case BIG: {
                this.bigLabel1.setText(this.titlePart1);
                this.bigLabel1.setVisible(true);
                this.bigLabel2.setText(this.titlePart2);
                this.bigLabel2.setVisible(true);
                maxHeight = 32;
                break;
            }
            case ORIG: {
                this.bigLabel1.setText(this.titlePart1);
                this.bigLabel1.setVisible(true);
                this.bigLabel2.setText(this.titlePart2);
                this.bigLabel2.setVisible(true);
                maxHeight = this.ribbonButton.getIcon().getIconHeight();
            }
        }
        this.toTakeSavedDimension = !toUpdateIcon && state != GalleryElementState.CUSTOM;
        this.savedDimension = new Dimension(maxHeight, maxHeight);
        if (toUpdateIcon && state != GalleryElementState.CUSTOM) {
            this.ribbonButton.getIcon().setHeight(maxHeight);
        }
    }

    public void updateCustomDimension() {
        int dimension = this.ribbonButton.getCustomDimension();
        if (dimension > 0) {
            this.midLabel.setVisible(false);
            this.bigLabel1.setVisible(true);
            this.bigLabel2.setVisible(true);
            this.bigLabel1.setText(this.titlePart1);
            this.bigLabel2.setText(this.titlePart2);
            this.ribbonButton.getIcon().setDimension(new Dimension(dimension, dimension));
            this.ribbonButton.setState(GalleryElementState.CUSTOM, true);
        }
    }

    public void updateGallery(JPopupGallery gallery) {
        if (gallery != null && this.ribbonButton.getGallery() == null) {
            this.actionLabel = new JLabel(UIManager.getIcon("GalleryButton.expandIcon"));
            this.ribbonButton.add(this.actionLabel);
        }
        if (gallery == null && this.ribbonButton.getGallery() != null) {
            this.ribbonButton.remove(this.actionLabel);
            this.actionLabel = null;
        }
    }

    public void setExpandIcon(Icon icon) {
        if (this.actionLabel != null) {
            this.actionLabel.setIcon(icon);
        }
    }

    private class RibbonButtonLayout
    implements LayoutManager {
        private FontMetrics fm;
        private Graphics2D graphics = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();

        public RibbonButtonLayout() {
            this.graphics.setFont(UIManager.getFont("JRibbon.font"));
            this.fm = this.graphics.getFontMetrics();
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            Insets borderInsets = BasicRibbonButtonUI.this.ribbonButton.getBorder().getBorderInsets(BasicRibbonButtonUI.this.ribbonButton);
            int bx = borderInsets.left + borderInsets.right;
            int by = borderInsets.top + borderInsets.bottom;
            Dimension iconDim = BasicRibbonButtonUI.this.toTakeSavedDimension ? BasicRibbonButtonUI.this.savedDimension : new Dimension(BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth(), BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight());
            switch (BasicRibbonButtonUI.this.ribbonButton.getState()) {
                case SMALL: {
                    return new Dimension(bx + BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth() + 4 + (BasicRibbonButtonUI.this.actionLabel != null ? BasicRibbonButtonUI.this.actionLabel.getPreferredSize().width : 0), by + iconDim.height);
                }
                case MEDIUM: {
                    return new Dimension(bx + iconDim.width + 4 + (int)this.fm.getStringBounds(BasicRibbonButtonUI.this.ribbonButton.getTitle(), this.graphics).getWidth() + 4 + (BasicRibbonButtonUI.this.actionLabel != null ? BasicRibbonButtonUI.this.actionLabel.getPreferredSize().width : 0), by + iconDim.height);
                }
                case CUSTOM: 
                case BIG: 
                case ORIG: {
                    Rectangle2D rect1 = this.fm.getStringBounds(BasicRibbonButtonUI.this.titlePart1, this.graphics);
                    Rectangle2D rect2 = this.fm.getStringBounds(BasicRibbonButtonUI.this.titlePart2, this.graphics);
                    int width = Math.max(iconDim.width, (int)Math.max(rect1.getWidth(), rect2.getWidth() + 4.0 + (double)(BasicRibbonButtonUI.this.actionLabel != null ? BasicRibbonButtonUI.this.actionLabel.getPreferredSize().width : 0)));
                    return new Dimension(bx + width, by + iconDim.height + 4 + 2 * this.fm.getHeight());
                }
            }
            return null;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            Icon actionIcon = BasicRibbonButtonUI.this.actionLabel != null ? BasicRibbonButtonUI.this.actionLabel.getIcon() : null;
            int x = BasicRibbonButtonUI.this.ribbonButton.getBorder().getBorderInsets((Component)BasicRibbonButtonUI.this.ribbonButton).left;
            int y = 3 + BasicRibbonButtonUI.this.ribbonButton.getBorder().getBorderInsets((Component)BasicRibbonButtonUI.this.ribbonButton).top;
            switch (BasicRibbonButtonUI.this.ribbonButton.getState()) {
                case CUSTOM: 
                case BIG: 
                case ORIG: {
                    if (BasicRibbonButtonUI.this.ribbonButton.getState() == GalleryElementState.BIG) {
                        BasicRibbonButtonUI.this.ribbonButton.getIcon().setHeight(32);
                    } else if (BasicRibbonButtonUI.this.ribbonButton.getState() == GalleryElementState.ORIG) {
                        BasicRibbonButtonUI.this.ribbonButton.getIcon().revertToOriginalDimension();
                    }
                    BasicRibbonButtonUI.this.iconLabel.setBounds((width - BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth()) / 2, y, BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth(), BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight());
                    int labelWidth = BasicRibbonButtonUI.this.bigLabel1.getPreferredSize().width;
                    int labelHeight = BasicRibbonButtonUI.this.bigLabel1.getPreferredSize().height;
                    BasicRibbonButtonUI.this.bigLabel1.setBounds((width - labelWidth) / 2, y += BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight(), labelWidth, labelHeight);
                    labelWidth = BasicRibbonButtonUI.this.bigLabel2.getPreferredSize().width + (BasicRibbonButtonUI.this.actionLabel != null ? 4 + BasicRibbonButtonUI.this.actionLabel.getPreferredSize().width : 4);
                    x = (width - labelWidth) / 2;
                    BasicRibbonButtonUI.this.bigLabel2.setBounds(x, y += labelHeight, BasicRibbonButtonUI.this.bigLabel2.getPreferredSize().width, labelHeight);
                    if (BasicRibbonButtonUI.this.actionLabel == null) break;
                    x += 4;
                    BasicRibbonButtonUI.this.actionLabel.setBounds(x += BasicRibbonButtonUI.this.bigLabel2.getPreferredSize().width, y + (labelHeight - actionIcon.getIconHeight()) / 2, actionIcon.getIconWidth(), actionIcon.getIconHeight());
                    break;
                }
                case MEDIUM: {
                    BasicRibbonButtonUI.this.ribbonButton.getIcon().setHeight(16);
                    BasicRibbonButtonUI.this.iconLabel.setBounds(x, (height - BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight()) / 2, BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth(), BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight());
                    x += 4;
                    BasicRibbonButtonUI.this.midLabel.setBounds(x += BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth(), (height - BasicRibbonButtonUI.this.midLabel.getPreferredSize().height) / 2, BasicRibbonButtonUI.this.midLabel.getPreferredSize().width, BasicRibbonButtonUI.this.midLabel.getPreferredSize().height);
                    x += 4;
                    x += BasicRibbonButtonUI.this.midLabel.getPreferredSize().width;
                    if (BasicRibbonButtonUI.this.actionLabel == null) break;
                    BasicRibbonButtonUI.this.actionLabel.setBounds(x, (height - actionIcon.getIconHeight()) / 2, actionIcon.getIconWidth(), actionIcon.getIconHeight());
                    break;
                }
                case SMALL: {
                    BasicRibbonButtonUI.this.ribbonButton.getIcon().setHeight(16);
                    BasicRibbonButtonUI.this.iconLabel.setBounds(x, (height - BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight()) / 2, BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth(), BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconHeight());
                    x += 4;
                    x += BasicRibbonButtonUI.this.ribbonButton.getIcon().getIconWidth();
                    if (BasicRibbonButtonUI.this.actionLabel == null) break;
                    BasicRibbonButtonUI.this.actionLabel.setBounds(x, (height - actionIcon.getIconHeight()) / 2, actionIcon.getIconWidth(), actionIcon.getIconHeight());
                }
            }
            BasicRibbonButtonUI.this.ribbonButton.putClientProperty("icon.bounds", BasicRibbonButtonUI.this.iconLabel.getBounds());
        }
    }
}

