/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.gallery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.UIManager;
import org.jvnet.flamingo.ribbon.ui.BasicPopupGalleryUI;
import org.jvnet.flamingo.ribbon.ui.PopupGalleryUI;

public class JPopupGallery
extends JPanel {
    private static final String uiClassID = "PopupGalleryUI";
    protected Component component;
    protected static Map<JPopupGallery, Popup> popupGalleries = new HashMap<JPopupGallery, Popup>();
    protected static LinkedList<JPopupGallery> currShown = new LinkedList();

    public JPopupGallery() {
    }

    public JPopupGallery(Component component, Dimension originalSize) {
        this();
        this.component = component;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.setPreferredSize(originalSize);
        this.setSize(originalSize);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((PopupGalleryUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicPopupGalleryUI());
        }
    }

    public PopupGalleryUI getUI() {
        return (PopupGalleryUI)this.ui;
    }

    public void setUI(PopupGalleryUI ui) {
        super.setUI(ui);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Component removeComponent() {
        this.remove(this.component);
        return this.component;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isEmpty() {
        return this.component == null;
    }

    public static void hidePopups(Component comp) {
        if (comp != null) {
            for (Component c = comp; c != null; c = c.getParent()) {
                if (!(c instanceof JPopupGallery)) continue;
                while (currShown.size() > 0) {
                    if (currShown.getLast() == c) {
                        return;
                    }
                    JPopupGallery jpg = currShown.removeLast();
                    Popup popup = popupGalleries.get(jpg);
                    popup.hide();
                    popupGalleries.remove(jpg);
                }
            }
        }
        for (Popup popup : popupGalleries.values()) {
            popup.hide();
        }
        popupGalleries.clear();
    }

    public static void addPopup(Popup popup, JPopupGallery popupInitiator) {
        popupGalleries.put(popupInitiator, popup);
        currShown.addLast(popupInitiator);
    }
}

