/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.ResizableIcon;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonButtonUI;
import org.jvnet.flamingo.ribbon.ui.RibbonButtonUI;

public class JRibbonButton
extends AbstractButton {
    protected ResizableIcon icon;
    protected ResizableIcon disabledIcon;
    protected String title;
    protected JPopupGallery gallery;
    protected ActionListener actionListener;
    protected GalleryElementState state;
    protected int customDimension;
    private static final String uiClassID = "RibbonButtonUI";

    public JRibbonButton(JPopupGallery gallery, String title, ResizableIcon icon, ResizableIcon disabledIcon) {
        this.gallery = gallery;
        this.title = title;
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.setModel(new DefaultButtonModel());
        this.customDimension = -1;
        this.updateUI();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                final JRibbonButton jgb = JRibbonButton.this;
                if (!jgb.isEnabled()) {
                    return;
                }
                JPopupGallery.hidePopups(jgb);
                if (jgb.actionListener != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jgb.actionListener.actionPerformed(new ActionEvent(jgb, 1001, "pressed"));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int ph;
                        PopupFactory popupFactory = PopupFactory.getSharedInstance();
                        if (jgb == null || jgb.gallery == null || jgb.gallery.isEmpty()) {
                            return;
                        }
                        int x = jgb.getLocationOnScreen().x;
                        int y = jgb.getLocationOnScreen().y + jgb.getSize().height;
                        Rectangle scrBounds = jgb.getGraphicsConfiguration().getBounds();
                        int pw = jgb.gallery.getPreferredSize().width;
                        if (x + pw > scrBounds.x + scrBounds.width) {
                            x = scrBounds.x + scrBounds.width - pw;
                        }
                        if (y + (ph = jgb.gallery.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                            y = scrBounds.y + scrBounds.height - ph;
                        }
                        Popup popup = popupFactory.getPopup(jgb, jgb.gallery, x, y);
                        popup.show();
                        JPopupGallery.addPopup(popup, jgb.gallery);
                    }
                });
            }
        });
    }

    public void setUI(RibbonButtonUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonButtonUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonButtonUI());
        }
    }

    public RibbonButtonUI getUI() {
        return (RibbonButtonUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setState(GalleryElementState state, boolean toUpdateIcon) {
        this.state = state;
        this.getUI().updateState(state, toUpdateIcon);
    }

    public JPopupGallery getGallery() {
        return this.gallery;
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public ResizableIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public GalleryElementState getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public void setGallery(JPopupGallery gallery) {
        this.getUI().updateGallery(gallery);
        this.gallery = gallery;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(isEnabled);
        }
        this.model.setEnabled(isEnabled);
    }

    public boolean isToggle() {
        return this.getModel() instanceof JToggleButton.ToggleButtonModel;
    }

    public void setToggle(boolean isToggle) {
        if (isToggle) {
            this.setModel(new JToggleButton.ToggleButtonModel());
        } else {
            this.setModel(new DefaultButtonModel());
        }
        this.repaint();
    }

    public void updateCustomDimension(int dimension) {
        this.customDimension = dimension;
        this.getUI().updateCustomDimension();
    }

    public int getCustomDimension() {
        return this.customDimension;
    }
}

