/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.ResizableIcon;
import org.jvnet.flamingo.ribbon.JBandControlPanel;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.JRibbonGallery;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.RibbonBandUI;

public class JRibbonBand
extends JComponent {
    private String title;
    private ActionListener expandActionListener;
    private JBandControlPanel controlPanel;
    private static final String uiClassID = "RibbonBandUI";
    private ResizableIcon icon;

    public JRibbonBand(String title, ResizableIcon icon) {
        this(title, icon, null);
    }

    public JRibbonBand(String title, ResizableIcon icon, ActionListener expandActionListener) {
        this.title = title;
        this.icon = icon;
        this.expandActionListener = expandActionListener;
        this.controlPanel = new JBandControlPanel(this);
        this.add(this.controlPanel);
        this.updateUI();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public void setUI(RibbonBandUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonBandUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonBandUI());
        }
    }

    public RibbonBandUI getUI() {
        return (RibbonBandUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addGalleryButton(JRibbonButton ribbonButton, RibbonElementPriority priority) {
        this.controlPanel.addGalleryButton(ribbonButton, priority);
    }

    public void addRibbonGallery(JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
        this.controlPanel.addRibbonGallery(ribbonGallery, priority);
    }

    public void addPanel(JPanel panel) {
        this.controlPanel.addPanel(panel);
    }

    public ActionListener getExpandActionListener() {
        return this.expandActionListener;
    }

    public JBandControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void setControlPanel(JBandControlPanel controlPanel) {
        if (controlPanel == null) {
            this.remove(this.controlPanel);
        } else {
            this.add(controlPanel);
        }
        this.controlPanel = controlPanel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RibbonBandCollapseKind {
        NONE(0),
        LOW_TO_MID(1),
        MID_TO_MID(2),
        LOW_TO_LOW(3),
        MID_TO_LOW(4),
        HIGH_TO_MID(5),
        HIGH_TO_LOW(6),
        ICON(7);

        private int priority;

        private RibbonBandCollapseKind(int priority) {
            this.priority = priority;
        }

        public static LinkedList<RibbonBandCollapseKind> getSortedKinds() {
            LinkedList<RibbonBandCollapseKind> result = new LinkedList<RibbonBandCollapseKind>();
            for (RibbonBandCollapseKind kind : RibbonBandCollapseKind.values()) {
                result.add(kind);
            }
            Collections.sort(result, new Comparator<RibbonBandCollapseKind>(){

                @Override
                public int compare(RibbonBandCollapseKind o1, RibbonBandCollapseKind o2) {
                    return o1.priority - o2.priority;
                }
            });
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RibbonElementPriority {
        TOP,
        MEDIUM,
        LOW;

    }
}

