/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.JRibbonGallery;
import org.jvnet.flamingo.ribbon.ui.BandControlPanelUI;
import org.jvnet.flamingo.ribbon.ui.BasicBandControlPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBandControlPanel
extends JPanel
implements UIResource {
    private boolean hasGalleries = false;
    private int galleryCount = 0;
    private Map<JRibbonBand.RibbonElementPriority, List<JRibbonGallery>> ribbonGalleries;
    private Map<JRibbonGallery, JRibbonBand.RibbonElementPriority> ribbonGalleriesPriorities;
    private Map<JRibbonBand.RibbonElementPriority, List<JRibbonButton>> ribbonButtons = new HashMap<JRibbonBand.RibbonElementPriority, List<JRibbonButton>>();
    private Map<JRibbonButton, JRibbonBand.RibbonElementPriority> ribbonButtonsPriorities = new HashMap<JRibbonButton, JRibbonBand.RibbonElementPriority>();
    private List<JPanel> panels;
    public static final List<JRibbonButton> EMPTY_GALLERY_BUTTONS_LIST = new LinkedList<JRibbonButton>();
    public static final List<JRibbonGallery> EMPTY_RIBBON_GALLERIES_LIST = new LinkedList<JRibbonGallery>();
    private static final String uiClassID = "BandControlPanelUI";

    public JBandControlPanel(JRibbonBand ribbonBand) {
        this.ribbonGalleries = new HashMap<JRibbonBand.RibbonElementPriority, List<JRibbonGallery>>();
        this.ribbonGalleriesPriorities = new HashMap<JRibbonGallery, JRibbonBand.RibbonElementPriority>();
        this.panels = new LinkedList<JPanel>();
    }

    public void setUI(BandControlPanelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BandControlPanelUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBandControlPanelUI());
        }
    }

    @Override
    public BandControlPanelUI getUI() {
        return (BandControlPanelUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public String toString() {
        return "@" + this.hashCode() + ": " + this.panels.size() + " panels, " + this.galleryCount + " galleries, " + this.ribbonButtons.size() + " buttons";
    }

    @Override
    public Component add(Component comp, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component add(Component comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component add(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Component comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public synchronized void addGalleryButton(JRibbonButton ribbonButton, JRibbonBand.RibbonElementPriority priority) {
        if (!this.ribbonButtons.containsKey((Object)priority)) {
            this.ribbonButtons.put(priority, new LinkedList());
        }
        List<JRibbonButton> al = this.ribbonButtons.get((Object)priority);
        al.add(ribbonButton);
        this.ribbonButtonsPriorities.put(ribbonButton, priority);
        ribbonButton.setState(GalleryElementState.BIG, true);
        super.add(ribbonButton);
    }

    public synchronized void addRibbonGallery(JRibbonGallery ribbonGallery, JRibbonBand.RibbonElementPriority priority) {
        if (!this.ribbonGalleries.containsKey((Object)priority)) {
            this.ribbonGalleries.put(priority, new LinkedList());
        }
        List<JRibbonGallery> al = this.ribbonGalleries.get((Object)priority);
        al.add(ribbonGallery);
        this.ribbonGalleriesPriorities.put(ribbonGallery, priority);
        ribbonGallery.setState(GalleryElementState.BIG);
        this.hasGalleries = true;
        ++this.galleryCount;
        super.add(ribbonGallery);
    }

    public synchronized void setPriority(JRibbonButton ribbonButton, JRibbonBand.RibbonElementPriority newPriority) {
        JRibbonBand.RibbonElementPriority oldPriority = this.ribbonButtonsPriorities.get(ribbonButton);
        if (newPriority == oldPriority) {
            return;
        }
        this.ribbonButtons.get((Object)oldPriority).remove(ribbonButton);
        if (!this.ribbonButtons.containsKey((Object)newPriority)) {
            this.ribbonButtons.put(newPriority, new ArrayList());
        }
        this.ribbonButtons.get((Object)newPriority).add(ribbonButton);
    }

    public synchronized void setPriority(JRibbonGallery ribbonGallery, JRibbonBand.RibbonElementPriority newPriority) {
        JRibbonBand.RibbonElementPriority oldPriority = this.ribbonGalleriesPriorities.get(ribbonGallery);
        if (newPriority == oldPriority) {
            return;
        }
        this.ribbonGalleries.get((Object)oldPriority).remove(ribbonGallery);
        if (!this.ribbonGalleries.containsKey((Object)newPriority)) {
            this.ribbonGalleries.put(newPriority, new ArrayList());
        }
        this.ribbonGalleries.get((Object)newPriority).add(ribbonGallery);
    }

    public void addPanel(JPanel panel) {
        this.panels.add(panel);
        super.add(panel);
    }

    public List<JRibbonButton> getRibbonButtons(JRibbonBand.RibbonElementPriority priority) {
        List<JRibbonButton> result = this.ribbonButtons.get((Object)priority);
        if (result == null) {
            return EMPTY_GALLERY_BUTTONS_LIST;
        }
        return result;
    }

    public List<JRibbonGallery> getRibbonGalleries(JRibbonBand.RibbonElementPriority priority) {
        List<JRibbonGallery> result = this.ribbonGalleries.get((Object)priority);
        if (result == null) {
            return EMPTY_RIBBON_GALLERIES_LIST;
        }
        return result;
    }

    public boolean hasRibbonGalleries() {
        return this.hasGalleries;
    }

    public int getRibbonGalleriesCount() {
        return this.galleryCount;
    }

    public List<JPanel> getPanels() {
        return this.panels;
    }
}

