/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.util;

import java.util.List;
import java.util.StringTokenizer;
import org.jvnet.flamingo.ide.info.FileInfo;

public class Util {
    public static final int MAX_TOOLTIP_LINE_WIDTH = 80;

    public static String toXML(String str) {
        StringBuffer result = new StringBuffer();
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String getTooltipText(FileInfo.LineInfo lineInfo) {
        boolean hasMultipleMessages;
        int lineNumber = lineInfo.getLineNumber() + 1;
        List<FileInfo.MessageInfo> messages = lineInfo.getMessages();
        StringBuffer result = new StringBuffer();
        result.append("<html><body>");
        boolean bl = hasMultipleMessages = messages.size() > 1;
        if (hasMultipleMessages) {
            result.append("<b>Multiple messages at line " + lineNumber + ":</b>");
        }
        int count = 1;
        for (FileInfo.MessageInfo message : messages) {
            String text = Util.toXML(message.getText());
            if (hasMultipleMessages) {
                text = "<br><b>" + count + "</b>: " + text;
            }
            String currLine = "";
            StringTokenizer tokenizer = new StringTokenizer(text, " ", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String nextLine = currLine + token;
                if (nextLine.length() > 80) {
                    if (currLine.length() == 0) {
                        result.append(nextLine + "<br>");
                        currLine = "";
                        continue;
                    }
                    result.append(currLine + "<br>");
                    currLine = token;
                    continue;
                }
                currLine = nextLine;
            }
            if (currLine.length() > 0) {
                result.append(currLine);
            }
            ++count;
        }
        result.append("</font></body></html>");
        return result.toString();
    }

    private static int getNormalizedLength(String htmlText) {
        int startIndex;
        int result = 0;
        if (Character.isWhitespace(htmlText.charAt(0))) {
            ++result;
        }
        if (Character.isWhitespace(htmlText.charAt(htmlText.length() - 1))) {
            ++result;
        }
        String trimmedText = htmlText.trim();
        int currPos = 0;
        while ((startIndex = trimmedText.indexOf(60, currPos)) >= 0) {
            result += startIndex - currPos;
            int endIndex = trimmedText.indexOf(62, startIndex);
            if (endIndex < 0) {
                throw new IllegalStateException("No closing > character for opening < in position " + startIndex + " in '" + trimmedText + "'");
            }
            currPos = endIndex + 1;
        }
        return result += trimmedText.length() - currPos;
    }

    public static String getTooltipText(String htmlText) {
        StringBuffer result = new StringBuffer();
        result.append("<html><body>");
        String currLine = "";
        int currLength = 0;
        StringTokenizer tokenizer = new StringTokenizer(htmlText, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int tokenLength = Util.getNormalizedLength(token);
            String nextLine = currLine + token;
            if ((currLength += tokenLength) > 80) {
                if (currLine.length() == 0) {
                    result.append(nextLine + "<br>");
                    currLine = "";
                    currLength = 0;
                    continue;
                }
                result.append(currLine + "<br>");
                currLength = tokenLength;
                currLine = token;
                continue;
            }
            currLine = nextLine;
        }
        if (currLine.length() > 0) {
            result.append(currLine);
        }
        result.append("</font></body></html>");
        return result.toString();
    }
}

