/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.gutter;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.jvnet.flamingo.ide.BaseViewerPanel;
import org.jvnet.flamingo.ide.StringListPanel;
import org.jvnet.flamingo.ide.gutter.GutterPanel;
import org.jvnet.flamingo.ide.info.FileInfo;

public final class AbsoluteGutterPanel
extends GutterPanel {
    public AbsoluteGutterPanel(BaseViewerPanel viewerPanel) {
        super(viewerPanel);
    }

    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        StringListPanel textPanel = this.viewerPanel.getTextPanel();
        Font font = textPanel.getPositioningInfo().getPlainFont();
        g.setFont(font);
        g.setColor(this.getBackground().darker().darker());
        int lineCount = textPanel.getLineCount();
        int lineCountDigits = new String("" + lineCount).length();
        if (textPanel.getGlobalSettings().isToShowLineNumbers()) {
            int topLine = (int)Math.floor(textPanel.getTopLine());
            int bottomLine = (int)Math.ceil(textPanel.getTopLine() + textPanel.getVisibleLinesCount());
            if (bottomLine > textPanel.getLineCount() - 1) {
                bottomLine = textPanel.getLineCount() - 1;
            }
            for (int line = topLine; line <= bottomLine; ++line) {
                double absolutePosition = textPanel.getAbsoluteVerticalPosition(line);
                String lineStr = "" + (1 + line);
                int lineDigits = lineStr.length();
                for (int i = 0; i < lineDigits; ++i) {
                    int offsetX = textPanel.getPositioningInfo().getSingleCharacterWidth() * (lineCountDigits - lineDigits + i);
                    g.drawString("" + lineStr.charAt(i), offsetX, (int)absolutePosition + textPanel.getPositioningInfo().getFontAscent());
                }
            }
        }
        int markerOffsetX = textPanel.getGlobalSettings().isToShowLineNumbers() ? textPanel.getPositioningInfo().getSingleCharacterWidth() * lineCountDigits : 0;
        this.marks.clear();
        Collection<FileInfo.LineInfo> messageList = this.viewerPanel.getMessageList();
        if (messageList != null) {
            for (FileInfo.LineInfo line : messageList) {
                double absolutePosition = textPanel.getAbsoluteVerticalPosition(line.getLineNumber());
                FileInfo.MessageKind highestSeverityKind = line.getHighestSeverity();
                BufferedImage marker = highestSeverityKind.getAbsoluteMarker(11);
                int topPixel = 1 + (int)(absolutePosition + (double)(this.viewerPanel.getTextPanel().getSingleLineHeightInPixels() - marker.getHeight()) / 2.0);
                g.drawImage(marker, markerOffsetX, topPixel, null);
                Rectangle markerRect = new Rectangle(markerOffsetX, topPixel, marker.getWidth(), marker.getHeight());
                this.marks.put(line, markerRect);
            }
        }
    }

    public final void refreshView() {
        this.paintAll(this.getGraphics());
    }
}

