/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.xml.stream.Location;
import org.jvnet.flamingo.ide.ColorDispatcher;
import org.jvnet.flamingo.ide.info.ElementLocationInfo;
import org.jvnet.flamingo.ide.info.ElementRange;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.info.FileLocationInfo;
import org.jvnet.flamingo.ide.info.GlobalSettings;
import org.jvnet.flamingo.ide.info.PositioningInfo;
import org.jvnet.flamingo.ide.java.jparser.JavaFileLocationInfo;
import org.jvnet.flamingo.ide.link.LinkCallback;
import org.jvnet.flamingo.ide.link.LinkEvent;
import org.jvnet.flamingo.ide.link.LinkInfo;
import org.jvnet.flamingo.ide.link.LinkListener;
import org.jvnet.flamingo.ide.util.IdeImageCreator;
import org.jvnet.flamingo.ide.util.Util;
import org.jvnet.flamingo.ide.xml.XmlLocationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringListPanel
extends JComponent {
    private String[] lines;
    private BufferedImage offscreenImage;
    private Map<Integer, FileInfo.MessageKind> messageLines;
    private double topLineIndex;
    private double bottomLineIndex;
    private double firstColumnIndex;
    private double lastColumnIndex;
    private int maxColumnCount;
    private boolean toShowColors;
    private ColorDispatcher colorDispatcher;
    private boolean toShowLocations;
    private GlobalSettings globalSettings;
    private Set<LinkListener> linkListeners;
    private LinkCallback linkCallback;
    private Map<Location, Integer> elementLocations;
    public static final Color ERROR_BACKGROUND = new Color(255, 224, 224);
    public static final Color WARNING_BACKGROUND = new Color(255, 255, 200);
    public static final Color INFO_BACKGROUND = new Color(220, 240, 255);
    public static final Color PASSIVE_LINK_BORDER = new Color(128, 128, 255);
    public static final Color ACTIVE_LINK_BORDER = new Color(64, 64, 255);
    public static final int DEFAULT_FONT_SIZE = 13;
    public static final int MIN_FONT_SIZE = 8;
    private FileStatus currFileStatus;
    private FileStatus prevFileStatus;
    private Set<ActiveArea> activeAreas;

    public StringListPanel(Map<Integer, FileInfo.MessageKind> messageLines, GlobalSettings globalSettings) {
        this.messageLines = messageLines;
        this.globalSettings = globalSettings;
        this.toShowColors = false;
        this.activeAreas = new HashSet<ActiveArea>();
        ActiveAreaMouseListener mouseAdapter = new ActiveAreaMouseListener(this);
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.linkListeners = new HashSet<LinkListener>();
    }

    @Override
    protected final void paintComponent(Graphics g) {
        FileLocationInfo fileLocInfo;
        if (this.lines == null) {
            return;
        }
        if (this.offscreenImage == null) {
            this.offscreenImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        Graphics2D offscreenGraphics = (Graphics2D)this.offscreenImage.getGraphics();
        offscreenGraphics.setColor(Color.white);
        offscreenGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        offscreenGraphics.setColor(Color.black);
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        int ascent = positioningInfo.getFontAscent();
        int descent = positioningInfo.getFontDescent();
        int firstLine = (int)Math.floor(this.topLineIndex);
        firstLine = Math.max(0, firstLine);
        int lastLine = (int)Math.ceil(this.bottomLineIndex);
        lastLine = Math.min(lastLine, this.lines.length - 1);
        for (int currLine = firstLine; currLine <= lastLine; ++currLine) {
            int y = (int)(((double)currLine - this.topLineIndex + 1.0) * (double)positioningInfo.getSingleCharacterHeight()) - positioningInfo.getFontDescent();
            int firstColumn = (int)Math.floor(this.firstColumnIndex);
            firstColumn = Math.max(0, firstColumn);
            boolean isLineTextVisible = this.lines[currLine].length() >= firstColumn;
            int lastColumn = (int)Math.ceil(this.lastColumnIndex);
            lastColumn = Math.min(lastColumn, this.lines[currLine].length() - 1);
            String toShow = null;
            int x = 0;
            if (isLineTextVisible) {
                toShow = this.lines[currLine].substring(firstColumn, lastColumn + 1);
                x = (int)(((double)firstColumn - this.firstColumnIndex) * (double)positioningInfo.getSingleCharacterWidth());
            }
            FileInfo.MessageKind lineSeverity = FileInfo.MessageKind.SUCCESS;
            if (this.messageLines != null && this.messageLines.containsKey(currLine)) {
                lineSeverity = this.messageLines.get(currLine);
                switch (lineSeverity) {
                    case ERROR: {
                        offscreenGraphics.setColor(ERROR_BACKGROUND);
                        break;
                    }
                    case WARNING: {
                        offscreenGraphics.setColor(WARNING_BACKGROUND);
                        break;
                    }
                    case INFO: {
                        offscreenGraphics.setColor(INFO_BACKGROUND);
                    }
                }
                if (lineSeverity != FileInfo.MessageKind.SUCCESS) {
                    offscreenGraphics.fillRect(0, y - ascent, this.getWidth(), ascent + descent);
                }
            } else {
                offscreenGraphics.setFont(positioningInfo.getPlainFont());
            }
            if (!isLineTextVisible) continue;
            this.drawString(offscreenGraphics, toShow, x, y, currLine, firstColumn, lineSeverity);
        }
        if (this.toShowLocations) {
            this.drawLocations(offscreenGraphics);
        }
        this.activeAreas.clear();
        if (this.colorDispatcher != null && (fileLocInfo = this.colorDispatcher.getFileLocationInfo()) instanceof JavaFileLocationInfo) {
            JavaFileLocationInfo jfli = (JavaFileLocationInfo)fileLocInfo;
            for (int currLine = firstLine; currLine <= lastLine; ++currLine) {
                Map<LinkInfo, List<ElementRange>> sequences = jfli.getAllSequencesForLine(currLine);
                if (sequences.isEmpty()) continue;
                for (Map.Entry<LinkInfo, List<ElementRange>> entry : sequences.entrySet()) {
                    LinkInfo linkInfo = entry.getKey();
                    for (ElementRange elRange : entry.getValue()) {
                        Rectangle rect = this.drawActiveArea(offscreenGraphics, elRange, linkInfo);
                        ActiveArea aarea = new ActiveArea();
                        aarea.linkInfo = linkInfo;
                        aarea.activeRectangle = rect;
                        this.activeAreas.add(aarea);
                    }
                }
            }
        }
        g.drawImage(this.offscreenImage, 0, 0, null);
    }

    @Override
    public final void setSize(int width, int height) {
        super.setSize(width, height);
        this.reallocateBuffer();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.reallocateBuffer();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.reallocateBuffer();
    }

    public void reallocateBuffer() {
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return;
        }
        this.offscreenImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
    }

    private void drawString(Graphics2D g, String str, int x, int y, int lineIndex, int firstColumnIndex, FileInfo.MessageKind severity) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        if (!this.toShowColors) {
            int charWidth = positioningInfo.getSingleCharacterWidth();
            int startX = x;
            g.setColor(severity == FileInfo.MessageKind.ERROR ? Color.red : Color.black);
            char[] arr$ = str.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character c = Character.valueOf(arr$[i$]);
                g.drawString("" + c, startX, y);
                startX += charWidth;
            }
        } else {
            int charWidth = positioningInfo.getSingleCharacterWidth();
            int charHeight = positioningInfo.getSingleCharacterHeight();
            int startX = x;
            int column = firstColumnIndex;
            char[] arr$ = str.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Font font;
                Color foregrColor;
                Character c = Character.valueOf(arr$[i$]);
                ElementLocationInfo currElemInfo = this.colorDispatcher.getFileLocationInfo().getElement(lineIndex, column);
                Color color = foregrColor = currElemInfo == null ? Color.black : this.colorDispatcher.getForegroundColor(currElemInfo);
                if (severity == FileInfo.MessageKind.SUCCESS) {
                    Color backgrColor = currElemInfo == null ? Color.white : this.colorDispatcher.getBackgroundColor(currElemInfo);
                    g.setColor(backgrColor);
                    g.fillRect(startX, y - charHeight + positioningInfo.getFontDescent(), charWidth, charHeight);
                }
                if (severity == FileInfo.MessageKind.ERROR) {
                    double coef = 0.2;
                    int rc = (int)(255.0 - coef * (double)(255 - foregrColor.getRed()));
                    int gc = (int)(coef * (double)foregrColor.getGreen());
                    int bc = (int)(coef * (double)foregrColor.getBlue());
                    g.setColor(new Color(rc, gc, bc));
                } else {
                    g.setColor(foregrColor);
                }
                boolean isFontBold = false;
                if (currElemInfo != null && this.colorDispatcher.isBold(currElemInfo)) {
                    isFontBold = true;
                }
                if (severity == FileInfo.MessageKind.ERROR) {
                    isFontBold = true;
                }
                Font font2 = font = isFontBold ? positioningInfo.getBoldFont() : positioningInfo.getPlainFont();
                if (isFontBold) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                g.setFont(font);
                g.drawString("" + c, startX, y);
                startX += charWidth;
                ++column;
            }
        }
    }

    private void drawLocations(Graphics2D g) {
        int firstColumn = (int)Math.floor(this.firstColumnIndex);
        firstColumn = Math.max(0, firstColumn);
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        int offsetx = (int)(this.firstColumnIndex * (double)positioningInfo.getSingleCharacterWidth());
        Font smallFont = this.globalSettings.getPositioningInfo().getBaseFont().deriveFont(1, 10.0f);
        for (Map.Entry<Location, Integer> loc : this.elementLocations.entrySet()) {
            int locLine = loc.getKey().getLineNumber();
            int locColumn = loc.getKey().getColumnNumber();
            int eventType = loc.getValue();
            int offsety = (int)(((double)locLine - this.topLineIndex) * (double)positioningInfo.getSingleCharacterHeight()) - positioningInfo.getFontDescent();
            int posx = locColumn * positioningInfo.getSingleCharacterWidth() - offsetx;
            g.setColor(Color.red);
            int topY = offsety - positioningInfo.getFontAscent() + 2;
            int bottomY = offsety + positioningInfo.getFontDescent() - 1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawLine(posx, topY, posx, bottomY);
            g.drawPolyline(new int[]{posx, posx - 4, posx - 4, posx - 7, posx - 4, posx - 4}, new int[]{topY, topY, topY - 2, topY, topY + 2, topY}, 6);
            g.drawPolyline(new int[]{posx, posx - 4, posx - 4, posx - 7, posx - 4, posx - 4}, new int[]{bottomY, bottomY, bottomY - 2, bottomY, bottomY + 2, bottomY}, 6);
            g.setFont(smallFont);
            g.setColor(new Color(0, 0, 128));
            g.drawString(XmlLocationParser.getEventAbbrev(eventType), posx + 1, bottomY + 2);
        }
    }

    private Rectangle drawActiveArea(Graphics2D g, ElementRange activeArea, LinkInfo linkInfo) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        int offsetx = (int)(this.firstColumnIndex * (double)positioningInfo.getSingleCharacterWidth());
        int startx = activeArea.getColumnStart() * positioningInfo.getSingleCharacterWidth() - offsetx - 1;
        int endx = (activeArea.getColumnEnd() + 1) * positioningInfo.getSingleCharacterWidth() - offsetx;
        int offsety = (int)(((double)(activeArea.getLineStart() + 1) - this.topLineIndex) * (double)positioningInfo.getSingleCharacterHeight()) - positioningInfo.getFontDescent();
        int topY = offsety - positioningInfo.getFontAscent() + 2;
        int bottomY = offsety + positioningInfo.getFontDescent();
        Rectangle activeRect = new Rectangle(startx, topY, endx - startx, bottomY - topY);
        boolean isActive = this.linkCallback == null ? false : this.linkCallback.isActive(linkInfo);
        g.setColor(isActive ? ACTIVE_LINK_BORDER : PASSIVE_LINK_BORDER);
        g.drawPolygon(IdeImageCreator.getRoundedRectangle(activeRect));
        return activeRect;
    }

    public final void setLines(String[] lines) {
        this.lines = lines;
        this.maxColumnCount = 0;
        for (String str : this.lines) {
            this.maxColumnCount = Math.max(this.maxColumnCount, str.length());
        }
        this.setFirstVisibleColumn(0.0);
        this.setFirstVisibleLine(0.0);
        this.currFileStatus = FileStatus.INITIAL;
    }

    public String[] getLines() {
        return this.lines;
    }

    public final void setMessageLines(Map<Integer, FileInfo.MessageKind> messageLines) {
        this.messageLines = messageLines;
    }

    public final int getTotalWidthInPixels() {
        return this.maxColumnCount * this.globalSettings.getPositioningInfo().getSingleCharacterWidth();
    }

    public final int getTotalHeightInPixels() {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        return positioningInfo.getSingleCharacterHeight() * this.lines.length + positioningInfo.getFontDescent();
    }

    public final int getSingleLineHeightInPixels() {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        return positioningInfo.getSingleCharacterHeight();
    }

    public final double setFirstVisibleLine(double lineStart) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        this.topLineIndex = lineStart;
        this.bottomLineIndex = lineStart + (double)this.getHeight() / (double)positioningInfo.getSingleCharacterHeight();
        if (this.bottomLineIndex >= (double)this.getLineCount()) {
            double delta = this.bottomLineIndex - (double)this.getLineCount();
            double newTopLineIndex = this.topLineIndex - delta;
            if (newTopLineIndex < 0.0) {
                delta += newTopLineIndex;
            }
            this.topLineIndex -= delta;
            this.bottomLineIndex -= delta;
        }
        if (this.topLineIndex < 0.0) {
            this.bottomLineIndex -= this.topLineIndex;
            this.topLineIndex = 0.0;
        }
        this.paintAll(this.getGraphics());
        return this.topLineIndex;
    }

    public final double setFirstVisibleColumn(double colStart) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        this.firstColumnIndex = colStart;
        this.lastColumnIndex = colStart + (double)this.getWidth() / (double)positioningInfo.getSingleCharacterWidth();
        if (this.lastColumnIndex >= (double)this.maxColumnCount) {
            double delta = this.lastColumnIndex - (double)this.maxColumnCount;
            double newFirstColumnIndex = this.firstColumnIndex - delta;
            if (newFirstColumnIndex < 0.0) {
                delta += newFirstColumnIndex;
            }
            this.firstColumnIndex -= delta;
            this.lastColumnIndex -= delta;
        }
        if (this.firstColumnIndex < 0.0) {
            this.lastColumnIndex -= this.firstColumnIndex;
            this.firstColumnIndex = 0.0;
        }
        this.paintAll(this.getGraphics());
        return this.firstColumnIndex;
    }

    public final boolean isEmpty() {
        return this.lines == null;
    }

    public final int getLineCount() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.lines.length;
    }

    public final int getMaximalColumns() {
        return this.maxColumnCount;
    }

    public final double getTopLine() {
        return this.topLineIndex;
    }

    public final double getFirstColumn() {
        return this.firstColumnIndex;
    }

    public final double getRelativeVerticalPosition(int lineNumber) {
        return (double)lineNumber / (double)this.getLineCount();
    }

    public final double getAbsoluteVerticalPosition(int lineNumber) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        return ((double)lineNumber - this.topLineIndex) * (double)positioningInfo.getSingleCharacterHeight();
    }

    public final double getVisibleLinesCount() {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        return this.getHeight() / positioningInfo.getSingleCharacterHeight();
    }

    public void setColorDispatcher(ColorDispatcher colorDispatcher) {
        this.toShowColors = true;
        this.colorDispatcher = colorDispatcher;
    }

    public void removeColors() {
        this.toShowColors = false;
    }

    public void setToShowLocations(Map<Location, Integer> elementLoc) {
        this.toShowLocations = true;
        this.elementLocations = elementLoc;
    }

    private ActiveArea getActiveArea(MouseEvent mouseEvent) {
        for (ActiveArea activeArea : this.activeAreas) {
            if (!activeArea.activeRectangle.contains(mouseEvent.getPoint())) continue;
            return activeArea;
        }
        return null;
    }

    public int getLineNumber(int x, int y) {
        PositioningInfo positioningInfo = this.globalSettings.getPositioningInfo();
        int currLine = (int)Math.floor((double)(y + positioningInfo.getFontDescent()) / (double)positioningInfo.getSingleCharacterHeight() + this.topLineIndex + 1.0);
        if (currLine >= this.lines.length) {
            return -1;
        }
        return currLine;
    }

    public String getContents(int lineNumber) {
        return this.lines[lineNumber - 1];
    }

    public void replaceLine(int lineNumber, String newContents) {
        this.lines[lineNumber - 1] = newContents;
    }

    public void startEditing() {
        this.prevFileStatus = this.currFileStatus;
        this.currFileStatus = FileStatus.EDITING;
    }

    public void cancelEditing() {
        this.currFileStatus = this.prevFileStatus;
    }

    public void endEditing() {
        this.currFileStatus = FileStatus.MODIFIED;
    }

    public boolean hasBeenEdited() {
        return this.currFileStatus != FileStatus.INITIAL;
    }

    public PositioningInfo getPositioningInfo() {
        return this.globalSettings.getPositioningInfo();
    }

    public GlobalSettings getGlobalSettings() {
        return this.globalSettings;
    }

    public void addLinkListener(LinkListener linkListener) {
        this.linkListeners.add(linkListener);
    }

    public void removeLinkListener(LinkListener linkListener) {
        this.linkListeners.remove(linkListener);
    }

    public void setLinkCallback(LinkCallback linkCallback) {
        this.linkCallback = linkCallback;
    }

    private class ActiveAreaMouseListener
    extends MouseInputAdapter {
        private LinkInfo prevUnderMouse;
        private StringListPanel panel;

        public ActiveAreaMouseListener(StringListPanel panel) {
            this.panel = panel;
            this.prevUnderMouse = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent e) {
            LinkEvent le;
            ActiveArea activeArea;
            block11: {
                activeArea = this.panel.getActiveArea(e);
                if (this.prevUnderMouse != null && activeArea == null) {
                    le = new LinkEvent(this.panel, 2, this.prevUnderMouse);
                    for (LinkListener ll : StringListPanel.this.linkListeners) {
                        ll.linkActivated(le);
                    }
                }
                if (activeArea != null && StringListPanel.this.linkCallback != null) break block11;
                this.panel.setCursor(Cursor.getPredefinedCursor(0));
                this.panel.setToolTipText(null);
                this.prevUnderMouse = activeArea == null ? null : activeArea.linkInfo;
                return;
            }
            try {
                if (this.prevUnderMouse != activeArea.linkInfo) {
                    if (this.prevUnderMouse != null) {
                        le = new LinkEvent(this.panel, 2, this.prevUnderMouse);
                        for (LinkListener ll : StringListPanel.this.linkListeners) {
                            ll.linkActivated(le);
                        }
                    }
                    le = new LinkEvent(this.panel, 1, activeArea.linkInfo);
                    for (LinkListener ll : StringListPanel.this.linkListeners) {
                        ll.linkActivated(le);
                    }
                }
                Cursor cursor = StringListPanel.this.linkCallback.getCursor(activeArea.linkInfo);
                this.panel.setCursor(cursor);
                if (activeArea != null) {
                    this.panel.setToolTipText(Util.getTooltipText(activeArea.linkInfo.getHtmlComment()));
                } else {
                    this.panel.setToolTipText(null);
                }
                this.prevUnderMouse = activeArea == null ? null : activeArea.linkInfo;
            }
            catch (Throwable throwable) {
                this.prevUnderMouse = activeArea == null ? null : activeArea.linkInfo;
                throw throwable;
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.panel.setCursor(Cursor.getPredefinedCursor(0));
            this.panel.setToolTipText(null);
            final ActiveArea activeArea = this.panel.getActiveArea(e);
            if (activeArea == null || StringListPanel.this.linkCallback == null) {
                return;
            }
            boolean toActivate = StringListPanel.this.linkCallback.isActive(activeArea.linkInfo);
            if (toActivate) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LinkEvent le = new LinkEvent(StringListPanel.this, 0, activeArea.linkInfo);
                        for (LinkListener ll : StringListPanel.this.linkListeners) {
                            ll.linkActivated(le);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileStatus {
        INITIAL,
        EDITING,
        MODIFIED;

    }

    private static class ActiveArea {
        public Rectangle activeRectangle;
        public LinkInfo linkInfo;

        private ActiveArea() {
        }
    }
}

