/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class ScrollGridTable
extends JScrollPane {
    private final GridTable gridTable;
    public static final Color GRID_COLOR = new Color(220, 208, 200);

    private ScrollGridTable(GridTable table) {
        super(table);
        this.gridTable = table;
        this.setBorder(null);
        this.getViewport().setBackground(Color.white);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ScrollGridTable.this.repaint();
            }
        });
        this.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ScrollGridTable.this.repaint();
            }
        });
    }

    public static ScrollGridTable getInstance() {
        GridTable table = new GridTable();
        table.setAutoResizeMode(0);
        table.setDragEnabled(false);
        table.setSelectionMode(0);
        table.getTableHeader().setReorderingAllowed(false);
        table.setShowGrid(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setAutoCreateColumnsFromModel(false);
        ScrollGridTable instance = new ScrollGridTable(table);
        table.setOwner(instance);
        return instance;
    }

    public final GridTable getGridTable() {
        return this.gridTable;
    }

    public final void paint(Graphics g) {
        super.paint(g);
        if (this.gridTable == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(GRID_COLOR);
        int columnCount = this.gridTable.getColumnModel().getColumnCount();
        Dimension viewportSize = this.getViewport().getSize();
        int viewportHeight = this.getHeight();
        Insets insets = this.getInsets();
        viewportHeight -= insets.bottom + insets.top;
        if (this.getHorizontalScrollBar().isVisible()) {
            viewportHeight -= this.getHorizontalScrollBar().getHeight();
        }
        int viewportWidth = this.getViewport().getWidth();
        int currColumnLocation = -((int)this.getViewport().getViewRect().getMinX());
        for (int i = 0; i < columnCount && (currColumnLocation += this.gridTable.getColumnModel().getColumn(i).getWidth()) < viewportWidth; ++i) {
            graphics.drawLine(currColumnLocation, 0, currColumnLocation, viewportHeight);
        }
        JTableHeader tableHeader = this.gridTable.getTableHeader();
        for (int currRowLocation = -((int)this.getViewport().getViewRect().getMinY()) + tableHeader.getHeight(); currRowLocation < viewportHeight; currRowLocation += this.gridTable.getRowHeight()) {
            if (currRowLocation < tableHeader.getHeight()) continue;
            graphics.drawLine(0, currRowLocation, (int)viewportSize.getWidth(), currRowLocation);
        }
        if (this.gridTable.isResizing) {
            graphics.setColor(Color.black);
            graphics.setStroke(new BasicStroke(2.0f));
            int markerPosition = this.gridTable.currDividerPositionX - (int)this.getViewport().getViewRect().getMinX();
            graphics.drawLine(markerPosition, 0, markerPosition, this.getHeight());
        }
    }

    public static final class GridTable
    extends JTable {
        private final Map<Integer, Boolean> isResizableMap;
        private boolean isResizing;
        private int indexOfResizingColumn;
        private int currDividerPositionX;
        private int resizingColumnLeftPixel;
        private static final int MIN_COLUMN_WIDTH = 20;
        private static final int RESIZE_COLUMNS_SENSITIVITY = 3;
        private ScrollGridTable owner;
        private boolean firstDisplayed = true;

        public GridTable() {
            this.setBorder(null);
            this.setBackground(Color.white);
            this.isResizableMap = new HashMap<Integer, Boolean>();
            this.getTableHeader().setResizingAllowed(false);
            this.getTableHeader().addMouseListener(new GridTableMouseListener(this));
            this.getTableHeader().addMouseMotionListener(new GridTableMouseMotionListener(this));
            this.getSelectionModel().addListSelectionListener(new GridTableSelectionListener(this));
            this.isResizing = false;
        }

        public final boolean getScrollableTracksViewportWidth() {
            return this.firstDisplayed && this.getAutoResizeMode() == 0 ? this.getPreferredSize().width < this.getParent().getWidth() : super.getScrollableTracksViewportWidth();
        }

        public final void doLayout() {
            super.doLayout();
            if (this.firstDisplayed && this.getWidth() > 0 && this.owner.getWidth() > 0) {
                this.firstDisplayed = false;
                LinkedList<TableColumn> columnsToResize = new LinkedList<TableColumn>();
                int totalWidthLeft = this.getWidth();
                Enumeration<TableColumn> i = this.getColumnModel().getColumns();
                while (i.hasMoreElements()) {
                    TableColumn c = i.nextElement();
                    if (c.getPreferredWidth() == 0) {
                        columnsToResize.add(c);
                        continue;
                    }
                    totalWidthLeft -= c.getPreferredWidth();
                    c.setWidth(c.getPreferredWidth());
                }
                if (columnsToResize.size() > 0) {
                    int widthPerColumn = totalWidthLeft / columnsToResize.size();
                    if (widthPerColumn <= 0) {
                        widthPerColumn = 50;
                    }
                    for (TableColumn c : columnsToResize) {
                        c.setPreferredWidth(widthPerColumn);
                        c.setWidth(c.getPreferredWidth());
                    }
                }
                this.revalidate();
            }
        }

        public final void setOwner(ScrollGridTable owner) {
            this.owner = owner;
        }

        public final boolean isResizable(int columnIndex) {
            if (this.isResizableMap.containsKey(columnIndex)) {
                return this.isResizableMap.get(columnIndex);
            }
            return false;
        }

        public final void setResizable(int columnIndex, boolean isResizable) {
            this.isResizableMap.put(columnIndex, isResizable);
        }

        public final void startedResizing(MouseEvent e, int resizingColumn) {
            this.isResizing = true;
            this.indexOfResizingColumn = resizingColumn;
            this.currDividerPositionX = e.getX();
            this.resizingColumnLeftPixel = 0;
            for (int columnIndex = 0; columnIndex < resizingColumn; ++columnIndex) {
                this.resizingColumnLeftPixel += this.getColumnModel().getColumn(columnIndex).getWidth();
            }
        }

        public final void resizing(MouseEvent e) {
            this.currDividerPositionX = e.getX();
            if (this.currDividerPositionX < this.resizingColumnLeftPixel + 20) {
                this.currDividerPositionX = this.resizingColumnLeftPixel + 20;
            }
            this.owner.repaint();
        }

        public final void finishedResizing(MouseEvent e) {
            this.isResizing = false;
            TableColumn column = this.getColumnModel().getColumn(this.indexOfResizingColumn);
            column.setPreferredWidth(this.currDividerPositionX - this.resizingColumnLeftPixel);
            this.owner.repaint();
        }

        public final int getResizableColumnIndex(MouseEvent e) {
            TableColumnModel colModel = this.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(e.getX());
            if (vColIndex == -1) {
                return -1;
            }
            Rectangle headerRect = this.getTableHeader().getHeaderRect(vColIndex);
            if (vColIndex == 0) {
                headerRect.width -= 3;
            } else {
                headerRect.grow(-3, 0);
            }
            if (headerRect.contains(e.getX(), e.getY())) {
                return -1;
            }
            int vLeftColIndex = vColIndex;
            if (e.getX() < headerRect.x) {
                --vLeftColIndex;
            }
            if (this.isResizable(vLeftColIndex)) {
                return vLeftColIndex;
            }
            return -1;
        }

        private static final class GridTableSelectionListener
        implements ListSelectionListener {
            final GridTable table;

            GridTableSelectionListener(GridTable table) {
                this.table = table;
            }

            public final void valueChanged(ListSelectionEvent e) {
                this.table.owner.repaint();
            }
        }

        private static final class GridTableMouseMotionListener
        extends MouseMotionAdapter {
            private final GridTable gridTable;

            public GridTableMouseMotionListener(GridTable gridTable) {
                this.gridTable = gridTable;
            }

            public final void mouseMoved(MouseEvent e) {
                if (!this.gridTable.isResizing) {
                    int colIndex = this.gridTable.getResizableColumnIndex(e);
                    int cursorType = colIndex < 0 ? 0 : 11;
                    this.gridTable.getTableHeader().setCursor(Cursor.getPredefinedCursor(cursorType));
                }
            }

            public final void mouseDragged(MouseEvent e) {
                if (this.gridTable.isResizing) {
                    this.gridTable.resizing(e);
                }
            }
        }

        private static final class GridTableMouseListener
        extends MouseAdapter {
            private final GridTable gridTable;

            public GridTableMouseListener(GridTable gridTable) {
                this.gridTable = gridTable;
            }

            public final void mousePressed(MouseEvent e) {
                if (!this.gridTable.isResizing) {
                    int colIndex = this.gridTable.getResizableColumnIndex(e);
                    if (colIndex < 0) {
                        return;
                    }
                    this.gridTable.startedResizing(e, colIndex);
                }
            }

            public final void mouseReleased(MouseEvent e) {
                if (this.gridTable.isResizing) {
                    this.gridTable.finishedResizing(e);
                }
            }
        }
    }
}

