/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jvnet.flamingo.ide.ScrollGridTable;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.util.Util;

public final class MessagePanel
extends JPanel {
    private final ScrollGridTable scrollGridTable;

    public MessagePanel() {
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.scrollGridTable = ScrollGridTable.getInstance();
        this.add((Component)this.scrollGridTable, "Center");
        ScrollGridTable.GridTable gridTable = this.scrollGridTable.getGridTable();
        gridTable.setDefaultRenderer(Object.class, new MessageTableCellRenderer());
        gridTable.addMouseMotionListener(new MessagePanelMouseMotionListener(gridTable));
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn iconColumn = new TableColumn(0, 20);
        iconColumn.setHeaderValue("");
        iconColumn.setHeaderRenderer(new MessageTableColumnHeaderRenderer());
        TableColumn descrColumn = new TableColumn(1, 0);
        descrColumn.setHeaderValue("Description");
        descrColumn.setHeaderRenderer(new MessageTableColumnHeaderRenderer());
        TableColumn locationColumn = new TableColumn(2, 70);
        locationColumn.setHeaderValue("Location");
        locationColumn.setHeaderRenderer(new MessageTableColumnHeaderRenderer());
        tcm.addColumn(iconColumn);
        tcm.addColumn(descrColumn);
        tcm.addColumn(locationColumn);
        gridTable.setColumnModel(tcm);
        gridTable.setResizable(1, true);
        gridTable.setResizable(2, true);
    }

    public final void setFileInformation(FileInfo fileInfo) {
        MessageTableModel tableModel = new MessageTableModel(fileInfo);
        ScrollGridTable.GridTable gridTable = this.scrollGridTable.getGridTable();
        gridTable.setModel(tableModel);
    }

    public final ScrollGridTable getScrollGridTable() {
        return this.scrollGridTable;
    }

    public static void main(String ... args) {
        JFrame fr = new JFrame("Table test");
        fr.setSize(500, 200);
        fr.setLocation(200, 200);
        fr.setLayout(new BorderLayout());
        MessagePanel ep = new MessagePanel();
        FileInfo sei = new FileInfo("cool");
        sei.addError(10, "message1");
        sei.addError(10, "message1");
        sei.addError(10, "message1");
        sei.addError(10, "message1");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(20, "message2");
        sei.addError(30, "message3");
        sei.addError(30, "message3");
        sei.addError(30, "message4");
        ep.setFileInformation(sei);
        fr.add((Component)ep, "Center");
        fr.setDefaultCloseOperation(3);
        fr.setVisible(true);
    }

    private static final class MessagePanelMouseMotionListener
    extends MouseMotionAdapter {
        private final ScrollGridTable.GridTable gridTable;

        public MessagePanelMouseMotionListener(ScrollGridTable.GridTable gridTable) {
            this.gridTable = gridTable;
        }

        public final void mouseMoved(MouseEvent e) {
            int rowIndex = this.gridTable.rowAtPoint(e.getPoint());
            if (rowIndex < 0) {
                this.gridTable.setToolTipText(null);
            } else {
                MessageTableModel model = (MessageTableModel)this.gridTable.getModel();
                FileInfo.MessageKind messageKind = model.getMessageKind(rowIndex);
                String message = model.getMessage(rowIndex);
                FileInfo.LineInfo lineInfo = new FileInfo.LineInfo(model.getLineNumber(rowIndex));
                lineInfo.addMessage(messageKind, message);
                this.gridTable.setToolTipText(Util.getTooltipText(lineInfo));
            }
        }
    }

    private static final class MessageTableColumnHeaderRenderer
    implements TableCellRenderer {
        private final JLabel textLabel = new JLabel();
        private static final Font font = new Font("Tahoma", 0, 11);

        public MessageTableColumnHeaderRenderer() {
            this.textLabel.setOpaque(false);
            this.textLabel.setBorder(BorderFactory.createBevelBorder(0));
            this.textLabel.setFont(font);
        }

        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                this.textLabel.setText("  " + value);
                return this.textLabel;
            }
            throw new IllegalStateException("Unknown Object to paint: " + value);
        }
    }

    private static final class MessageTableCellRenderer
    implements TableCellRenderer {
        private final JLabel messageIconLabel = new JLabel();
        private final JPanel messageIconPanel;
        private final JLabel textLabel;
        private static final Color SELECTION_COLOR = new Color(0, 0, 128);
        private static final Font font = new Font("Tahoma", 0, 11);

        public MessageTableCellRenderer() {
            this.messageIconLabel.setOpaque(false);
            this.messageIconLabel.setBorder(null);
            this.messageIconPanel = new JPanel();
            FlowLayout fl = new FlowLayout(1, 0, 0);
            this.messageIconPanel.setLayout(fl);
            this.messageIconPanel.add(this.messageIconLabel);
            this.messageIconPanel.setBorder(null);
            this.textLabel = new JLabel();
            this.textLabel.setOpaque(false);
            this.textLabel.setBorder(null);
            this.textLabel.setFont(font);
        }

        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof FileInfo.MessageKind) {
                if (table.getSelectedRow() == row) {
                    this.messageIconLabel.setBackground(SELECTION_COLOR);
                    this.messageIconLabel.setOpaque(true);
                } else {
                    this.messageIconLabel.setBackground(Color.white);
                    this.messageIconLabel.setOpaque(false);
                }
                this.messageIconLabel.setIcon(((FileInfo.MessageKind)((Object)value)).getAbsoluteIconMarker(13));
                return this.messageIconPanel;
            }
            if (value instanceof String) {
                this.textLabel.setText("  " + value);
                if (table.getSelectedRow() == row) {
                    this.textLabel.setBackground(SELECTION_COLOR);
                    this.textLabel.setOpaque(true);
                    this.textLabel.setForeground(Color.white);
                } else {
                    this.textLabel.setBackground(Color.white);
                    this.textLabel.setOpaque(false);
                    this.textLabel.setForeground(Color.black);
                }
                return this.textLabel;
            }
            throw new IllegalStateException("Unknown Object to paint: " + value);
        }
    }

    public static final class MessageTableModel
    extends AbstractTableModel {
        private final ArrayList<FileInfo.MessageInfo> messages = new ArrayList();
        private final String[] columnNames;

        public MessageTableModel(FileInfo fileInfo) {
            for (FileInfo.LineInfo currLine : fileInfo.getMessages()) {
                for (FileInfo.MessageInfo messageInfo : currLine.getMessages()) {
                    this.messages.add(messageInfo);
                }
            }
            Collections.sort(this.messages, new Comparator<FileInfo.MessageInfo>(){

                @Override
                public int compare(FileInfo.MessageInfo info1, FileInfo.MessageInfo info2) {
                    FileInfo.MessageKind kind2;
                    FileInfo.MessageKind kind1 = info1.getKind();
                    int kindComp = FileInfo.MessageKind.compare(kind1, kind2 = info2.getKind());
                    if (kindComp != 0) {
                        return kindComp;
                    }
                    int lineDiff = info1.getLineNumber() - info2.getLineNumber();
                    if (lineDiff != 0) {
                        return lineDiff;
                    }
                    int strComp = info1.getText().compareTo(info2.getText());
                    if (strComp != 0) {
                        return strComp;
                    }
                    if (info1 == info2) {
                        return 0;
                    }
                    return info1.hashCode() - info2.hashCode();
                }
            });
            this.columnNames = new String[]{"", "Description", "Location"};
        }

        public final int getColumnCount() {
            return this.columnNames.length;
        }

        public final int getRowCount() {
            return this.messages.size();
        }

        public final Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.messages.get(rowIndex).getKind();
                }
                case 1: {
                    return this.messages.get(rowIndex).getText();
                }
                case 2: {
                    return "line " + (this.messages.get(rowIndex).getLineNumber() + 1);
                }
            }
            return null;
        }

        public final int getLineNumber(int rowIndex) {
            return this.messages.get(rowIndex).getLineNumber();
        }

        public final String getMessage(int rowIndex) {
            return this.messages.get(rowIndex).getText();
        }

        public final FileInfo.MessageKind getMessageKind(int rowIndex) {
            return this.messages.get(rowIndex).getKind();
        }

        public final int findColumn(String columnName) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.getColumnName(i).compareTo(columnName) != 0) continue;
                return i;
            }
            throw new IllegalArgumentException("Illegal argument " + columnName);
        }

        public final String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }
    }
}

