/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.InputStream;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jvnet.flamingo.ide.BaseViewerPanel;
import org.jvnet.flamingo.ide.ColorDispatcher;
import org.jvnet.flamingo.ide.LocationParser;
import org.jvnet.flamingo.ide.MessagePanel;
import org.jvnet.flamingo.ide.ScrollGridTable;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.info.GlobalSettings;
import org.jvnet.flamingo.ide.link.LinkCallback;
import org.jvnet.flamingo.ide.link.LinkListener;

public class FileViewerPanel
extends JPanel {
    private final BaseViewerPanel baseViewer;
    private final MessagePanel messagePanel;
    private JSplitPane splitPane;
    private ComponentAdapter componentAdapter;
    private FileInfo fileInfo;

    public FileViewerPanel(GlobalSettings globalSettings) {
        this.baseViewer = new BaseViewerPanel(globalSettings);
        this.messagePanel = new MessagePanel();
    }

    public final BaseViewerPanel getBaseViewer() {
        return this.baseViewer;
    }

    public void setContents(InputStream stream, FileInfo fileInfo, LocationParser locationParser, ColorDispatcher colorDispatcher) {
        this.removeAll();
        this.fileInfo = fileInfo;
        this.messagePanel.setFileInformation(fileInfo);
        this.baseViewer.setContents(stream, fileInfo, locationParser, colorDispatcher);
        this.baseViewer.setMinimumSize(new Dimension(100, 100));
        this.setLayout(new BorderLayout());
        if (fileInfo != null && fileInfo.getMessages().size() > 0) {
            this.showMessagePanel();
        } else {
            this.hideMessagePanel();
            this.add((Component)this.baseViewer, "Center");
        }
    }

    public void hideMessagePanel() {
        if (this.splitPane == null) {
            return;
        }
        this.remove(this.splitPane);
        this.splitPane = null;
        this.add((Component)this.baseViewer, "Center");
        this.removeComponentListener(this.componentAdapter);
    }

    public void showMessagePanel() {
        this.messagePanel.setFileInformation(this.fileInfo);
        this.baseViewer.getTextPanel().setMessageLines(this.fileInfo.getLineMap());
        if (this.splitPane != null) {
            return;
        }
        this.remove(this.baseViewer);
        this.messagePanel.setMinimumSize(new Dimension(100, 50));
        this.splitPane = new JSplitPane(0, this.baseViewer, this.messagePanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation((int)((double)this.getHeight() * 0.8));
        this.componentAdapter = new ComponentAdapter(){
            boolean isFirstTime = true;

            public void componentResized(ComponentEvent e) {
                FileViewerPanel.this.setVisible(false);
                super.componentResized(e);
                if (this.isFirstTime && FileViewerPanel.this.getHeight() > 0) {
                    FileViewerPanel.this.splitPane.setDividerLocation((int)(0.8 * (double)FileViewerPanel.this.getHeight()));
                    this.isFirstTime = false;
                    FileViewerPanel.this.validate();
                } else {
                    FileViewerPanel.this.splitPane.setResizeWeight(0.5);
                }
                FileViewerPanel.this.setVisible(true);
            }
        };
        this.addComponentListener(this.componentAdapter);
        this.messagePanel.getScrollGridTable().getGridTable().getSelectionModel().addListSelectionListener(new MessageSelectionHandler(this));
    }

    public void addLinkListener(LinkListener linkListener) {
        this.baseViewer.getTextPanel().addLinkListener(linkListener);
    }

    public void removeLinkListener(LinkListener linkListener) {
        this.baseViewer.getTextPanel().removeLinkListener(linkListener);
    }

    public void setLinkCallback(LinkCallback linkCallback) {
        this.baseViewer.getTextPanel().setLinkCallback(linkCallback);
    }

    public int getLineCount() {
        return this.baseViewer.getTextPanel().getLineCount();
    }

    public final void scrollToLine(int lineNumber) {
        this.baseViewer.scrollToLine(lineNumber);
    }

    private static final class MessageSelectionHandler
    implements ListSelectionListener {
        private final FileViewerPanel viewerPanel;

        public MessageSelectionHandler(FileViewerPanel viewerPanel) {
            this.viewerPanel = viewerPanel;
        }

        public final void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ScrollGridTable.GridTable src = MessageSelectionHandler.this.viewerPanel.messagePanel.getScrollGridTable().getGridTable();
                    int selectedRow = src.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    MessagePanel.MessageTableModel model = (MessagePanel.MessageTableModel)src.getModel();
                    MessageSelectionHandler.this.viewerPanel.baseViewer.scrollToLine(model.getLineNumber(selectedRow));
                }
            });
        }
    }
}

