/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.JButtonStrip;
import org.jvnet.flamingo.common.ui.ButtonStripUI;

public class BasicButtonStripUI
extends ButtonStripUI {
    protected JButtonStrip buttonStrip;

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonStripUI();
    }

    public void installUI(JComponent c) {
        this.buttonStrip = (JButtonStrip)c;
        c.setLayout(this.createLayoutManager());
        c.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.buttonStrip = null;
    }

    public void paint(Graphics g, JComponent c) {
        int buttonCount = this.buttonStrip.getButtonCount();
        Insets insets = c.getInsets();
        for (int i = 0; i < buttonCount; ++i) {
            AbstractButton currButton = this.buttonStrip.getButton(i);
            boolean isFirst = this.buttonStrip.isFirst(currButton);
            boolean isLast = this.buttonStrip.isLast(currButton);
            Graphics2D graphics = (Graphics2D)g.create(currButton.getX(), currButton.getY(), currButton.getWidth(), currButton.getHeight());
            if (this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                this.paintStripButton(graphics, currButton, isFirst, isLast, c.getWidth() - insets.left - insets.right, currButton.getX());
            } else {
                this.paintStripButton(graphics, currButton, isFirst, isLast, c.getHeight() - insets.top - insets.bottom, currButton.getY());
            }
            graphics.dispose();
        }
    }

    protected void paintStripButton(Graphics g, AbstractButton button, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        this.paintStripButtonBackground(g, button, isFirst, isLast, totalStripDimension, relativeOffset);
        this.paintButtonContents(g, button);
        this.paintStripButtonBorder(g, button, isFirst, isLast);
    }

    protected void paintButtonContents(Graphics g, AbstractButton button) {
        button.paint(g);
    }

    protected void paintStripButtonBackground(Graphics g, AbstractButton button, boolean isFirst, boolean isLast, int totalStripDimension, int relativeOffset) {
        if (button.isOpaque()) {
            g.setColor(button.getBackground());
            g.fillRect(0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected void paintStripButtonBorder(Graphics g, AbstractButton button, boolean isFirst, boolean isLast) {
        Border border = button.getBorder();
        if (border != null) {
            border.paintBorder(button, g, 0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int i;
            int width = 0;
            int height = 0;
            if (BasicButtonStripUI.this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                for (i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    width += BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width;
                    height = Math.max(height, BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height);
                }
            } else {
                for (i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    height += BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height;
                    width = Math.max(width, BasicButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width);
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            if (BasicButtonStripUI.this.buttonStrip.getButtonCount() == 0) {
                return;
            }
            Insets ins = c.getInsets();
            int height = c.getHeight() - ins.top - ins.bottom;
            int width = c.getWidth() - ins.left - ins.right;
            if (BasicButtonStripUI.this.buttonStrip.getOrientation() == JButtonStrip.StripOrientation.HORIZONTAL) {
                int totalPreferredWidth = 0;
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredWidth += currButton.getPreferredSize().width;
                }
                int deltaX = (width - totalPreferredWidth) / BasicButtonStripUI.this.buttonStrip.getButtonCount();
                int x = ins.left;
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    currButton.setBounds(x, ins.top, currButton.getPreferredSize().width + deltaX, height);
                    x += currButton.getPreferredSize().width + deltaX;
                }
            } else {
                int totalPreferredHeight = 0;
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredHeight += currButton.getPreferredSize().height;
                }
                int deltaY = (height - totalPreferredHeight) / BasicButtonStripUI.this.buttonStrip.getButtonCount();
                int y = ins.top;
                for (int i = 0; i < BasicButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractButton currButton = BasicButtonStripUI.this.buttonStrip.getButton(i);
                    currButton.setBounds(ins.left, y, width, currButton.getPreferredSize().height + deltaY);
                    y += currButton.getPreferredSize().height + deltaY;
                }
            }
        }
    }
}

