/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jvnet.flamingo.bcb.ui.BasicScrollablePopupUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollablePopup
extends JPopupMenu {
    public static final int ITEMS_MAX_NUMBER = 10;
    private int maxSize = -1;
    private List<Action> actions = null;
    private int maxWidth = 0;
    public static final String SELECTED_PROP = "ScrollablePopup.selected";
    private static final String uiClassID = "ScrollablePopupUI";

    public ScrollablePopup() {
        this(10);
    }

    public ScrollablePopup(int max) {
        this.maxSize = max;
        this.actions = new Vector<Action>();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.actions.clear();
        this.maxWidth = 0;
    }

    @Override
    public JMenuItem add(Action a) {
        return this.add(a, this.getFontMetrics(this.getFont()).stringWidth((String)a.getValue("Name")));
    }

    private JMenuItem add(Action a, int w) {
        if (this.getUI().getScrollUp() != null) {
            this.getUI().getScrollUp().setEnabled(false);
        }
        this.actions.add(a);
        this.maxWidth = Math.max(w + 20, this.maxWidth);
        try {
            ((JMenuItem)this.getComponent(2)).setPreferredSize(new Dimension(this.maxWidth, (int)this.getComponent(2).getPreferredSize().getHeight()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.actions.size() >= this.maxSize + 1) {
            this.getUI().addScrollers();
            return null;
        }
        JMenuItem item = super.add(a);
        return item;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.getInvoker().repaint();
        } else {
            Point p = this.getInvoker().getLocationOnScreen();
            if (this.getLocationOnScreen().getY() != p.getY() + this.getInvoker().getPreferredSize().getHeight()) {
                p.translate((int)this.getInvoker().getPreferredSize().getWidth(), 0);
                this.setLocation(p);
            }
        }
    }

    @Override
    public void setSelected(Component sel) {
        if (sel instanceof JLabel) {
            JLabel label = (JLabel)sel;
            String actionName = label.getText();
            Action actionToSel = null;
            for (Action action : this.actions) {
                if (action.getValue("Name").toString().toLowerCase(Locale.ENGLISH).equals(actionName.toLowerCase(Locale.ENGLISH))) {
                    actionToSel = action;
                }
                action.putValue(SELECTED_PROP, Boolean.FALSE);
            }
            if (actionToSel != null) {
                actionToSel.putValue(SELECTED_PROP, Boolean.TRUE);
                this.getUI().scrollTo(this.actions.indexOf(actionToSel), true);
            }
        } else {
            if (sel instanceof JMenuItem) {
                ((JMenuItem)sel).setFont(new Font(sel.getFont().getName(), 1, sel.getFont().getSize()));
            }
            super.setSelected(sel);
            sel.requestFocus();
        }
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setUI(BasicScrollablePopupUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BasicScrollablePopupUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicScrollablePopupUI.createUI(this));
        }
    }

    @Override
    public BasicScrollablePopupUI getUI() {
        return (BasicScrollablePopupUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

